/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.cardreader.provider.api.command;

import de.gematik.ti.cardreader.provider.api.command.IResponseApdu;
import java.util.Arrays;

public class AbstractResponseApdu
implements IResponseApdu {
    private final byte[] apdu;

    AbstractResponseApdu(byte[] apdu) {
        if (apdu.length < 2) {
            throw new IllegalArgumentException("Response APDU must not have less than 2 bytes (status bytes SW1, SW2)");
        }
        this.apdu = Arrays.copyOf(apdu, apdu.length);
    }

    @Override
    public int getNr() {
        return this.apdu.length - 2;
    }

    @Override
    public byte[] getData() {
        return Arrays.copyOf(this.apdu, this.apdu.length - 2);
    }

    @Override
    public int getSW1() {
        return this.apdu[this.apdu.length - 2] & 0xFF;
    }

    @Override
    public int getSW2() {
        return this.apdu[this.apdu.length - 1] & 0xFF;
    }

    @Override
    public int getSW() {
        return this.getSW1() << 8 | this.getSW2();
    }

    @Override
    public byte[] getBytes() {
        return Arrays.copyOf(this.apdu, this.apdu.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractResponseApdu)) {
            return false;
        }
        AbstractResponseApdu that = (AbstractResponseApdu)o;
        return Arrays.equals(this.apdu, that.apdu);
    }

    public int hashCode() {
        return Arrays.hashCode(this.apdu);
    }
}

