/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.cardreader.provider.api.command;

import de.gematik.ti.cardreader.provider.api.command.AbstractApdu;
import de.gematik.ti.cardreader.provider.api.command.ICommandApdu;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public abstract class AbstractCommandApdu
extends AbstractApdu
implements ICommandApdu {
    private final byte[] header = new byte[4];
    private byte[] data = new byte[0];
    private Integer ne = null;
    private ByteArrayOutputStream apdu = null;

    private synchronized byte[] getApdu() {
        if (this.apdu == null) {
            this.apdu = new ByteArrayOutputStream(this.header.length + this.data.length);
        }
        if (this.apdu.size() == 0) {
            this.calculate();
        }
        return this.apdu.toByteArray();
    }

    private void calculate() {
        int nc = this.data.length;
        this.apdu.write(this.header, 0, this.header.length);
        if (nc > 0) {
            if (this.ne != null) {
                this.doCase4sOr4e(nc);
            } else {
                this.doCase3sOr3e(nc);
            }
        } else if (this.ne != null) {
            this.doCase2sOr2e();
        }
    }

    private void doCase2sOr2e() {
        byte[] le;
        if (this.ne <= 256) {
            le = AbstractCommandApdu.encodeExpectedLengthShort(this.ne);
        } else {
            this.apdu.write(0);
            le = AbstractCommandApdu.encodeExpectedLengthExtended(this.ne);
        }
        this.apdu.write(le, 0, le.length);
    }

    private void doCase3sOr3e(int nc) {
        byte[] lc = nc <= 255 ? AbstractCommandApdu.encodeDataLengthShort(nc) : AbstractCommandApdu.encodeDataLengthExtended(nc);
        this.apdu.write(lc, 0, lc.length);
        this.apdu.write(this.data, 0, this.data.length);
    }

    private void doCase4sOr4e(int nc) {
        byte[] le;
        byte[] lc;
        if (nc <= 255 && this.ne <= 256) {
            lc = AbstractCommandApdu.encodeDataLengthShort(nc);
            le = AbstractCommandApdu.encodeExpectedLengthShort(this.ne);
        } else {
            lc = AbstractCommandApdu.encodeDataLengthExtended(nc);
            le = AbstractCommandApdu.encodeExpectedLengthExtended(this.ne);
        }
        this.apdu.write(lc, 0, lc.length);
        this.apdu.write(this.data, 0, this.data.length);
        this.apdu.write(le, 0, le.length);
    }

    protected void setHeader(int cla, int ins, int p1, int p2) {
        if (cla < 0 || ins < 0 || p1 < 0 || p2 < 0) {
            throw new IllegalArgumentException("APDU header fields must not be less than 0");
        }
        if (cla > 255 || ins > 255 || p1 > 255 || p2 > 255) {
            throw new IllegalArgumentException("APDU header fields must not be greater than 255 (0xFF)");
        }
        this.header[0] = (byte)cla;
        this.header[1] = (byte)ins;
        this.header[2] = (byte)p1;
        this.header[3] = (byte)p2;
        this.resetApduBuffer();
    }

    protected void setData(byte[] data) {
        if (data != null) {
            if (data.length > 65535) {
                throw new IllegalArgumentException("cmd data length must not exceed 65535 bytes");
            }
            this.data = Arrays.copyOf(data, data.length);
            this.resetApduBuffer();
        }
    }

    private void resetApduBuffer() {
        if (this.apdu != null) {
            this.apdu.reset();
        }
    }

    protected void setNe(Integer ne) {
        this.ne = ne;
        this.resetApduBuffer();
    }

    @Override
    public int getCla() {
        return this.header[0] & 0xFF;
    }

    @Override
    public int getIns() {
        return this.header[1] & 0xFF;
    }

    @Override
    public int getP1() {
        return this.header[2] & 0xFF;
    }

    @Override
    public int getP2() {
        return this.header[3] & 0xFF;
    }

    @Override
    public int getNc() {
        if (this.data != null) {
            return this.data.length;
        }
        return 0;
    }

    @Override
    public byte[] getData() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    @Override
    public Integer getNe() {
        return this.ne;
    }

    @Override
    public byte[] getBytes() {
        return this.getApdu();
    }

    public String toString() {
        byte[] apduBytes = this.getBytes();
        return "CommandAPDU: " + apduBytes.length + " bytes, nc=" + this.data.length + ", ne=" + this.ne;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractCommandApdu)) {
            return false;
        }
        AbstractCommandApdu that = (AbstractCommandApdu)o;
        return Arrays.equals(this.getApdu(), that.getApdu());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getApdu());
    }
}

