/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.cardreader.provider.api;

import de.gematik.ti.cardreader.provider.api.ICardReader;
import de.gematik.ti.cardreader.provider.api.events.card.CardAbsentEvent;
import de.gematik.ti.cardreader.provider.api.events.card.CardPresentEvent;
import de.gematik.ti.cardreader.provider.api.events.card.CardTimeoutEvent;
import de.gematik.ti.cardreader.provider.api.events.card.CardUnknownEvent;
import org.greenrobot.eventbus.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardEventTransmitter {
    private final ICardReader cardReader;
    private static final Logger LOG = LoggerFactory.getLogger(CardEventTransmitter.class);

    CardEventTransmitter(ICardReader cardReader) {
        this.cardReader = cardReader;
    }

    public void informAboutCardPresent() {
        LOG.debug(this.cardReader.getName() + "-Device: \"card present\"");
        EventBus.getDefault().post((Object)new CardPresentEvent(this.cardReader));
    }

    public void informAboutCardAbsent() {
        LOG.debug(this.cardReader.getName() + "-Device: \"card absent\"");
        EventBus.getDefault().post((Object)new CardAbsentEvent(this.cardReader));
    }

    public void informAboutCardUnknown() {
        LOG.debug(this.cardReader.getName() + "-Device: \"card unknown\"");
        EventBus.getDefault().post((Object)new CardUnknownEvent(this.cardReader));
    }

    public void informAboutCardTimeout() {
        LOG.debug(this.cardReader.getName() + "-Device: \"card timeout\"");
        EventBus.getDefault().post((Object)new CardTimeoutEvent(this.cardReader));
    }
}

