/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.fhir.validation.staticv;

import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.refv.commons.validation.ValidationMessagesFilter;
import de.gematik.refv.commons.validation.ValidationModule;
import de.gematik.refv.commons.validation.ValidationOptions;
import de.gematik.refv.commons.validation.ValidationResult;
import de.gematik.test.tiger.glue.RBelValidatorGlue;
import io.cucumber.core.plugin.report.Evidence;
import io.cucumber.core.plugin.report.EvidenceRecorder;
import io.cucumber.core.plugin.report.EvidenceRecorderFactory;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;

public class StaticFhirValidation {
    private static final String BODY_RBEL_PATH = "$.body";
    private final EvidenceRecorder evidenceRecorder = EvidenceRecorderFactory.getEvidenceRecorder();
    private final RBelValidatorGlue rBelValidatorGlue;

    public StaticFhirValidation() {
        this.rBelValidatorGlue = new RBelValidatorGlue();
    }

    public StaticFhirValidation(RBelValidatorGlue rBelValidatorGlue) {
        this.rBelValidatorGlue = rBelValidatorGlue;
    }

    public void tgrCurrentRequestBodyAtIsValidFHIRResourceOfType(ValidationModule validationModule) {
        this.tgrCurrentRequestAtIsValidFHIRResourceOfType(BODY_RBEL_PATH, validationModule);
    }

    public void tgrCurrentRequestBodyAtIsValidFHIRResourceOfType(ValidationModule validationModule, String profileUrl) {
        this.tgrCurrentRequestAtIsValidFHIRResourceOfType(BODY_RBEL_PATH, validationModule, StaticFhirValidation.createValidationOptionsWithProfile(profileUrl));
    }

    public void tgrCurrentRequestAtIsValidFHIRResourceOfType(String rbelPath, ValidationModule validationModule) {
        ValidationOptions validationOptions = ValidationOptions.getDefaults();
        validationOptions.setValidationMessagesFilter(ValidationMessagesFilter.KEEP_ALL);
        this.tgrCurrentRequestAtIsValidFHIRResourceOfType(rbelPath, validationModule, validationOptions);
    }

    public void tgrCurrentRequestAtIsValidFHIRResourceOfType(String rbelPath, ValidationModule validationModule, String profileUrl) {
        this.tgrCurrentRequestAtIsValidFHIRResourceOfType(rbelPath, validationModule, StaticFhirValidation.createValidationOptionsWithProfile(profileUrl));
    }

    private void tgrCurrentRequestAtIsValidFHIRResourceOfType(String rbelPath, ValidationModule validationModule, ValidationOptions validationOptions) {
        ValidationResult validationResult = this.validateRbelElementAt(this.rBelValidatorGlue.getRbelMessageRetriever().findElementInCurrentRequest(rbelPath), validationModule, validationOptions);
        String validationMessage = this.getCombinedValidationMessages(validationResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validationResult.isValid()).withFailMessage("request body is not a valid %s resource. cause: \n%s", new Object[]{validationModule.getId(), validationMessage})).isTrue();
    }

    private static ValidationOptions createValidationOptionsWithProfile(String profile) {
        ValidationOptions validationOptions = ValidationOptions.getDefaults();
        validationOptions.setProfiles(List.of(profile));
        validationOptions.setValidationMessagesFilter(ValidationMessagesFilter.KEEP_ALL);
        return validationOptions;
    }

    private void recordEvidencesOf(ValidationResult validationResult) {
        validationResult.getValidationMessages().stream().map(StaticFhirValidation::toEvidence).forEach(arg_0 -> ((EvidenceRecorder)this.evidenceRecorder).recordEvidence(arg_0));
    }

    @NotNull
    private static Evidence toEvidence(SingleValidationMessage it) {
        Evidence.Type type = switch (it.getSeverity()) {
            default -> throw new IncompatibleClassChangeError();
            case ResultSeverityEnum.INFORMATION -> Evidence.Type.INFO;
            case ResultSeverityEnum.WARNING -> Evidence.Type.WARN;
            case ResultSeverityEnum.ERROR -> Evidence.Type.ERROR;
            case ResultSeverityEnum.FATAL -> Evidence.Type.FATAL;
        };
        return new Evidence(type, it.getMessage(), (Object)it);
    }

    public void tgrCurrentResponseBodyAtIsValidFHIRResourceOfType(ValidationModule validationModule) {
        this.tgrCurrentResponseAtIsValidFHIRResourceOfType(BODY_RBEL_PATH, validationModule);
    }

    public void tgrCurrentResponseAtIsValidFHIRResourceOfType(String rbelPath, ValidationModule validationModule) {
        ValidationOptions validationOptions = ValidationOptions.getDefaults();
        validationOptions.setValidationMessagesFilter(ValidationMessagesFilter.KEEP_ALL);
        this.tgrCurrentResponseAtIsValidFHIRResourceOfType(rbelPath, validationModule, validationOptions);
    }

    public void tgrCurrentResponseBodyAtIsValidFHIRResourceOfType(ValidationModule validationModule, String profileUrl) {
        this.tgrCurrentResponseAtIsValidFHIRResourceOfType(BODY_RBEL_PATH, validationModule, StaticFhirValidation.createValidationOptionsWithProfile(profileUrl));
    }

    public void tgrCurrentResponseAtIsValidFHIRResourceOfType(String rbelPath, ValidationModule validationModule, String profileUrl) {
        this.tgrCurrentResponseAtIsValidFHIRResourceOfType(rbelPath, validationModule, StaticFhirValidation.createValidationOptionsWithProfile(profileUrl));
    }

    private void tgrCurrentResponseAtIsValidFHIRResourceOfType(String rbelPath, ValidationModule validationModule, ValidationOptions validationOptions) {
        ValidationResult validationResult = this.validateRbelElementAt(this.rBelValidatorGlue.getRbelMessageRetriever().findElementInCurrentResponse(rbelPath), validationModule, validationOptions);
        String validationMessage = this.getCombinedValidationMessages(validationResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validationResult.isValid()).withFailMessage("response body is not a valid %s resource, cause: \n%s", new Object[]{validationModule.getId(), validationMessage})).isTrue();
    }

    @NotNull
    private ValidationResult validateRbelElementAt(RbelElement toValidate, ValidationModule validationModule, ValidationOptions validationOptions) {
        String rawContentToValidate = toValidate.getRawStringContent();
        ValidationResult validationResult = validationModule.validateString(rawContentToValidate, validationOptions);
        this.recordEvidencesOf(validationResult);
        return validationResult;
    }

    private String getCombinedValidationMessages(ValidationResult validationResult) {
        return validationResult.getValidationMessages().stream().filter(message -> message.getSeverity().equals((Object)ResultSeverityEnum.ERROR)).map(message -> String.valueOf(message.getSeverity()) + " - " + message.getMessage()).collect(Collectors.joining("\n"));
    }
}

