/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.glue.fhir;

import io.cucumber.java.en.Then;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;

public class Helper {
    @Then(value="in {tigerResolvedString} exists a file matching {tigerResolvedString} containing all of the following lines:")
    public void inExistsAFileMatchingContainingAllOfTheFollowingLines(String reportDir, String reportFilePattern, String expectedLines) {
        try (Stream<Path> files = Files.walk(Paths.get(reportDir, new String[0]), new FileVisitOption[0]);){
            Optional<String> report = files.filter(it -> it.getFileName().toString().matches(reportFilePattern)).sorted(Helper.byModificationTime().reversed()).limit(1L).map(Helper::toFileContent).findFirst();
            List<CharSequence> lines = expectedLines.lines().map(it -> it).toList();
            ((OptionalAssert)Assertions.assertThat(report).isPresent()).hasValueSatisfying(reportString -> Assertions.assertThat((String)reportString).contains((Iterable)lines));
        }
    }

    @Then(value="in {tigerResolvedString} exists no file matching {tigerResolvedString} containing any of the following lines:")
    public void inExistsNoFileMatchingContainingAnyOfTheFollowingLines(String reportDir, String reportFilePattern, String expectedLines) {
        try (Stream<Path> files = Files.walk(Paths.get(reportDir, new String[0]), new FileVisitOption[0]);){
            Optional<String> report = files.filter(it -> it.getFileName().toString().matches(reportFilePattern)).sorted(Helper.byModificationTime().reversed()).limit(1L).map(Helper::toFileContent).findFirst();
            List<CharSequence> lines = expectedLines.lines().map(it -> it).toList();
            ((OptionalAssert)Assertions.assertThat(report).isPresent()).hasValueSatisfying(reportString -> Assertions.assertThat((String)reportString).doesNotContain((Iterable)lines));
        }
    }

    private static Comparator<Path> byModificationTime() {
        return Comparator.comparing(it -> it.getFileName().toString());
    }

    private static String toFileContent(Path path) {
        return Files.readString(path);
    }
}

