/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.fhir.validation.plugins;

import de.gematik.refv.Plugin;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginLoader.class);
    private final Map<String, Plugin> plugins = new HashMap<String, Plugin>();

    public Map<String, Plugin> loadPlugins(String pluginPath) throws IllegalArgumentException {
        this.plugins.clear();
        File pluginFolder = new File(pluginPath);
        if (!pluginFolder.exists()) {
            throw new IllegalArgumentException(String.format("Plugins directory is missing. No such file or directory: %s", pluginFolder.getPath()));
        }
        List<ZipFile> zipFiles = Arrays.stream(Objects.requireNonNull(pluginFolder.list((dir, name) -> name.endsWith(".zip")))).map(fileName -> PluginLoader.getZipFile(pluginPath, fileName)).toList();
        if (zipFiles.isEmpty()) {
            log.info("No plugins found in: {}", (Object)pluginFolder.getPath());
            return new HashMap<String, Plugin>();
        }
        for (ZipFile zipFile : zipFiles) {
            Optional<ZipEntry> configFile = zipFile.stream().filter(e -> e.getName().endsWith("config.yaml")).findFirst();
            if (configFile.isEmpty()) {
                throw new IllegalArgumentException("No config file found for plugin " + zipFile.getName());
            }
            Plugin plugin = Plugin.createFromZipFile((ZipFile)zipFile);
            if (this.plugins.containsKey(plugin.getId())) {
                log.warn("Duplicate plugin id found: '{}'. Change the id of the plugin in the plugin configuration file and try again", (Object)plugin.getId());
                continue;
            }
            this.plugins.put(plugin.getId(), plugin);
        }
        return this.plugins;
    }

    private static ZipFile getZipFile(String pluginPath, String fileName) {
        return new ZipFile(pluginPath + File.separator + fileName);
    }

    @Generated
    public PluginLoader() {
    }
}

