/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.fhir.validation.fhirpath;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.DefaultProfileValidationSupport;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.parser.IParser;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.fhir.validation.fhirpath.NetTracer;
import io.cucumber.core.plugin.report.Evidence;
import io.cucumber.core.plugin.report.EvidenceRecorder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.hapi.ctx.HapiWorkerContext;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.utils.FHIRPathEngine;
import org.jetbrains.annotations.NotNull;

public class FhirPathValidation {
    private static final FhirContext ctx = FhirContext.forR4();
    private static final FHIRPathEngine fhirPathEngine = new FHIRPathEngine((IWorkerContext)new HapiWorkerContext(ctx, (IValidationSupport)new DefaultProfileValidationSupport(ctx)));
    public static final String RBEL_SELECTOR_FOR_CONTENT_TYPE_HEADER = "$.header.Content-Type";
    public static final String RBEL_SELECTOR_FOR_BODY = "$.body";
    private final EvidenceRecorder evidenceRecorder;
    private final NetTracer netTracer;

    public void tgrCurrentRequestBodyEvaluatesTheFhirPath(String fhirPath, Optional<String> errorMessage) {
        this.tgrCurrentRequestEvaluatesTheFhirPath(RBEL_SELECTOR_FOR_BODY, fhirPath, errorMessage);
    }

    public void tgrCurrentRequestBodyEvaluatesTheFhirPath(String fhirPath) {
        this.tgrCurrentRequestEvaluatesTheFhirPath(RBEL_SELECTOR_FOR_BODY, fhirPath, Optional.empty());
    }

    public void tgrCurrentRequestEvaluatesTheFhirPath(String rbelPath, String fhirPath) {
        this.tgrCurrentRequestEvaluatesTheFhirPaths(rbelPath, fhirPath, Optional.empty());
    }

    public void tgrCurrentRequestEvaluatesTheFhirPath(String rbelPath, String fhirPath, Optional<String> errorMessage) {
        this.tgrCurrentRequestEvaluatesTheFhirPaths(rbelPath, fhirPath, errorMessage);
    }

    public void tgrCurrentRequestBodyEvaluatesTheFhirPaths(String fhirPaths) {
        this.tgrCurrentRequestEvaluatesTheFhirPaths(RBEL_SELECTOR_FOR_BODY, fhirPaths, Optional.empty());
    }

    public void tgrCurrentRequestEvaluatesTheFhirPaths(String rbelPath, String fhirPaths) {
        this.tgrCurrentRequestEvaluatesTheFhirPaths(rbelPath, fhirPaths, Optional.empty());
    }

    public void tgrCurrentRequestEvaluatesTheFhirPaths(String rbelPath, String fhirPaths, Optional<String> errorMessage) {
        Optional<String> fhirRessource = this.findElementInCurrentRequest(rbelPath);
        if (fhirRessource.isEmpty()) {
            return;
        }
        IBaseResource ressource = this.parseRequestByContentType(fhirRessource.get());
        SoftAssertions.assertSoftly(softAsserter -> FhirPathValidation.toCleanFhirPath(fhirPaths).map(TigerGlobalConfiguration::resolvePlaceholders).forEach(fhirPath -> this.evaluate((String)fhirPath, (Base)ressource, (SoftAssertions)softAsserter, errorMessage)));
    }

    @NotNull
    private static Stream<String> toCleanFhirPath(String fhirPaths) {
        return fhirPaths.lines().filter(it -> !it.isBlank()).map(String::trim);
    }

    public void tgrCurrentResponseBodyEvaluatesTheFhirPath(String fhirPath) {
        this.tgrCurrentResponseEvaluatesTheFhirPath(RBEL_SELECTOR_FOR_BODY, fhirPath, Optional.empty());
    }

    public void tgrCurrentResponseBodyEvaluatesTheFhirPath(String fhirPath, Optional<String> errorMessage) {
        this.tgrCurrentResponseEvaluatesTheFhirPath(RBEL_SELECTOR_FOR_BODY, fhirPath, errorMessage);
    }

    public void tgrCurrentResponseEvaluatesTheFhirPath(String rbelPath, String fhirPath) {
        this.tgrCurrentResponseEvaluatesTheFhirPaths(rbelPath, fhirPath, Optional.empty());
    }

    public void tgrCurrentResponseEvaluatesTheFhirPath(String rbelPath, String fhirPath, Optional<String> errorMessage) {
        this.tgrCurrentResponseEvaluatesTheFhirPaths(rbelPath, fhirPath, errorMessage);
    }

    public void tgrCurrentResponseBodyEvaluatesTheFhirPaths(String fhirPaths) {
        this.tgrCurrentResponseEvaluatesTheFhirPaths(RBEL_SELECTOR_FOR_BODY, fhirPaths, Optional.empty());
    }

    public void tgrCurrentResponseEvaluatesTheFhirPaths(String rbelPath, String fhirPaths) {
        this.tgrCurrentResponseEvaluatesTheFhirPaths(rbelPath, fhirPaths, Optional.empty());
    }

    public void tgrCurrentResponseEvaluatesTheFhirPaths(String rbelPath, String fhirPaths, Optional<String> errorMessage) {
        Optional<String> fhirRessource = this.findElementInCurrentResponse(rbelPath);
        if (fhirRessource.isEmpty()) {
            return;
        }
        IBaseResource ressource = this.parseResponseByContentType(fhirRessource.get());
        SoftAssertions.assertSoftly(softAsserter -> FhirPathValidation.toCleanFhirPath(fhirPaths).map(TigerGlobalConfiguration::resolvePlaceholders).forEach(fhirPath -> this.evaluate((String)fhirPath, (Base)ressource, (SoftAssertions)softAsserter, errorMessage)));
    }

    public void tgrCurrentRequestBodyFailesTheFhirPath(String fhirPath) {
        this.tgrCurrentRequestFailsTheFhirPath(RBEL_SELECTOR_FOR_BODY, fhirPath);
    }

    public void tgrCurrentRequestFailsTheFhirPath(String rbelPath, String fhirPath) {
        Optional<String> fhirRessource = this.findElementInCurrentRequest(rbelPath);
        if (fhirRessource.isEmpty()) {
            return;
        }
        IBaseResource ressource = this.parseRequestByContentType(fhirRessource.get());
        SoftAssertions.assertSoftly(soft -> this.evaluateFail(TigerGlobalConfiguration.resolvePlaceholders((String)fhirPath), (Base)ressource, (SoftAssertions)soft));
    }

    public void tgrCurrentResponseBodyFailsTheFhirPath(String fhirPath) {
        this.tgrCurrentResponseFailsTheFhirPath(RBEL_SELECTOR_FOR_BODY, fhirPath);
    }

    public void tgrCurrentResponseFailsTheFhirPath(String rbelPath, String fhirPath) {
        Optional<String> fhirResource = this.findElementInCurrentResponse(rbelPath);
        if (fhirResource.isEmpty()) {
            return;
        }
        IBaseResource ressource = this.parseResponseByContentType(fhirResource.get());
        SoftAssertions.assertSoftly(soft -> this.evaluateFail(TigerGlobalConfiguration.resolvePlaceholders((String)fhirPath), (Base)ressource, (SoftAssertions)soft));
    }

    private void evaluate(String fhirPath, EvaluateOptions options) {
        String targetValueString;
        List evaluationResult;
        try {
            evaluationResult = fhirPathEngine.evaluate(options.ressource, fhirPath);
        }
        catch (FHIRException e) {
            this.evidenceRecorder.recordEvidence(new Evidence(Evidence.Type.FATAL, "invalid FHIRPath: " + fhirPath, (Object)e));
            Optional.ofNullable(options.errorMessage).ifPresentOrElse(arg_0 -> ((SoftAssertions)options.softAsserter).fail(arg_0), () -> options.softAsserter.fail("invalid FHIRPath: " + fhirPath, (Throwable)e));
            return;
        }
        if (this.verifyEmptyResult(fhirPath, evaluationResult, options.softAsserter)) {
            return;
        }
        if (this.verifyNonBooleanResult(evaluationResult, fhirPath, options.softAsserter)) {
            return;
        }
        long numberOfTargetValues = options.expectedOutcome ? FhirPathValidation.numberOfTrueValues(evaluationResult) : FhirPathValidation.numberOfFalseValues(evaluationResult);
        String string = targetValueString = options.expectedOutcome ? "true" : "false";
        if (numberOfTargetValues > 0L) {
            this.evidenceRecorder.recordEvidence(new Evidence(Evidence.Type.ERROR, numberOfTargetValues + " value(s) in the evaluation results are " + targetValueString + " for: " + fhirPath, (Object)evaluationResult));
            options.softAsserter.fail(Optional.ofNullable(options.errorMessage).orElseGet(() -> numberOfTargetValues + " value(s) in the evaluation results are " + targetValueString + " for: " + fhirPath));
            return;
        }
        this.evidenceRecorder.recordEvidence(new Evidence(Evidence.Type.INFO, fhirPath, (Object)evaluationResult));
    }

    private void evaluate(String fhirPath, Base ressource, SoftAssertions softly, Optional<String> errorMessage) {
        this.evaluate(fhirPath, EvaluateOptions.builder().ressource(ressource).softAsserter(softly).errorMessage(errorMessage.orElse(null)).expectedOutcome(false).build());
    }

    private void evaluateFail(String fhirPath, Base ressource, SoftAssertions softly) {
        this.evaluate(fhirPath, EvaluateOptions.builder().ressource(ressource).softAsserter(softly).expectedOutcome(true).build());
    }

    private boolean verifyNonBooleanResult(List<Base> evaluationResult, String fhirPath, SoftAssertions softly) {
        long numberOfNonBooleans = FhirPathValidation.numberOfNonBooleanResults(evaluationResult);
        if (numberOfNonBooleans > 0L) {
            this.evidenceRecorder.recordEvidence(new Evidence(Evidence.Type.ERROR, numberOfNonBooleans + " non boolean results for: " + fhirPath, evaluationResult));
            softly.fail(numberOfNonBooleans + " non boolean results for: " + fhirPath);
            return true;
        }
        return false;
    }

    private boolean verifyEmptyResult(String fhirPath, List<Base> evaluationResult, SoftAssertions softly) {
        if (evaluationResult.isEmpty()) {
            this.evidenceRecorder.recordEvidence(new Evidence(Evidence.Type.ERROR, "Empty results for: " + fhirPath, evaluationResult));
            softly.fail("Empty results for: " + fhirPath);
            return true;
        }
        return false;
    }

    private static long numberOfFalseValues(List<Base> evaluationResult) {
        return evaluationResult.stream().filter(it -> !it.castToBoolean(it).booleanValue()).count();
    }

    private static long numberOfTrueValues(List<Base> evaluationResult) {
        return evaluationResult.stream().filter(it -> it.castToBoolean(it).booleanValue()).count();
    }

    private static long numberOfNonBooleanResults(List<Base> evaluationResult) {
        return evaluationResult.stream().filter(it -> !it.isBooleanPrimitive()).count();
    }

    private IBaseResource parseRequestByContentType(String fhirResource) {
        return this.getParserByRequestContentType().parseResource(fhirResource);
    }

    private Optional<String> findElementInCurrentRequest(String rbelPath) {
        Optional<String> element = this.netTracer.getCurrentRequestsRawStringByRbelPath(rbelPath);
        if (element.isEmpty()) {
            this.evidenceRecorder.recordEvidence(new Evidence(Evidence.Type.FATAL, "no element found with rbel at request"));
            Assertions.fail((String)"no element found with rbel at request");
        }
        return element;
    }

    private IBaseResource parseResponseByContentType(String fhirResource) {
        return this.getParserByResponseContentType().parseResource(fhirResource);
    }

    private Optional<String> findElementInCurrentResponse(String rbelPath) {
        Optional<String> element = this.netTracer.getCurrentResponseRawStringByRbelPath(rbelPath);
        if (element.isEmpty()) {
            this.evidenceRecorder.recordEvidence(new Evidence(Evidence.Type.FATAL, "no element found with rbel at response"));
            Assertions.fail((String)"no element found with rbel at response");
        }
        return element;
    }

    private IParser getParserByResponseContentType() {
        Optional parser = this.getResponseContentType().flatMap(this::getParserForContentTypeHeader);
        if (parser.isEmpty()) {
            this.evidenceRecorder.recordEvidence(new Evidence(Evidence.Type.ERROR, "no Content-Type Header set"));
            Assertions.fail((String)"no Content-Type Header set for Response");
            return null;
        }
        return (IParser)parser.get();
    }

    private IParser getParserByRequestContentType() {
        Optional parser = this.getRequestContentType().flatMap(this::getParserForContentTypeHeader);
        if (parser.isEmpty()) {
            this.evidenceRecorder.recordEvidence(new Evidence(Evidence.Type.ERROR, "no Content-Type Header set"));
            Assertions.fail((String)"no Content-Type Header set for Request");
            return null;
        }
        return (IParser)parser.get();
    }

    @NotNull
    private Optional<String> getRequestContentType() {
        return this.netTracer.getCurrentRequestsRawStringByRbelPath(RBEL_SELECTOR_FOR_CONTENT_TYPE_HEADER);
    }

    @NotNull
    private Optional<String> getResponseContentType() {
        return this.netTracer.getCurrentResponseRawStringByRbelPath(RBEL_SELECTOR_FOR_CONTENT_TYPE_HEADER);
    }

    private Optional<IParser> getParserForContentTypeHeader(String contantType) {
        String lowerCaseContentType = contantType.toLowerCase();
        if (lowerCaseContentType.contains("xml")) {
            return Optional.of(ctx.newXmlParser());
        }
        return Optional.of(ctx.newJsonParser());
    }

    public String getFirstElementAsPrimitiveValueForFhirPath(String fhirPath) {
        String msg;
        Optional<String> fhirResource = this.findElementInCurrentResponse(RBEL_SELECTOR_FOR_BODY);
        if (fhirResource.isEmpty()) {
            return null;
        }
        IBaseResource resource = this.parseResponseByContentType(fhirResource.get());
        try {
            List evaluationResult = fhirPathEngine.evaluate((Base)resource, fhirPath);
            if (evaluationResult != null && !evaluationResult.isEmpty()) {
                if (((Base)evaluationResult.get(0)).isPrimitive()) {
                    return ((Base)evaluationResult.get(0)).primitiveValue();
                }
                this.evidenceRecorder.recordEvidence(new Evidence(Evidence.Type.ERROR, "result is not a primitive type for FHIRPath: " + fhirPath));
                msg = "result is not a primitive type for FHIRPath: " + fhirPath;
            } else {
                this.evidenceRecorder.recordEvidence(new Evidence(Evidence.Type.ERROR, "result is null or empty for FHIRPath: " + fhirPath));
                msg = "result is null or empty for FHIRPath: " + fhirPath;
            }
        }
        catch (FHIRException e) {
            this.evidenceRecorder.recordEvidence(new Evidence(Evidence.Type.FATAL, "invalid FHIRPath: " + fhirPath, (Object)e));
            msg = "invalid FHIRPath: " + fhirPath;
        }
        Assertions.fail((String)msg);
        return null;
    }

    @Generated
    public FhirPathValidation(EvidenceRecorder evidenceRecorder, NetTracer netTracer) {
        this.evidenceRecorder = evidenceRecorder;
        this.netTracer = netTracer;
    }

    private static class EvaluateOptions {
        private final Base ressource;
        private final SoftAssertions softAsserter;
        private final boolean expectedOutcome;
        private final String errorMessage;

        @Generated
        EvaluateOptions(Base ressource, SoftAssertions softAsserter, boolean expectedOutcome, String errorMessage) {
            this.ressource = ressource;
            this.softAsserter = softAsserter;
            this.expectedOutcome = expectedOutcome;
            this.errorMessage = errorMessage;
        }

        @Generated
        public static EvaluateOptionsBuilder builder() {
            return new EvaluateOptionsBuilder();
        }

        @Generated
        public static class EvaluateOptionsBuilder {
            @Generated
            private Base ressource;
            @Generated
            private SoftAssertions softAsserter;
            @Generated
            private boolean expectedOutcome;
            @Generated
            private String errorMessage;

            @Generated
            EvaluateOptionsBuilder() {
            }

            @Generated
            public EvaluateOptionsBuilder ressource(Base ressource) {
                this.ressource = ressource;
                return this;
            }

            @Generated
            public EvaluateOptionsBuilder softAsserter(SoftAssertions softAsserter) {
                this.softAsserter = softAsserter;
                return this;
            }

            @Generated
            public EvaluateOptionsBuilder expectedOutcome(boolean expectedOutcome) {
                this.expectedOutcome = expectedOutcome;
                return this;
            }

            @Generated
            public EvaluateOptionsBuilder errorMessage(String errorMessage) {
                this.errorMessage = errorMessage;
                return this;
            }

            @Generated
            public EvaluateOptions build() {
                return new EvaluateOptions(this.ressource, this.softAsserter, this.expectedOutcome, this.errorMessage);
            }

            @Generated
            public String toString() {
                return "FhirPathValidation.EvaluateOptions.EvaluateOptionsBuilder(ressource=" + this.ressource + ", softAsserter=" + this.softAsserter + ", expectedOutcome=" + this.expectedOutcome + ", errorMessage=" + this.errorMessage + ")";
            }
        }
    }
}

