/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.glue.fhir.helper;

import de.gematik.refv.Plugin;
import de.gematik.refv.SupportedValidationModule;
import de.gematik.test.tiger.fhir.validation.plugins.PluginLoader;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class RefvPluginHelper {
    private static final String PLUGINS_DIR = "refv-plugins";
    private final PluginLoader pluginLoader = new PluginLoader();

    public Plugin getPlugin(String validationModuleId) {
        Map<String, Plugin> plugins;
        String pluginsDirectory = this.getPluginsDirectory();
        Plugin plugin = null;
        if (new File(pluginsDirectory).exists() && (plugin = (plugins = this.pluginLoader.loadPlugins(pluginsDirectory)).get(validationModuleId)) == null) {
            List<String> supportedValidationModules = Stream.concat(plugins.keySet().stream(), Arrays.stream(SupportedValidationModule.values())).map(rec$ -> rec$.toString()).toList();
            throw new IllegalArgumentException(String.format("Validation module [%s] unsupported. Supported validation modules: %s", validationModuleId, supportedValidationModules));
        }
        return plugin;
    }

    private String getPluginsDirectory() {
        String rootDirectory = Paths.get("", new String[0]).toAbsolutePath().toString();
        return rootDirectory + File.separator + PLUGINS_DIR;
    }
}

