/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.glue.fhir;

import de.gematik.refv.Plugin;
import de.gematik.refv.SupportedValidationModule;
import de.gematik.refv.ValidationModuleFactory;
import de.gematik.refv.commons.validation.ValidationModule;
import de.gematik.test.tiger.fhir.validation.staticv.StaticFhirValidation;
import de.gematik.test.tiger.glue.fhir.helper.RefvPluginHelper;
import io.cucumber.java.ParameterType;
import io.cucumber.java.de.Dann;
import io.cucumber.java.de.Wenn;
import io.cucumber.java.en.Then;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public class StaticFhirValidationGlue {
    private final StaticFhirValidation staticFhirValidation;
    private final RefvPluginHelper pluginHelper = new RefvPluginHelper();
    private static final Map<String, ValidationModule> validationModuleCache = new ConcurrentHashMap<String, ValidationModule>();

    public StaticFhirValidationGlue() {
        this(new StaticFhirValidation());
    }

    @ParameterType(value=".+")
    public ValidationModule supportedValidationModule(String validationModuleId) {
        String normalizedId = validationModuleId.toLowerCase();
        if (validationModuleCache.containsKey(normalizedId)) {
            return validationModuleCache.get(normalizedId);
        }
        Optional supportedValidationModule = SupportedValidationModule.fromString((String)normalizedId);
        if (supportedValidationModule.isPresent()) {
            ValidationModule validationModule = new ValidationModuleFactory().createValidationModule((SupportedValidationModule)supportedValidationModule.get());
            validationModuleCache.put(normalizedId, validationModule);
            return validationModule;
        }
        try {
            Plugin plugin = this.pluginHelper.getPlugin(normalizedId);
            if (plugin == null) {
                throw new IllegalArgumentException("Invalid validation module id for both SupportedValidationModule and Plugin: " + validationModuleId);
            }
            ValidationModule validationModule = new ValidationModuleFactory().createValidationModuleFromPlugin(plugin);
            validationModuleCache.put(normalizedId, validationModule);
            return validationModule;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Something went wrong while trying to get the plugin with id: " + validationModuleId, e);
        }
    }

    @Then(value="FHIR current request body is a valid {supportedValidationModule} resource")
    @Wenn(value="FHIR die aktuelle Anfrage im Body eine g\u00fcltige {supportedValidationModule} Ressource enth\u00e4lt")
    @Dann(value="FHIR pr\u00fcfe die aktuelle Anfrage enth\u00e4lt im Body eine g\u00fcltige {supportedValidationModule} Ressource")
    public void tgrCurrentRequestBodyAtIsValidFHIRResourceOfType(ValidationModule validationModule) {
        this.staticFhirValidation.tgrCurrentRequestBodyAtIsValidFHIRResourceOfType(validationModule);
    }

    @Then(value="FHIR current request body is a valid {supportedValidationModule} resource and conforms to profile {tigerResolvedString}")
    @Wenn(value="FHIR die aktuelle Anfrage im Body eine g\u00fcltige {supportedValidationModule} Ressource, die zum Profil {tigerResolvedString} konform ist enth\u00e4lt")
    @Dann(value="FHIR pr\u00fcfe die aktuelle Anfrage enth\u00e4lt im Body eine g\u00fcltige {supportedValidationModule} Ressource, die zum Profil {tigerResolvedString} konform ist")
    public void tgrCurrentRequestBodyAtIsValidFHIRResourceOfType(ValidationModule validationModule, String profileUrl) {
        this.staticFhirValidation.tgrCurrentRequestBodyAtIsValidFHIRResourceOfType(validationModule, profileUrl);
    }

    @Then(value="FHIR current request at {tigerResolvedString} is a valid {supportedValidationModule} resource")
    @Wenn(value="FHIR die aktuelle Anfrage im Knoten {tigerResolvedString} eine g\u00fcltige {supportedValidationModule} Ressource enth\u00e4lt")
    @Dann(value="FHIR pr\u00fcfe die aktuelle Anfrage enth\u00e4lt im Knoten {tigerResolvedString} eine g\u00fcltige {supportedValidationModule} Ressource")
    public void tgrCurrentRequestAtIsValidFHIRResourceOfType(String rbelPath, ValidationModule validationModule) {
        this.staticFhirValidation.tgrCurrentRequestAtIsValidFHIRResourceOfType(rbelPath, validationModule);
    }

    @Then(value="FHIR current request at {tigerResolvedString} is a valid {supportedValidationModule} resource and conforms to profile {tigerResolvedString}")
    @Wenn(value="FHIR die aktuelle Anfrage im Knoten {tigerResolvedString} eine g\u00fcltige {supportedValidationModule} Ressource, die zum Profil {tigerResolvedString} konform ist enth\u00e4lt")
    @Dann(value="FHIR pr\u00fcfe die aktuelle Anfrage enth\u00e4lt im Knoten {tigerResolvedString} eine g\u00fcltige {supportedValidationModule} Ressource, die zum Profil {tigerResolvedString} konform ist")
    public void tgrCurrentRequestAtIsValidFHIRResourceOfType(String rbelPath, ValidationModule validationModule, String profileUrl) {
        this.staticFhirValidation.tgrCurrentRequestAtIsValidFHIRResourceOfType(rbelPath, validationModule, profileUrl);
    }

    @Then(value="FHIR current response body is a valid {supportedValidationModule} resource")
    @Wenn(value="FHIR die aktuelle Antwort im Body eine g\u00fcltige {supportedValidationModule} Ressource enth\u00e4lt")
    @Dann(value="FHIR pr\u00fcfe die aktuelle Antwort enth\u00e4lt im Body eine g\u00fcltige {supportedValidationModule} Ressource")
    public void tgrCurrentResponseBodyAtIsValidFHIRResourceOfType(ValidationModule validationModule) {
        this.staticFhirValidation.tgrCurrentResponseBodyAtIsValidFHIRResourceOfType(validationModule);
    }

    @Then(value="FHIR current response body is a valid {supportedValidationModule} resource and conforms to profile {tigerResolvedString}")
    @Wenn(value="FHIR die aktuelle Antwort im Body eine g\u00fcltige {supportedValidationModule} Ressource, die zum Profil {tigerResolvedString} konform ist enth\u00e4lt")
    @Dann(value="FHIR pr\u00fcfe die aktuelle Antwort enth\u00e4lt im Body eine g\u00fcltige {supportedValidationModule} Ressource, die zum Profil {tigerResolvedString} konform ist")
    public void tgrCurrentResponseBodyAtIsValidFHIRResourceOfType(ValidationModule validationModule, String profileUrl) {
        this.staticFhirValidation.tgrCurrentResponseBodyAtIsValidFHIRResourceOfType(validationModule, profileUrl);
    }

    @Then(value="FHIR current response at {tigerResolvedString} is a valid FHIR {supportedValidationModule} resource")
    @Wenn(value="FHIR die aktuelle Antwort im Knoten {tigerResolvedString} eine g\u00fcltige {supportedValidationModule} Ressource enth\u00e4lt")
    @Dann(value="FHIR pr\u00fcfe die aktuelle Antwort enth\u00e4lt im Knoten {tigerResolvedString} eine g\u00fcltige {supportedValidationModule} Ressource")
    public void tgrCurrentResponseAtIsValidFHIRResourceOfType(String rbelPath, ValidationModule validationModule) {
        this.staticFhirValidation.tgrCurrentResponseAtIsValidFHIRResourceOfType(rbelPath, validationModule);
    }

    @Then(value="FHIR current response at {tigerResolvedString} is a valid FHIR {supportedValidationModule} resource and conforms to profile {tigerResolvedString}")
    @Wenn(value="FHIR die aktuelle Antwort im Knoten {tigerResolvedString} eine g\u00fcltige {supportedValidationModule} Ressource, die zum Profil {tigerResolvedString} konform ist enth\u00e4lt")
    @Dann(value="FHIR pr\u00fcfe die aktuelle Antwort enth\u00e4lt im Knoten {tigerResolvedString} eine g\u00fcltige {supportedValidationModule} Ressource, die zum Profil {tigerResolvedString} konform ist")
    public void tgrCurrentResponseAtIsValidFHIRResourceOfType(String rbelPath, ValidationModule validationModule, String profileUrl) {
        this.staticFhirValidation.tgrCurrentResponseAtIsValidFHIRResourceOfType(rbelPath, validationModule, profileUrl);
    }

    @Generated
    public StaticFhirValidationGlue(StaticFhirValidation staticFhirValidation) {
        this.staticFhirValidation = staticFhirValidation;
    }
}

