/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.glue.fhir;

import de.gematik.test.tiger.common.config.SourceType;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.fhir.validation.fhirpath.FhirPathValidation;
import de.gematik.test.tiger.fhir.validation.fhirpath.NetTracer;
import io.cucumber.core.plugin.report.EvidenceRecorderFactory;
import io.cucumber.java.de.Dann;
import io.cucumber.java.de.Wenn;
import io.cucumber.java.en.Then;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FhirPathValidationGlue {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FhirPathValidationGlue.class);
    private final FhirPathValidation fhirPathValidation;

    public FhirPathValidationGlue() {
        this(new FhirPathValidation(EvidenceRecorderFactory.getEvidenceRecorder(), new NetTracer()));
    }

    @Then(value="FHIR current request body evaluates the FHIRPath {string}")
    @Dann(value="FHIR pr\u00fcfe die aktuelle Anfrage erf\u00fcllt im Body den FHIRPath {string}")
    @Wenn(value="FHIR die aktuelle Anfrage im Body den FHIRPath {string} erf\u00fcllt")
    public void tgrCurrentRequestBodyEvaluatesTheFhirPath(String fhirPath) {
        this.fhirPathValidation.tgrCurrentRequestBodyEvaluatesTheFhirPath(TigerGlobalConfiguration.resolvePlaceholders((String)fhirPath));
    }

    @Then(value="FHIR current request body evaluates the FHIRPath {tigerResolvedString} with error message {tigerResolvedString}")
    @Dann(value="FHIR pr\u00fcfe die aktuelle Anfrage erf\u00fcllt im Body den FHIRPath {tigerResolvedString} mit der Fehlermeldung {tigerResolvedString}")
    @Wenn(value="FHIR die aktuelle Anfrage im Body den FHIRPath {tigerResolvedString} mit der Fehlermeldung {tigerResolvedString} erf\u00fcllt")
    public void tgrCurrentRequestBodyEvaluatesTheFhirPath(String fhirPath, String errorMessage) {
        this.fhirPathValidation.tgrCurrentRequestBodyEvaluatesTheFhirPath(fhirPath, Optional.of(errorMessage));
    }

    @Then(value="FHIR current request at {string} evaluates the FHIRPath {string}")
    @Dann(value="FHIR pr\u00fcfe aktuelle Anfrage im Knoten {string} erf\u00fcllt den FHIRPath {string}")
    @Wenn(value="FHIR die aktuelle Anfrage im Knoten {string} den FHIRPath {string} erf\u00fcllt")
    public void tgrCurrentRequestEvaluatesTheFhirPath(String rbelPath, String fhirPath) {
        this.fhirPathValidation.tgrCurrentRequestEvaluatesTheFhirPath(TigerGlobalConfiguration.resolvePlaceholders((String)rbelPath), TigerGlobalConfiguration.resolvePlaceholders((String)fhirPath));
    }

    @Then(value="FHIR current request at {tigerResolvedString} evaluates the FHIRPath {tigerResolvedString} with error message {tigerResolvedString}")
    @Dann(value="FHIR pr\u00fcfe die aktuelle Anfrage erf\u00fcllt im Knoten {tigerResolvedString} den FHIRPath {tigerResolvedString} mit der Fehlermeldung {tigerResolvedString}")
    @Wenn(value="FHIR die aktuelle Anfrage im Knoten {tigerResolvedString} den FHIRPath {tigerResolvedString} mit der Fehlermeldung {tigerResolvedString} erf\u00fcllt")
    public void tgrCurrentRequestEvaluatesTheFhirPath(String rbelPath, String fhirPath, String errorMessage) {
        this.fhirPathValidation.tgrCurrentRequestEvaluatesTheFhirPath(rbelPath, fhirPath, Optional.of(errorMessage));
    }

    @Then(value="FHIR current request body evaluates the FHIRPaths:")
    @Dann(value="FHIR pr\u00fcfe die aktuelle Anfrage erf\u00fcllt im Body die FHIRPath Ausdr\u00fccke:")
    @Wenn(value="FHIR die aktuelle Anfrage im Body die FHIRPath Ausdr\u00fccke erf\u00fcllt:")
    public void tgrCurrentRequestBodyEvaluatesTheFhirPaths(String fhirPaths) {
        this.fhirPathValidation.tgrCurrentRequestBodyEvaluatesTheFhirPaths(fhirPaths);
    }

    @Then(value="FHIR current request at {tigerResolvedString} evaluates the FHIRPaths:")
    @Dann(value="FHIR pr\u00fcfe die aktuelle Anfrage erf\u00fcllt im Knoten {tigerResolvedString} die FHIRPath Ausdr\u00fccke:")
    @Wenn(value="FHIR die aktuelle Anfrage im Knoten {tigerResolvedString} die FHIRPath Ausdr\u00fccke erf\u00fcllt:")
    public void tgrCurrentRequestEvaluatesTheFhirPaths(String rbelPath, String fhirPaths) {
        this.fhirPathValidation.tgrCurrentRequestEvaluatesTheFhirPaths(rbelPath, fhirPaths);
    }

    @Then(value="FHIR current response body evaluates the FHIRPath {string}")
    @Dann(value="FHIR pr\u00fcfe die aktuelle Antwort erf\u00fcllt im Body den FHIRPath {string}")
    @Wenn(value="FHIR die aktuelle Antwort im Body den FHIRPath {string} erf\u00fcllt")
    public void tgrCurrentResponseBodyEvaluatesTheFhirPath(String fhirPath) {
        this.fhirPathValidation.tgrCurrentResponseBodyEvaluatesTheFhirPath(TigerGlobalConfiguration.resolvePlaceholders((String)fhirPath));
    }

    @Then(value="FHIR current response body evaluates the FHIRPath {tigerResolvedString} with error message {tigerResolvedString}")
    @Dann(value="FHIR pr\u00fcfe die aktuelle Antwort erf\u00fcllt im Body den FHIRPath {tigerResolvedString} mit der Fehlermeldung {tigerResolvedString}")
    @Wenn(value="FHIR die aktuelle Antwort im Body den FHIRPath {tigerResolvedString} mit der Fehlermeldung {tigerResolvedString} erf\u00fcllt")
    public void tgrCurrentResponseBodyEvaluatesTheFhirPath(String fhirPath, String errorMessage) {
        this.fhirPathValidation.tgrCurrentResponseBodyEvaluatesTheFhirPath(fhirPath, Optional.of(errorMessage));
    }

    @Then(value="FHIR current response at {string} evaluates the FHIRPath {string}")
    @Dann(value="FHIR pr\u00fcfe die aktuelle Antwort erf\u00fcllt im Knoten {string} den FHIRPath {string}")
    @Wenn(value="FHIR die aktuelle Antwort im Knoten {string} den FHIRPath {string} erf\u00fcllt")
    public void tgrCurrentResponseEvaluatesTheFhirPath(String rbelPath, String fhirPath) {
        this.fhirPathValidation.tgrCurrentResponseEvaluatesTheFhirPath(TigerGlobalConfiguration.resolvePlaceholders((String)rbelPath), TigerGlobalConfiguration.resolvePlaceholders((String)fhirPath));
    }

    @Then(value="FHIR current response at {tigerResolvedString} evaluates the FHIRPath {tigerResolvedString} with error message {tigerResolvedString}")
    @Dann(value="FHIR pr\u00fcfe die aktuelle Antwort erf\u00fcllt im Knoten {tigerResolvedString} den FHIRPath {tigerResolvedString} mit der Fehlermeldung {tigerResolvedString}")
    @Wenn(value="FHIR die aktuelle Antwort im Knoten {tigerResolvedString} den FHIRPath {tigerResolvedString} mit der Fehlermeldung {tigerResolvedString} erf\u00fcllt")
    public void tgrCurrentResponseEvaluatesTheFhirPath(String rbelPath, String fhirPath, String errorMessage) {
        this.fhirPathValidation.tgrCurrentResponseEvaluatesTheFhirPath(rbelPath, fhirPath, Optional.of(errorMessage));
    }

    @Then(value="FHIR current response body evaluates the FHIRPaths:")
    @Dann(value="FHIR pr\u00fcfe die aktuelle Antwort erf\u00fcllt im Body die FHIRPath Ausdr\u00fccke:")
    @Wenn(value="FHIR die aktuelle Antwort im Body die FHIRPath Ausdr\u00fccke erf\u00fcllt:")
    public void tgrCurrentResponseBodyEvaluatesTheFhirPaths(String fhirPaths) {
        this.fhirPathValidation.tgrCurrentResponseBodyEvaluatesTheFhirPaths(fhirPaths);
    }

    @Then(value="FHIR current response at {tigerResolvedString} evaluates the FHIRPaths:")
    @Dann(value="FHIR pr\u00fcfe die aktuelle Antwort erf\u00fcllt im Knoten {tigerResolvedString} die FHIRPath Ausdr\u00fccke:")
    @Wenn(value="FHIR die aktuelle Antwort im Knoten {tigerResolvedString} die FHIRPath Ausdr\u00fccke erf\u00fcllt:")
    public void tgrCurrentResponseEvaluatesTheFhirPaths(String rbelPath, String fhirPaths) {
        this.fhirPathValidation.tgrCurrentResponseEvaluatesTheFhirPaths(rbelPath, fhirPaths);
    }

    @Then(value="FHIR current request body fails the FHIRPath {tigerResolvedString}")
    @Dann(value="FHIR pr\u00fcfe die aktuelle Anfrage erf\u00fcllt im Body nicht den FHIRPath {tigerResolvedString}")
    @Wenn(value="FHIR die aktuelle Anfrage im Body nicht den FHIRPath {tigerResolvedString} erf\u00fcllt")
    public void tgrCurrentRequestBodyFailesTheFhirPath(String fhirPath) {
        this.fhirPathValidation.tgrCurrentRequestBodyFailesTheFhirPath(fhirPath);
    }

    @Then(value="FHIR current request at {tigerResolvedString} fails the FHIRPath {tigerResolvedString}")
    @Dann(value="FHIR pr\u00fcfe die aktuelle Anfrage erf\u00fcllt im Knoten {tigerResolvedString} nicht den FHIRPath {tigerResolvedString}")
    @Wenn(value="FHIR die aktuelle Anfrage im Knoten {tigerResolvedString} nicht den FHIRPath {tigerResolvedString} erf\u00fcllt")
    public void tgrCurrentRequestFailsTheFhirPath(String rbelPath, String fhirPath) {
        this.fhirPathValidation.tgrCurrentRequestFailsTheFhirPath(rbelPath, fhirPath);
    }

    @Then(value="FHIR current response body fails the FHIRPath {tigerResolvedString}")
    @Dann(value="FHIR pr\u00fcfe die aktuelle Antwort erf\u00fcllt im Body nicht den FHIRPath {tigerResolvedString}")
    @Wenn(value="FHIR die aktuelle Antwort im Body nicht den FHIRPath {tigerResolvedString} erf\u00fcllt")
    public void tgrCurrentResponseBodyFailsTheFhirPath(String fhirPath) {
        this.fhirPathValidation.tgrCurrentResponseBodyFailsTheFhirPath(fhirPath);
    }

    @Then(value="FHIR current response at {tigerResolvedString} fails the FHIRPath {tigerResolvedString}")
    @Dann(value="FHIR pr\u00fcfe die aktuelle Antwort erf\u00fcllt im Knoten {tigerResolvedString} nicht den FHIRPath {tigerResolvedString}")
    @Wenn(value="FHIR die aktuelle Antwort im Knoten {tigerResolvedString} nicht den FHIRPath {tigerResolvedString} erf\u00fcllt")
    public void tgrCurrentResponseFailsTheFhirPath(String rbelPath, String fhirPath) {
        this.fhirPathValidation.tgrCurrentResponseFailsTheFhirPath(rbelPath, fhirPath);
    }

    @Then(value="FHIR evaluate FHIRPath {tigerResolvedString} on current response body and store first element as primitive value in variable {tigerResolvedString}")
    @Dann(value="FHIR pr\u00fcfe die aktuelle Antwort den FHIRPath {tigerResolvedString} und speichere das erste Ergebnis als primitiven Wert in Variable {tigerResolvedString}")
    public void fhirEvaluateFHIRPathTigerResolvedStringOnCurrentResponseBodyAndStoreResultInVariableString(String fhirPath, String variable) {
        String value = this.fhirPathValidation.getFirstElementAsPrimitiveValueForFhirPath(fhirPath);
        if (value != null) {
            TigerGlobalConfiguration.putValue((String)variable, (String)value, (SourceType)SourceType.TEST_CONTEXT);
            log.info(String.format("Storing '%s' in variable '%s'", value, variable));
        }
    }

    @Generated
    public FhirPathValidationGlue(FhirPathValidation fhirPathValidation) {
        this.fhirPathValidation = fhirPathValidation;
    }
}

