/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.glue.fhir;

import io.cucumber.java.en.Then;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Helper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Helper.class);

    @Then(value="in {tigerResolvedString} exists a file matching {tigerResolvedString} containing all of the following lines:")
    public void inExistsAFileMatchingContainingAllOfTheFollowingLines(String reportDir, String reportFilePattern, String expectedLines) {
        try (Stream<Path> files = Files.walk(Paths.get(reportDir, new String[0]), new FileVisitOption[0]);){
            Optional<Path> report = files.filter(it -> it.getFileName().toString().matches(reportFilePattern)).sorted(Helper.byModificationTime().reversed()).limit(1L).findFirst();
            List<CharSequence> lines = expectedLines.lines().map(it -> it).toList();
            if (report.isEmpty()) {
                log.error("No report matching filename regex found in folder {}", (Object)Paths.get(reportDir, new String[0]).toFile().getAbsolutePath());
                throw new AssertionError((Object)("No report matching filename regex found in folder " + Paths.get(reportDir, new String[0]).toFile().getAbsolutePath()));
            }
            log.info("Checking report file {} for content", (Object)report.get().toFile().getAbsolutePath());
            Assertions.assertThat((String)Helper.toFileContent(report.get())).contains(lines);
        }
    }

    @Then(value="in {tigerResolvedString} exists no file matching {tigerResolvedString} containing any of the following lines:")
    public void inExistsNoFileMatchingContainingAnyOfTheFollowingLines(String reportDir, String reportFilePattern, String expectedLines) {
        try (Stream<Path> files = Files.walk(Paths.get(reportDir, new String[0]), new FileVisitOption[0]);){
            Optional<String> report = files.filter(it -> it.getFileName().toString().matches(reportFilePattern)).sorted(Helper.byModificationTime().reversed()).limit(1L).map(Helper::toFileContent).findFirst();
            List<CharSequence> lines = expectedLines.lines().map(it -> it).toList();
            ((OptionalAssert)Assertions.assertThat(report).isPresent()).hasValueSatisfying(reportString -> Assertions.assertThat((String)reportString).doesNotContain((Iterable)lines));
        }
    }

    private static Comparator<Path> byModificationTime() {
        return Comparator.comparing(it -> it.getFileName().toString());
    }

    private static String toFileContent(Path path) {
        return Files.readString(path);
    }
}

