/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.fhir.validation.staticv;

import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.refv.SupportedValidationModule;
import de.gematik.refv.ValidationModuleFactory;
import de.gematik.refv.commons.validation.ValidationModule;
import de.gematik.refv.commons.validation.ValidationOptions;
import de.gematik.refv.commons.validation.ValidationResult;
import de.gematik.test.tiger.lib.rbel.RbelMessageValidator;
import io.cucumber.core.plugin.report.Evidence;
import io.cucumber.core.plugin.report.EvidenceRecorder;
import io.cucumber.core.plugin.report.EvidenceRecorderFactory;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;

public class StaticFhirValidation {
    private static final String BODY_RBEL_PATH = "$.body";
    private final Map<SupportedValidationModule, ValidationModule> validationModuleCache = new EnumMap<SupportedValidationModule, ValidationModule>(SupportedValidationModule.class);
    private static final RbelMessageValidator rbelValidator = RbelMessageValidator.instance;
    private final EvidenceRecorder evidenceRecorder = EvidenceRecorderFactory.getEvidenceRecorder();

    public void tgrCurrentRequestBodyAtIsValidFHIRRessourceOfType(SupportedValidationModule validationType) {
        this.tgrCurrentRequestAtIsValidFHIRRessourceOfType(BODY_RBEL_PATH, validationType);
    }

    public void tgrCurrentRequestBodyAtIsValidFHIRRessourceOfType(SupportedValidationModule validationType, String profileUrl) {
        this.tgrCurrentRequestAtIsValidFHIRRessourceOfType(BODY_RBEL_PATH, validationType, StaticFhirValidation.createValidationOptionsWithProfile(profileUrl));
    }

    public void tgrCurrentRequestAtIsValidFHIRRessourceOfType(String rbelPath, SupportedValidationModule validationType) {
        this.tgrCurrentRequestAtIsValidFHIRRessourceOfType(rbelPath, validationType, ValidationOptions.getDefaults());
    }

    public void tgrCurrentRequestAtIsValidFHIRRessourceOfType(String rbelPath, SupportedValidationModule validationType, String profileUrl) {
        this.tgrCurrentRequestAtIsValidFHIRRessourceOfType(rbelPath, validationType, StaticFhirValidation.createValidationOptionsWithProfile(profileUrl));
    }

    private void tgrCurrentRequestAtIsValidFHIRRessourceOfType(String rbelPath, SupportedValidationModule validationType, ValidationOptions validationOptions) {
        ValidationResult validationResult = this.validateRbelElementAt(rbelValidator.findElementInCurrentRequest(rbelPath), validationType, validationOptions);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validationResult.isValid()).withFailMessage(() -> "request body is not a valid %s resource".formatted(validationType))).isTrue();
    }

    private static ValidationOptions createValidationOptionsWithProfile(String profile) {
        ValidationOptions validationOptions = ValidationOptions.getDefaults();
        validationOptions.setProfiles(List.of(profile));
        return validationOptions;
    }

    private void recordEvidencesOf(ValidationResult validationResult) {
        validationResult.getValidationMessages().stream().map(StaticFhirValidation::toEvidence).forEach(arg_0 -> ((EvidenceRecorder)this.evidenceRecorder).recordEvidence(arg_0));
    }

    @NotNull
    private static Evidence toEvidence(SingleValidationMessage it) {
        Evidence.Type type = switch (it.getSeverity()) {
            default -> throw new IncompatibleClassChangeError();
            case ResultSeverityEnum.INFORMATION -> Evidence.Type.INFO;
            case ResultSeverityEnum.WARNING -> Evidence.Type.WARN;
            case ResultSeverityEnum.ERROR -> Evidence.Type.ERROR;
            case ResultSeverityEnum.FATAL -> Evidence.Type.FATAL;
        };
        return new Evidence(type, it.getMessage(), (Object)it);
    }

    public void tgrCurrentResponseBodyAtIsValidFHIRRessourceOfType(SupportedValidationModule validationType) {
        this.tgrCurrentResponseAtIsValidFHIRRessourceOfType(BODY_RBEL_PATH, validationType);
    }

    public void tgrCurrentResponseAtIsValidFHIRRessourceOfType(String rbelPath, SupportedValidationModule validationType) {
        this.tgrCurrentResponseAtIsValidFHIRRessourceOfType(rbelPath, validationType, ValidationOptions.getDefaults());
    }

    public void tgrCurrentResponseBodyAtIsValidFHIRRessourceOfType(SupportedValidationModule validationType, String profileUrl) {
        this.tgrCurrentResponseAtIsValidFHIRRessourceOfType(BODY_RBEL_PATH, validationType, StaticFhirValidation.createValidationOptionsWithProfile(profileUrl));
    }

    public void tgrCurrentResponseAtIsValidFHIRRessourceOfType(String rbelPath, SupportedValidationModule validationType, String profileUrl) {
        this.tgrCurrentResponseAtIsValidFHIRRessourceOfType(rbelPath, validationType, StaticFhirValidation.createValidationOptionsWithProfile(profileUrl));
    }

    private void tgrCurrentResponseAtIsValidFHIRRessourceOfType(String rbelPath, SupportedValidationModule validationType, ValidationOptions validationOptions) {
        ValidationResult validationResult = this.validateRbelElementAt(rbelValidator.findElementInCurrentResponse(rbelPath), validationType, validationOptions);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validationResult.isValid()).withFailMessage(() -> "response body is not a valid %s resource".formatted(validationType))).isTrue();
    }

    @NotNull
    private ValidationResult validateRbelElementAt(RbelElement toValidate, SupportedValidationModule validationType, ValidationOptions validationOptions) {
        String rawContentToValidate = toValidate.getRawStringContent();
        ValidationModule validator = this.getValidationModuleFor(validationType);
        ValidationResult validationResult = validator.validateString(rawContentToValidate, validationOptions);
        this.recordEvidencesOf(validationResult);
        return validationResult;
    }

    private ValidationModule getValidationModuleFor(SupportedValidationModule validationType) {
        return this.validationModuleCache.computeIfAbsent(validationType, StaticFhirValidation::getNewValidationModule);
    }

    private static ValidationModule getNewValidationModule(SupportedValidationModule validationType) {
        return new ValidationModuleFactory().createValidationModule(validationType);
    }
}

