/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.zion.services;

import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.util.GlobalServerMap;
import de.gematik.rbellogger.writer.RbelSerializationResult;
import de.gematik.rbellogger.writer.RbelWriter;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import de.gematik.test.tiger.zion.config.ZionBackendRequestDescription;
import de.gematik.test.tiger.zion.config.ZionConfiguration;
import de.gematik.test.tiger.zion.services.VariableAssigner;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BackendRequestExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BackendRequestExecutor.class);
    private final ZionConfiguration zionConfiguration;
    private final RbelLogger rbelLogger;
    private final RbelWriter rbelWriter;

    public void executeBackendRequests(List<ZionBackendRequestDescription> backendRequests, TigerJexlContext jexlContext, RbelElement requestRbelMessage) {
        for (ZionBackendRequestDescription requestDescription : backendRequests) {
            try {
                CloseableHttpResponse response = this.prepareAndExecuteBackendRequest(requestDescription, requestRbelMessage);
                RbelElement rbelResponse = this.rbelLogger.getRbelConverter().convertElement(this.responseToRawMessage(response), null);
                VariableAssigner.doAssignments(requestDescription.getAssignments(), rbelResponse, jexlContext);
            }
            catch (RuntimeException e) {
                log.error("Error during backend request '" + requestDescription.getMethod() + " " + requestDescription.getUrl() + "'", (Throwable)e);
                throw e;
            }
        }
    }

    private CloseableHttpResponse prepareAndExecuteBackendRequest(ZionBackendRequestDescription requestDescription, RbelElement requestRbelMessage) {
        CloseableHttpResponse closeableHttpResponse;
        block13: {
            String method = BackendRequestExecutor.getMethod(requestDescription);
            CloseableHttpClient apacheHttpClient = this.buildHttpClient();
            try {
                CloseableHttpResponse response;
                RequestBuilder httpRequest = RequestBuilder.create((String)method).setUri(TigerGlobalConfiguration.resolvePlaceholdersWithContext((String)requestDescription.getUrl(), (TigerJexlContext)new TigerJexlContext().withRootElement((Object)requestRbelMessage)));
                if (requestDescription.getHeaders() != null) {
                    requestDescription.getHeaders().forEach((arg_0, arg_1) -> ((RequestBuilder)httpRequest).addHeader(arg_0, arg_1));
                }
                if (StringUtils.isNotEmpty((CharSequence)requestDescription.getBody())) {
                    RbelSerializationResult body = this.getBody(requestDescription, requestRbelMessage);
                    if (log.isTraceEnabled()) {
                        log.trace("About to sent {} with body {} to {}", new Object[]{httpRequest.getMethod(), body.getContentAsString(), httpRequest.getUri()});
                    }
                    httpRequest.setEntity((HttpEntity)new ByteArrayEntity(body.getContent()));
                    response = apacheHttpClient.execute(httpRequest.build());
                } else {
                    if (log.isTraceEnabled()) {
                        log.trace("About to sent {} without body to {}", (Object)httpRequest.getMethod(), (Object)httpRequest.getUri());
                    }
                    response = apacheHttpClient.execute(httpRequest.build());
                }
                closeableHttpResponse = response;
                if (apacheHttpClient == null) break block13;
            }
            catch (Throwable throwable) {
                if (apacheHttpClient != null) {
                    try {
                        apacheHttpClient.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            apacheHttpClient.close();
        }
        return closeableHttpResponse;
    }

    private byte[] responseToRawMessage(CloseableHttpResponse response) {
        byte[] httpResponseHeader = (String.valueOf(response.getStatusLine()) + "\r\n" + this.formatHeaderList(response.getAllHeaders()) + "\r\n\r\n").getBytes(StandardCharsets.US_ASCII);
        return ArrayUtils.addAll((byte[])httpResponseHeader, (byte[])response.getEntity().getContent().readAllBytes());
    }

    private String formatHeaderList(Header[] headerList) {
        return Arrays.stream(ArrayUtils.nullToEmpty((Object[])headerList)).map(Header.class::cast).filter(h -> !h.getName().equalsIgnoreCase("Transfer-Encoding")).map(h -> h.getName() + ": " + h.getValue()).collect(Collectors.joining("\r\n"));
    }

    private RbelSerializationResult getBody(ZionBackendRequestDescription requestDescription, RbelElement requestRbelMessage) {
        String rawContent = TigerGlobalConfiguration.resolvePlaceholders((String)requestDescription.getBody());
        RbelElement input = this.rbelLogger.getRbelConverter().convertElement(rawContent, null);
        return this.rbelWriter.serialize(input, new TigerJexlContext().withRootElement((Object)requestRbelMessage));
    }

    private static String getMethod(ZionBackendRequestDescription requestDescription) {
        if (StringUtils.isEmpty((CharSequence)requestDescription.getMethod())) {
            if (StringUtils.isEmpty((CharSequence)requestDescription.getBody())) {
                return "GET";
            }
            return "POST";
        }
        return TigerGlobalConfiguration.resolvePlaceholders((String)requestDescription.getMethod());
    }

    private CloseableHttpClient buildHttpClient() {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)new SpyOnSocketPortConnectionManager(this.zionConfiguration.getServerName()));
        if (this.zionConfiguration.getLocalTigerProxy() == null) {
            return httpClientBuilder.useSystemProperties().build();
        }
        return httpClientBuilder.setProxy(HttpHost.create((String)this.zionConfiguration.getLocalTigerProxy())).build();
    }

    @ConstructorProperties(value={"zionConfiguration", "rbelLogger", "rbelWriter"})
    @Generated
    public BackendRequestExecutor(ZionConfiguration zionConfiguration, RbelLogger rbelLogger, RbelWriter rbelWriter) {
        this.zionConfiguration = zionConfiguration;
        this.rbelLogger = rbelLogger;
        this.rbelWriter = rbelWriter;
    }

    private static class SpyOnSocketPortConnectionManager
    implements HttpClientConnectionManager {
        private final String serverName;
        HttpClientConnectionManager delegate = new PoolingHttpClientConnectionManager();

        public void connect(HttpClientConnection conn, HttpRoute route, int connectTimeout, HttpContext context) throws IOException {
            log.trace("Connecting to {}", (Object)route.getTargetHost());
            this.delegate.connect(conn, route, connectTimeout, context);
            int socketPort = ((ManagedHttpClientConnection)conn).getSocket().getLocalPort();
            log.trace("adding port {} and name {}", (Object)socketPort, (Object)this.serverName);
            GlobalServerMap.addServerNameForPort((int)socketPort, (String)this.serverName);
        }

        @ConstructorProperties(value={"serverName"})
        @Generated
        public SpyOnSocketPortConnectionManager(String serverName) {
            this.serverName = serverName;
        }

        @Generated
        public ConnectionRequest requestConnection(HttpRoute arg0, Object arg1) {
            return this.delegate.requestConnection(arg0, arg1);
        }

        @Generated
        public void releaseConnection(HttpClientConnection arg0, Object arg1, long arg2, TimeUnit arg3) {
            this.delegate.releaseConnection(arg0, arg1, arg2, arg3);
        }

        @Generated
        public void upgrade(HttpClientConnection arg0, HttpRoute arg1, HttpContext arg2) throws IOException {
            this.delegate.upgrade(arg0, arg1, arg2);
        }

        @Generated
        public void routeComplete(HttpClientConnection arg0, HttpRoute arg1, HttpContext arg2) throws IOException {
            this.delegate.routeComplete(arg0, arg1, arg2);
        }

        @Generated
        public void closeIdleConnections(long arg0, TimeUnit arg1) {
            this.delegate.closeIdleConnections(arg0, arg1);
        }

        @Generated
        public void closeExpiredConnections() {
            this.delegate.closeExpiredConnections();
        }

        @Generated
        public void shutdown() {
            this.delegate.shutdown();
        }

        static interface DelegateExclusions {
            public void connect(HttpClientConnection var1, HttpRoute var2, int var3, HttpContext var4);
        }
    }
}

