/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.zion.services;

import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.util.GlobalServerMap;
import de.gematik.rbellogger.writer.RbelSerializationResult;
import de.gematik.rbellogger.writer.RbelWriter;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import de.gematik.test.tiger.zion.config.ZionBackendRequestDescription;
import de.gematik.test.tiger.zion.config.ZionConfiguration;
import de.gematik.test.tiger.zion.services.VariableAssigner;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import kong.unirest.Client;
import kong.unirest.Config;
import kong.unirest.Headers;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestInstance;
import kong.unirest.apache.ApacheClient;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BackendRequestExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BackendRequestExecutor.class);
    private final ZionConfiguration zionConfiguration;
    private final RbelLogger rbelLogger;
    private final RbelWriter rbelWriter;

    public void executeBackendRequests(List<ZionBackendRequestDescription> backendRequests, TigerJexlContext jexlContext, RbelElement requestRbelMessage) {
        for (ZionBackendRequestDescription requestDescription : backendRequests) {
            try {
                HttpResponse<byte[]> unirestResponse = this.prepareAndExecuteBackendRequest(requestDescription, requestRbelMessage);
                RbelElement rbelResponse = this.rbelLogger.getRbelConverter().convertElement(this.responseToRawMessage(unirestResponse), null);
                VariableAssigner.doAssignments(requestDescription.getAssignments(), rbelResponse, jexlContext);
            }
            catch (RuntimeException e) {
                log.error("Error during backend request '" + requestDescription.getMethod() + " " + requestDescription.getUrl() + "'", (Throwable)e);
                throw e;
            }
        }
    }

    private HttpResponse<byte[]> prepareAndExecuteBackendRequest(ZionBackendRequestDescription requestDescription, RbelElement requestRbelMessage) {
        String method = BackendRequestExecutor.getMethod(requestDescription);
        try (UnirestInstance unirestInstance = this.createUnirestInstance();){
            HttpResponse unirestResponse;
            HttpRequestWithBody unirestRequest = unirestInstance.request(method, TigerGlobalConfiguration.resolvePlaceholdersWithContext((String)requestDescription.getUrl(), (TigerJexlContext)new TigerJexlContext().withRootElement((Object)requestRbelMessage)));
            if (requestDescription.getHeaders() != null) {
                requestDescription.getHeaders().forEach((arg_0, arg_1) -> ((HttpRequestWithBody)unirestRequest).header(arg_0, arg_1));
            }
            if (StringUtils.isNotEmpty((CharSequence)requestDescription.getBody())) {
                RbelSerializationResult body = this.getBody(requestDescription, requestRbelMessage);
                if (log.isTraceEnabled()) {
                    log.trace("About to sent {} with body {} to {}", new Object[]{unirestRequest.getHttpMethod().name(), body.getContentAsString(), unirestRequest.getUrl()});
                }
                unirestResponse = unirestRequest.body(body.getContent()).asBytes();
            } else {
                if (log.isTraceEnabled()) {
                    log.trace("About to sent {} without body to {}", (Object)unirestRequest.getHttpMethod().name(), (Object)unirestRequest.getUrl());
                }
                unirestResponse = unirestRequest.asBytes();
            }
            HttpResponse httpResponse = unirestResponse;
            return httpResponse;
        }
    }

    private byte[] responseToRawMessage(HttpResponse<byte[]> response) {
        byte[] httpResponseHeader = ("HTTP/1.1 " + response.getStatus() + " " + (response.getStatusText() != null ? response.getStatusText() : "") + "\r\n" + this.formatHeaderList(response.getHeaders()) + "\r\n\r\n").getBytes(StandardCharsets.US_ASCII);
        return ArrayUtils.addAll((byte[])httpResponseHeader, (byte[])((byte[])response.getBody()));
    }

    private String formatHeaderList(Headers headerList) {
        return headerList.all().stream().filter(h -> !h.getName().equalsIgnoreCase("Transfer-Encoding")).map(h -> h.getName() + ": " + h.getValue()).collect(Collectors.joining("\r\n"));
    }

    private RbelSerializationResult getBody(ZionBackendRequestDescription requestDescription, RbelElement requestRbelMessage) {
        String rawContent = TigerGlobalConfiguration.resolvePlaceholders((String)requestDescription.getBody());
        RbelElement input = this.rbelLogger.getRbelConverter().convertElement(rawContent, null);
        return this.rbelWriter.serialize(input, new TigerJexlContext().withRootElement((Object)requestRbelMessage));
    }

    private static String getMethod(ZionBackendRequestDescription requestDescription) {
        if (StringUtils.isEmpty((CharSequence)requestDescription.getMethod())) {
            if (StringUtils.isEmpty((CharSequence)requestDescription.getBody())) {
                return "GET";
            }
            return "POST";
        }
        return TigerGlobalConfiguration.resolvePlaceholders((String)requestDescription.getMethod());
    }

    private UnirestInstance createUnirestInstance() {
        UnirestInstance unirestInstance = Unirest.spawnInstance();
        unirestInstance.config().httpClient(this.buildHttpClient());
        return unirestInstance;
    }

    private Function<Config, Client> buildHttpClient() {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)new SpyOnSocketPortConnectionManager(this.zionConfiguration.getServerName()));
        if (this.zionConfiguration.getLocalTigerProxy() == null) {
            return ApacheClient.builder((HttpClient)httpClientBuilder.useSystemProperties().build());
        }
        return ApacheClient.builder((HttpClient)httpClientBuilder.setProxy(HttpHost.create((String)this.zionConfiguration.getLocalTigerProxy())).build());
    }

    @ConstructorProperties(value={"zionConfiguration", "rbelLogger", "rbelWriter"})
    @Generated
    public BackendRequestExecutor(ZionConfiguration zionConfiguration, RbelLogger rbelLogger, RbelWriter rbelWriter) {
        this.zionConfiguration = zionConfiguration;
        this.rbelLogger = rbelLogger;
        this.rbelWriter = rbelWriter;
    }

    private static class SpyOnSocketPortConnectionManager
    implements HttpClientConnectionManager {
        private final String serverName;
        HttpClientConnectionManager delegate = new PoolingHttpClientConnectionManager();

        public void connect(HttpClientConnection conn, HttpRoute route, int connectTimeout, HttpContext context) throws IOException {
            log.trace("Connecting to {}", (Object)route.getTargetHost());
            this.delegate.connect(conn, route, connectTimeout, context);
            int socketPort = ((ManagedHttpClientConnection)conn).getSocket().getLocalPort();
            log.trace("adding port {} and name {}", (Object)socketPort, (Object)this.serverName);
            GlobalServerMap.addServerNameForPort((int)socketPort, (String)this.serverName);
        }

        @ConstructorProperties(value={"serverName"})
        @Generated
        public SpyOnSocketPortConnectionManager(String serverName) {
            this.serverName = serverName;
        }

        @Generated
        public ConnectionRequest requestConnection(HttpRoute arg0, Object arg1) {
            return this.delegate.requestConnection(arg0, arg1);
        }

        @Generated
        public void releaseConnection(HttpClientConnection arg0, Object arg1, long arg2, TimeUnit arg3) {
            this.delegate.releaseConnection(arg0, arg1, arg2, arg3);
        }

        @Generated
        public void upgrade(HttpClientConnection arg0, HttpRoute arg1, HttpContext arg2) throws IOException {
            this.delegate.upgrade(arg0, arg1, arg2);
        }

        @Generated
        public void routeComplete(HttpClientConnection arg0, HttpRoute arg1, HttpContext arg2) throws IOException {
            this.delegate.routeComplete(arg0, arg1, arg2);
        }

        @Generated
        public void closeIdleConnections(long arg0, TimeUnit arg1) {
            this.delegate.closeIdleConnections(arg0, arg1);
        }

        @Generated
        public void closeExpiredConnections() {
            this.delegate.closeExpiredConnections();
        }

        @Generated
        public void shutdown() {
            this.delegate.shutdown();
        }

        static interface DelegateExclusions {
            public void connect(HttpClientConnection var1, HttpRoute var2, int var3, HttpContext var4);
        }
    }
}

