/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger;

import de.gematik.test.tiger.common.util.TigerSerializationUtil;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.env.TigerServerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.servers.AbstractExternalTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerStatus;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerType;
import de.gematik.test.tiger.testenvmgr.util.TigerEnvironmentStartupException;
import de.gematik.test.tiger.zion.ZionApplication;
import de.gematik.test.tiger.zion.config.ZionServerConfiguration;
import java.lang.constant.Constable;
import java.net.URL;
import java.util.HashMap;
import java.util.Optional;
import lombok.Generated;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

@TigerServerType(value="zion")
public class ZionServerType
extends AbstractExternalTigerServer {
    private ConfigurableApplicationContext applicationContext;

    public ZionServerType(TigerTestEnvMgr tigerTestEnvMgr, String serverId, CfgServer configuration) {
        super(ZionServerType.determineHostname((CfgServer)configuration, (String)serverId), serverId, configuration, tigerTestEnvMgr);
    }

    public Optional<String> getHealthcheckUrl() {
        return Optional.of("http://localhost:" + this.getServerPort());
    }

    public void performStartup() {
        this.log.info("Entering pre-startup of Zion-Server {}", (Object)this.getServerId());
        this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().statusMessage("Pre-start Zion-Server " + this.getServerId()).build());
        ZionServerConfiguration zionConfiguration = this.getZionConfiguration();
        HashMap<String, Constable> propertyMap = new HashMap<String, Constable>(TigerSerializationUtil.toMap((Object)zionConfiguration.getZionConfiguration(), (String[])new String[]{"zion"}));
        int serverPort = this.getServerPort();
        propertyMap.put("server.port", Integer.valueOf(serverPort));
        propertyMap.put("spring.mustache.enabled", Boolean.valueOf(false));
        propertyMap.put("spring.mustache.check-template-location", Boolean.valueOf(false));
        if (this.getTigerTestEnvMgr().isShuttingDown()) {
            this.log.debug("Skipping startup, already shutting down...");
            this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().statusMessage("Skipped startup of Zion-Server " + this.getServerId()).build());
            return;
        }
        this.log.info("Actually performing startup of Zion-Server {}", (Object)this.getServerId());
        this.statusMessage("Starting ZionServer " + this.getServerId() + " at " + serverPort + "...");
        this.applicationContext = new SpringApplicationBuilder(new Class[0]).bannerMode(Banner.Mode.OFF).properties(propertyMap).sources(new Class[]{ZionApplication.class}).web(WebApplicationType.SERVLET).registerShutdownHook(false).initializers(new ApplicationContextInitializer[0]).run(new String[0]);
        this.waitForServerUp();
        this.addServerToLocalProxyRouteMap(new URL(this.getZionServerBaseUrl()));
        this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().baseUrl(this.getZionServerBaseUrl()).build());
    }

    private String getZionServerBaseUrl() {
        return "http://localhost:" + ((ServletWebServerApplicationContext)this.applicationContext).getWebServer().getPort();
    }

    private int getServerPort() {
        return this.getZionConfiguration().getZionConfiguration().getServerPort();
    }

    private ZionServerConfiguration getZionConfiguration() {
        CfgServer configuration = this.getConfiguration();
        if (configuration instanceof ZionServerConfiguration) {
            ZionServerConfiguration zionServerConfiguration = (ZionServerConfiguration)configuration;
            this.injectServerName(zionServerConfiguration, this.getHostname());
            this.injectLocalTigerProxyAddress(zionServerConfiguration);
            return zionServerConfiguration;
        }
        throw new TigerEnvironmentStartupException("Unexpected configuration type. Expected ZionServerConfiguration but found " + configuration.getClass().getName());
    }

    private void injectServerName(ZionServerConfiguration zionConfiguration, String hostname) {
        zionConfiguration.getZionConfiguration().setServerName(hostname);
    }

    private void injectLocalTigerProxyAddress(ZionServerConfiguration zionServerConfiguration) {
        this.getTigerTestEnvMgr().getLocalTigerProxyOptional().ifPresent(localTigerProxy -> {
            String proxyAddress = "localhost:" + localTigerProxy.getProxyPort();
            zionServerConfiguration.getZionConfiguration().setLocalTigerProxy(proxyAddress);
        });
    }

    public void shutdown() {
        this.log.info("Stopping Zion-Server {}...", (Object)this.getServerId());
        if (this.applicationContext != null && this.applicationContext.isRunning()) {
            this.log.info("Triggering tiger-server shutdown for {}...", (Object)this.getServerId());
            this.applicationContext.close();
            this.setStatus(TigerServerStatus.STOPPED, "Stopped Zion-Server " + this.getServerId());
        } else {
            this.log.info("Skipping tiger-server shutdown for {}!", (Object)this.getServerId());
            this.setStatus(TigerServerStatus.STOPPED, "Zion-Server " + this.getServerId() + " already stopped");
        }
    }

    public Class<? extends CfgServer> getConfigurationBeanClass() {
        return ZionServerConfiguration.class;
    }

    @Generated
    public ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

