/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.zion.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.writer.RbelContentType;
import de.gematik.rbellogger.writer.RbelSerializationResult;
import de.gematik.rbellogger.writer.RbelWriter;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import de.gematik.test.tiger.common.jexl.TigerJexlExecutor;
import de.gematik.test.tiger.zion.ZionException;
import de.gematik.test.tiger.zion.config.TigerMockResponse;
import de.gematik.test.tiger.zion.config.TigerMockResponseDescription;
import de.gematik.test.tiger.zion.config.ZionBackendRequestDescription;
import de.gematik.test.tiger.zion.config.ZionConfiguration;
import de.gematik.test.tiger.zion.config.ZionRequestMatchDefinition;
import de.gematik.test.tiger.zion.services.BackendRequestExecutor;
import de.gematik.test.tiger.zion.services.VariableAssigner;
import de.gematik.test.tiger.zion.services.ZionRequestExecutor;
import java.beans.ConstructorProperties;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.server.ResponseStatusException;

public class ZionRequestExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZionRequestExecutor.class);
    private static final String CONSIDERING_RESPONSE = "Considering response {} {}";
    @NonNull
    private final RbelElement requestRbelMessage;
    private final int localServerPort;
    private final LocalDateTime responseStartTime;
    @NonNull
    private final RbelHostname clientHostname;
    @NonNull
    private final RbelHostname serverHostname;
    @NonNull
    private final ObjectMapper objectMapper;
    @NonNull
    private final RbelLogger rbelLogger;
    @NonNull
    private final ZionConfiguration configuration;
    @NonNull
    private final RequestEntity<byte[]> request;
    @NonNull
    private final RbelWriter rbelWriter;
    @NonNull
    private final BackendRequestExecutor backendRequestExecutor;

    public ResponseEntity<byte[]> execute() {
        TigerJexlContext mainContext = new TigerJexlContext().with("zion.port", String.valueOf(this.localServerPort)).withRootElement((Object)this.requestRbelMessage);
        Optional configuredResponse = this.findResponseForGivenRequest(this.requestRbelMessage, mainContext);
        if (configuredResponse.isPresent()) {
            TigerMockResponse chosenResponse = (TigerMockResponse)((Pair)configuredResponse.get()).getLeft();
            TigerJexlContext responseContext = (TigerJexlContext)((Pair)configuredResponse.get()).getRight();
            ResponseEntity responseEntity = this.renderResponse(chosenResponse, responseContext);
            responseContext.allNonStandardValues().forEach(TigerGlobalConfiguration::putValue);
            this.parseResponseWithRbelLogger(responseEntity);
            this.delayResponseIfNecessary(chosenResponse);
            return responseEntity;
        }
        return (ResponseEntity)this.spyWithRemoteServer(this.request).orElseThrow(() -> {
            log.warn("Could not match request \n{}", (Object)this.requestRbelMessage.printTreeStructure());
            return new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "No suitable return value found");
        });
    }

    private void delayResponseIfNecessary(TigerMockResponse chosenResponse) {
        long actualMillis = Duration.between(this.responseStartTime, LocalDateTime.now()).toMillis();
        String responseDelay = chosenResponse.getResponse().getResponseDelay();
        if (StringUtils.isEmpty((CharSequence)responseDelay)) {
            return;
        }
        long necessaryDelay = Long.parseLong(TigerGlobalConfiguration.resolvePlaceholders((String)responseDelay)) - actualMillis;
        if (necessaryDelay > 0L) {
            try {
                Thread.sleep(necessaryDelay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ZionException("Interrupt received", (Exception)e);
            }
        }
    }

    private Optional<Pair<TigerMockResponse, TigerJexlContext>> findResponseForGivenRequest(RbelElement requestRbelMessage, TigerJexlContext context) {
        for (TigerMockResponse response : this.configuration.getMockResponses().values().stream().sorted(Comparator.comparing(TigerMockResponse::getImportance).reversed()).toList()) {
            TigerJexlContext localResponseContext;
            Optional responseCandidate;
            if (response.getResponse() != null) {
                log.trace(CONSIDERING_RESPONSE, (Object)response.getResponse().getStatusCode(), (Object)response.getResponse().getBody());
            } else {
                log.trace("Considering response without body, nested responses: {}", response.getNestedResponses().keySet());
            }
            if (!(responseCandidate = this.findMatchingResponse(response, requestRbelMessage, localResponseContext = context.withCurrentElement((Object)requestRbelMessage).withRootElement((Object)requestRbelMessage).withShouldIgnoreEmptyRbelPaths(true))).isPresent()) continue;
            return responseCandidate;
        }
        return Optional.empty();
    }

    private ResponseEntity<byte[]> renderResponse(TigerMockResponse response, TigerJexlContext context) {
        Optional serializationResult = this.renderResponseBody(response, context);
        ResponseEntity.BodyBuilder responseBuilder = ResponseEntity.status((int)Integer.parseInt(TigerGlobalConfiguration.resolvePlaceholders((String)response.getResponse().getStatusCode())));
        serializationResult.flatMap(RbelSerializationResult::getMediaType).map(Object::toString).map(MediaType::parseMediaType).ifPresent(arg_0 -> ((ResponseEntity.BodyBuilder)responseBuilder).contentType(arg_0));
        for (Map.Entry entry : response.getResponse().getHeaders().entrySet()) {
            RbelElement convertedElement = this.rbelLogger.getRbelConverter().convertElement((String)entry.getValue(), null);
            RbelSerializationResult serialized = this.rbelWriter.serialize(convertedElement, new TigerJexlContext().withRootElement((Object)this.requestRbelMessage));
            String headerValue = serialized.getContentAsString();
            if (!StringUtils.isNotEmpty((CharSequence)headerValue)) continue;
            responseBuilder.header((String)entry.getKey(), new String[]{serialized.getContentAsString()});
        }
        return responseBuilder.body((Object)serializationResult.map(RbelSerializationResult::getContent).map(content -> this.applyEncodingIfAny(content, response.getResponse().getEncoding(), responseBuilder)).orElse(null));
    }

    private byte[] applyEncodingIfAny(byte[] content, String encoding, ResponseEntity.BodyBuilder responseBuilder) {
        if (StringUtils.isEmpty((CharSequence)encoding)) {
            return content;
        }
        if (encoding.equals("gzip")) {
            responseBuilder.header("Content-Encoding", new String[]{"gzip"});
            return this.gzip(content);
        }
        throw new ZionException("Unknown encoding: " + encoding);
    }

    private byte[] gzip(byte[] input) {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            try (GZIPOutputStream gzipInputStream = new GZIPOutputStream(byteArrayOutputStream);){
                gzipInputStream.write(input);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ZionException("Fatal error during compression", (Exception)e);
            }
        }
        byteArrayOutputStream.close();
        return byArray;
    }

    private Optional<Pair<TigerMockResponse, TigerJexlContext>> findMatchingResponse(TigerMockResponse mockResponse, RbelElement requestRbelMessage, TigerJexlContext context) {
        Optional<Pair<TigerMockResponse, TigerJexlContext>> foundResponse;
        VariableAssigner.doAssignments((Map)mockResponse.getAssignments(), (RbelElement)requestRbelMessage, (TigerJexlContext)context);
        this.executeBackendRequestsBeforeDecision(mockResponse, context);
        if (!this.doesItMatch(mockResponse, context)) {
            if (log.isTraceEnabled()) {
                log.trace("Discarding response {} with criterions {} for message {}", new Object[]{mockResponse.getName(), mockResponse.getRequestCriterions(), requestRbelMessage.printTreeStructureWithoutColors()});
            }
            return Optional.empty();
        }
        if (mockResponse.getResponse() != null) {
            log.trace(CONSIDERING_RESPONSE, (Object)mockResponse.getResponse().getStatusCode(), (Object)mockResponse.getResponse().getBody());
            foundResponse = Optional.of(Pair.of((Object)mockResponse, (Object)context));
        } else {
            foundResponse = Optional.ofNullable(mockResponse.getNestedResponses()).map(Map::values).stream().flatMap(Collection::stream).sorted(Comparator.comparing(TigerMockResponse::getImportance).reversed()).map(r -> this.findMatchingResponse(r, requestRbelMessage, context.cloneContext())).filter(Optional::isPresent).map(Optional::get).peek(respPair -> log.trace(CONSIDERING_RESPONSE, (Object)((TigerMockResponse)respPair.getKey()).getResponse().getStatusCode(), (Object)((TigerMockResponse)respPair.getKey()).getResponse().getBody())).findFirst();
        }
        if (foundResponse.isPresent()) {
            this.executeBackendRequestsAfterDecision(mockResponse, context);
        }
        return foundResponse;
    }

    private boolean doesItMatch(TigerMockResponse mockResponse, TigerJexlContext context) {
        ArrayList combinedRequestCriterions = new ArrayList(mockResponse.getRequestCriterions());
        mockResponse.getRequestOptional().map(ZionRequestMatchDefinition::extractAdditionalCriteria).ifPresent(combinedRequestCriterions::addAll);
        RbelElement currentRequestRbelMessage = (RbelElement)context.getCurrentElement();
        ZionRequestMatchDefinition.PathMatchingResult pathMatchingResult = mockResponse.getRequestOptional().map(r -> r.matchPathVariables(currentRequestRbelMessage, context)).orElse(ZionRequestMatchDefinition.PathMatchingResult.EMPTY_MATCH);
        if (ZionRequestMatchDefinition.PathMatchingResult.EMPTY_MATCH.equals((Object)pathMatchingResult) && combinedRequestCriterions.isEmpty()) {
            return true;
        }
        VariableAssigner.doAssignments((Map)pathMatchingResult.capturedVariables(), (RbelElement)currentRequestRbelMessage, (TigerJexlContext)context);
        for (String requestCriterion : combinedRequestCriterions) {
            boolean criterionMatches = TigerJexlExecutor.matchesAsJexlExpression((String)TigerGlobalConfiguration.resolvePlaceholdersWithContext((String)requestCriterion, (TigerJexlContext)context), (TigerJexlContext)context);
            if (criterionMatches) continue;
            log.trace("Criterion does not match for response {}: {}", (Object)mockResponse.getName(), (Object)requestCriterion);
            return false;
        }
        if (pathMatchingResult.doesItMatch()) {
            return true;
        }
        log.trace("Path does not match for response {}", (Object)mockResponse.getName());
        return false;
    }

    private void executeBackendRequestsBeforeDecision(TigerMockResponse mockResponse, TigerJexlContext jexlContext) {
        List<ZionBackendRequestDescription> beforeDecision = mockResponse.getBackendRequests().values().stream().filter(r -> !r.isExecuteAfterSelection()).toList();
        this.backendRequestExecutor.executeBackendRequests(beforeDecision, jexlContext, this.requestRbelMessage);
    }

    private void executeBackendRequestsAfterDecision(TigerMockResponse mockResponse, TigerJexlContext jexlContext) {
        List<ZionBackendRequestDescription> afterDecision = mockResponse.getBackendRequests().values().stream().filter(ZionBackendRequestDescription::isExecuteAfterSelection).toList();
        this.backendRequestExecutor.executeBackendRequests(afterDecision, jexlContext, this.requestRbelMessage);
    }

    private Optional<ResponseEntity<byte[]>> spyWithRemoteServer(RequestEntity<byte[]> request) {
        if (this.configuration.getSpy() == null) {
            return Optional.empty();
        }
        URI targetUri = new URIBuilder(this.configuration.getSpy().getUrl()).setPath(request.getUrl().getPath()).setQuery(request.getUrl().getQuery()).build();
        String name = Optional.ofNullable(request.getMethod()).map(HttpMethod::name).orElse("");
        HttpRequestWithBody unirestRequest = (HttpRequestWithBody)Unirest.request((String)name, (String)targetUri.toString()).headers(request.getHeaders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, header -> String.join((CharSequence)",", (Iterable)header.getValue()))));
        if (request.hasBody()) {
            unirestRequest.body((byte[])request.getBody());
        }
        HttpResponse unirestResponse = unirestRequest.asBytes();
        ResponseEntity responseEntity = ResponseEntity.status((int)unirestResponse.getStatus()).body((Object)((byte[])unirestResponse.getBody()));
        this.parseResponseWithRbelLogger(responseEntity);
        RbelElement responseRbelMessage = (RbelElement)this.rbelLogger.getMessageHistory().getLast();
        TigerMockResponse mockResponse = TigerMockResponse.builder().requestCriterions(List.of("message.method == '" + name + "'", "message.url =$ '" + this.getUriEnding(targetUri) + "'")).response(TigerMockResponseDescription.builder().body((String)responseRbelMessage.getFirst("body").map(bodyElement -> this.rbelWriter.serializeWithEnforcedContentType(bodyElement, RbelContentType.JSON, new TigerJexlContext())).map(RbelSerializationResult::getContentAsString).orElse(null)).build()).build();
        FileUtils.writeStringToFile((File)Path.of(this.configuration.getSpy().getProtocolToPath(), "spy_" + UUID.randomUUID() + ".yaml").toFile(), (String)this.objectMapper.writeValueAsString((Object)mockResponse), (Charset)Charset.defaultCharset());
        return Optional.of(responseEntity);
    }

    private String getUriEnding(URI targetUri) {
        if (StringUtils.isEmpty((CharSequence)targetUri.getQuery())) {
            return targetUri.getPath();
        }
        return targetUri.getPath() + "?" + targetUri.getQuery();
    }

    private void parseResponseWithRbelLogger(ResponseEntity<byte[]> el) {
        this.rbelLogger.getRbelConverter().parseMessage(this.buildRawMessageApproximate(el), this.serverHostname, this.clientHostname, Optional.of(ZonedDateTime.now()));
    }

    private byte[] buildRawMessageApproximate(ResponseEntity<byte[]> response) {
        String header = "HTTP/1.1 " + response.getStatusCode().value();
        if (!response.getHeaders().isEmpty()) {
            header = header + "\r\n" + response.getHeaders().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(v -> (String)entry.getKey() + ": " + v)).collect(Collectors.joining("\r\n"));
        }
        header = header + "\r\n\r\n";
        if (response.hasBody()) {
            return ArrayUtils.addAll((byte[])header.getBytes(), (byte[])((byte[])response.getBody()));
        }
        return header.getBytes();
    }

    private Optional<RbelSerializationResult> renderResponseBody(TigerMockResponse response, TigerJexlContext context) {
        return Optional.ofNullable(response.getResponse().retrieveBodyData()).map(s -> this.rbelWriter.serialize(this.rbelLogger.getRbelConverter().convertElement(s, null), context));
    }

    @ConstructorProperties(value={"requestRbelMessage", "localServerPort", "responseStartTime", "clientHostname", "serverHostname", "objectMapper", "rbelLogger", "configuration", "request", "rbelWriter", "backendRequestExecutor"})
    @Generated
    ZionRequestExecutor(@NonNull RbelElement requestRbelMessage, int localServerPort, LocalDateTime responseStartTime, @NonNull RbelHostname clientHostname, @NonNull RbelHostname serverHostname, @NonNull ObjectMapper objectMapper, @NonNull RbelLogger rbelLogger, @NonNull ZionConfiguration configuration, @NonNull RequestEntity<byte[]> request, @NonNull RbelWriter rbelWriter, @NonNull BackendRequestExecutor backendRequestExecutor) {
        if (requestRbelMessage == null) {
            throw new NullPointerException("requestRbelMessage is marked non-null but is null");
        }
        if (clientHostname == null) {
            throw new NullPointerException("clientHostname is marked non-null but is null");
        }
        if (serverHostname == null) {
            throw new NullPointerException("serverHostname is marked non-null but is null");
        }
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (rbelLogger == null) {
            throw new NullPointerException("rbelLogger is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (rbelWriter == null) {
            throw new NullPointerException("rbelWriter is marked non-null but is null");
        }
        if (backendRequestExecutor == null) {
            throw new NullPointerException("backendRequestExecutor is marked non-null but is null");
        }
        this.requestRbelMessage = requestRbelMessage;
        this.localServerPort = localServerPort;
        this.responseStartTime = responseStartTime;
        this.clientHostname = clientHostname;
        this.serverHostname = serverHostname;
        this.objectMapper = objectMapper;
        this.rbelLogger = rbelLogger;
        this.configuration = configuration;
        this.request = request;
        this.rbelWriter = rbelWriter;
        this.backendRequestExecutor = backendRequestExecutor;
    }

    @Generated
    public static ZionRequestExecutorBuilder builder() {
        return new ZionRequestExecutorBuilder();
    }
}

