/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.zion.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.writer.RbelWriter;
import de.gematik.test.tiger.zion.config.TigerMockResponse;
import de.gematik.test.tiger.zion.config.ZionConfiguration;
import de.gematik.test.tiger.zion.services.BackendRequestExecutor;
import de.gematik.test.tiger.zion.services.ZionRequestExecutor;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

@RestController
@RequestMapping(value={"/"})
public class CatchAllController
implements WebMvcConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CatchAllController.class);
    private final RbelLogger rbelLogger;
    private final RbelWriter rbelWriter;
    private final ZionConfiguration configuration;
    private final ObjectMapper objectMapper;
    private final ServletWebServerApplicationContext webServerAppCtxt;
    private final BackendRequestExecutor backendRequestExecutor;

    @PostConstruct
    public void loadMockReponsesFromFile() {
        if (this.configuration.getMockResponseFiles() == null || this.configuration.getMockResponseFiles().isEmpty()) {
            log.info("Skipping initialization for mock-responses from files, none specified");
            return;
        }
        for (Map.Entry<String, String> entry : this.configuration.getMockResponseFiles().entrySet()) {
            File file = Path.of(entry.getValue(), new String[0]).toFile();
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                TigerMockResponse mockResponse = (TigerMockResponse)new Yaml((BaseConstructor)new Constructor(TigerMockResponse.class, new LoaderOptions())).load((InputStream)fileInputStream);
                this.configuration.getMockResponses().put(entry.getKey(), mockResponse);
                log.info("Successfully added mock-response from file {} with criteria {}", (Object)file.getAbsolutePath(), (Object)String.join((CharSequence)", ", mockResponse.getRequestCriterions()));
            }
        }
    }

    @RequestMapping(value={"**"}, consumes={"*/*", "application/*"}, produces={"*/*"}, method={RequestMethod.GET, RequestMethod.POST, RequestMethod.HEAD, RequestMethod.OPTIONS, RequestMethod.PUT, RequestMethod.PATCH, RequestMethod.DELETE, RequestMethod.TRACE})
    public ResponseEntity<byte[]> masterResponder(RequestEntity<byte[]> request, HttpServletRequest servletRequest) {
        LocalDateTime responseStartTime = LocalDateTime.now();
        log.info("Got new request {} {}", (Object)request.getMethod(), (Object)request.getUrl());
        byte[] rawMessage = this.buildRawMessageApproximate(request);
        RbelHostname client = RbelHostname.builder().hostname(servletRequest.getRemoteHost()).port(servletRequest.getRemotePort()).build();
        RbelHostname server = RbelHostname.builder().hostname(servletRequest.getLocalAddr()).port(servletRequest.getLocalPort()).build();
        RbelElement requestRbelMessage = this.rbelLogger.getRbelConverter().parseMessage(rawMessage, client, server, Optional.of(ZonedDateTime.now()));
        ResponseEntity<byte[]> response = ZionRequestExecutor.builder().clientHostname(client).serverHostname(server).requestRbelMessage(requestRbelMessage).rbelLogger(this.rbelLogger).rbelWriter(this.rbelWriter).objectMapper(this.objectMapper).localServerPort(this.webServerAppCtxt.getWebServer().getPort()).configuration(this.configuration).backendRequestExecutor(this.backendRequestExecutor).request(request).responseStartTime(responseStartTime).build().execute();
        log.info("Returning response {}", response);
        return response;
    }

    private byte[] buildRawMessageApproximate(RequestEntity<byte[]> request) {
        String header = request.getMethod() + " " + request.getUrl() + " HTTP/1.1\r\n" + request.getHeaders().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(v -> (String)entry.getKey() + ": " + v)).collect(Collectors.joining("\r\n")) + "\r\n\r\n";
        if (request.hasBody()) {
            return ArrayUtils.addAll((byte[])header.getBytes(), (byte[])((byte[])request.getBody()));
        }
        return header.getBytes();
    }

    @ConstructorProperties(value={"rbelLogger", "rbelWriter", "configuration", "objectMapper", "webServerAppCtxt", "backendRequestExecutor"})
    @Generated
    public CatchAllController(RbelLogger rbelLogger, RbelWriter rbelWriter, ZionConfiguration configuration, ObjectMapper objectMapper, ServletWebServerApplicationContext webServerAppCtxt, BackendRequestExecutor backendRequestExecutor) {
        this.rbelLogger = rbelLogger;
        this.rbelWriter = rbelWriter;
        this.configuration = configuration;
        this.objectMapper = objectMapper;
        this.webServerAppCtxt = webServerAppCtxt;
        this.backendRequestExecutor = backendRequestExecutor;
    }
}

