/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.zion.services;

import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.writer.RbelSerializationResult;
import de.gematik.rbellogger.writer.RbelWriter;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import de.gematik.test.tiger.zion.config.ZionBackendRequestDescription;
import de.gematik.test.tiger.zion.config.ZionConfiguration;
import de.gematik.test.tiger.zion.services.BackendRequestExecutor;
import de.gematik.test.tiger.zion.services.VariableAssigner;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kong.unirest.Client;
import kong.unirest.Config;
import kong.unirest.Headers;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestInstance;
import kong.unirest.apache.ApacheClient;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class BackendRequestExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BackendRequestExecutor.class);
    private final ZionConfiguration zionConfiguration;
    private final RbelLogger rbelLogger;
    private final RbelWriter rbelWriter;

    public void executeBackendRequests(List<ZionBackendRequestDescription> backendRequests, TigerJexlContext jexlContext, RbelElement requestRbelMessage) {
        for (ZionBackendRequestDescription requestDescription : backendRequests) {
            try {
                HttpResponse unirestResponse = this.prepareAndExecuteBackendRequest(requestDescription, requestRbelMessage);
                RbelElement rbelResponse = this.rbelLogger.getRbelConverter().convertElement(this.responseToRawMessage(unirestResponse), null);
                VariableAssigner.doAssignments((Map)requestDescription.getAssignments(), (RbelElement)rbelResponse, (TigerJexlContext)jexlContext);
            }
            catch (RuntimeException e) {
                log.error("Error during backend request '" + requestDescription.getMethod() + " " + requestDescription.getUrl() + "'", (Throwable)e);
                throw e;
            }
        }
    }

    private HttpResponse<byte[]> prepareAndExecuteBackendRequest(ZionBackendRequestDescription requestDescription, RbelElement requestRbelMessage) {
        String method = BackendRequestExecutor.getMethod((ZionBackendRequestDescription)requestDescription);
        try (UnirestInstance unirestInstance = this.createUnirestInstance();){
            HttpResponse unirestResponse;
            HttpRequestWithBody unirestRequest = unirestInstance.request(method, TigerGlobalConfiguration.resolvePlaceholdersWithContext((String)requestDescription.getUrl(), (TigerJexlContext)new TigerJexlContext().withRootElement((Object)requestRbelMessage)));
            if (requestDescription.getHeaders() != null) {
                requestDescription.getHeaders().forEach((arg_0, arg_1) -> ((HttpRequestWithBody)unirestRequest).header(arg_0, arg_1));
            }
            if (StringUtils.isNotEmpty((CharSequence)requestDescription.getBody())) {
                RbelSerializationResult body = this.getBody(requestDescription, requestRbelMessage);
                if (log.isTraceEnabled()) {
                    log.trace("About to sent {} with body {} to {}", new Object[]{unirestRequest.getHttpMethod().name(), body.getContentAsString(), unirestRequest.getUrl()});
                }
                unirestResponse = unirestRequest.body(body.getContent()).asBytes();
            } else {
                if (log.isTraceEnabled()) {
                    log.trace("About to sent {} without body to {}", (Object)unirestRequest.getHttpMethod().name(), (Object)unirestRequest.getUrl());
                }
                unirestResponse = unirestRequest.asBytes();
            }
            HttpResponse httpResponse = unirestResponse;
            return httpResponse;
        }
    }

    private byte[] responseToRawMessage(HttpResponse<byte[]> response) {
        byte[] httpResponseHeader = ("HTTP/1.1 " + response.getStatus() + " " + (response.getStatusText() != null ? response.getStatusText() : "") + "\r\n" + this.formatHeaderList(response.getHeaders()) + "\r\n\r\n").getBytes(StandardCharsets.US_ASCII);
        return ArrayUtils.addAll((byte[])httpResponseHeader, (byte[])((byte[])response.getBody()));
    }

    private String formatHeaderList(Headers headerList) {
        return headerList.all().stream().filter(h -> !h.getName().equalsIgnoreCase("Transfer-Encoding")).map(h -> h.getName() + ": " + h.getValue()).collect(Collectors.joining("\r\n"));
    }

    private RbelSerializationResult getBody(ZionBackendRequestDescription requestDescription, RbelElement requestRbelMessage) {
        String rawContent = TigerGlobalConfiguration.resolvePlaceholders((String)requestDescription.getBody());
        RbelElement input = this.rbelLogger.getRbelConverter().convertElement(rawContent, null);
        return this.rbelWriter.serialize(input, new TigerJexlContext().withRootElement((Object)requestRbelMessage));
    }

    private static String getMethod(ZionBackendRequestDescription requestDescription) {
        if (StringUtils.isEmpty((CharSequence)requestDescription.getMethod())) {
            if (StringUtils.isEmpty((CharSequence)requestDescription.getBody())) {
                return "GET";
            }
            return "POST";
        }
        return TigerGlobalConfiguration.resolvePlaceholders((String)requestDescription.getMethod());
    }

    private UnirestInstance createUnirestInstance() {
        UnirestInstance unirestInstance = Unirest.spawnInstance();
        unirestInstance.config().httpClient(this.buildHttpClient());
        return unirestInstance;
    }

    private Function<Config, Client> buildHttpClient() {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)new SpyOnSocketPortConnectionManager(this.zionConfiguration.getServerName()));
        if (this.zionConfiguration.getLocalTigerProxy() == null) {
            return ApacheClient.builder((HttpClient)httpClientBuilder.useSystemProperties().build());
        }
        return ApacheClient.builder((HttpClient)httpClientBuilder.setProxy(HttpHost.create((String)this.zionConfiguration.getLocalTigerProxy())).build());
    }

    @ConstructorProperties(value={"zionConfiguration", "rbelLogger", "rbelWriter"})
    @Generated
    public BackendRequestExecutor(ZionConfiguration zionConfiguration, RbelLogger rbelLogger, RbelWriter rbelWriter) {
        this.zionConfiguration = zionConfiguration;
        this.rbelLogger = rbelLogger;
        this.rbelWriter = rbelWriter;
    }
}

