/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.zion.controller;

import de.gematik.test.tiger.zion.data.ZionErrorDto;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class ZionExceptionAdvice
extends ResponseEntityExceptionHandler {
    @ExceptionHandler(value={RuntimeException.class})
    protected ResponseEntity<Object> handleConflict(RuntimeException ex, WebRequest request) {
        this.logger.warn((Object)"Error during request processing", (Throwable)ex);
        return this.handleExceptionInternal((Exception)ex, (Object)this.transformExceptionToErrorDto(ex), new HttpHeaders(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, request);
    }

    private ZionErrorDto transformExceptionToErrorDto(RuntimeException ex) {
        return ZionErrorDto.builder().errorMessage(ex.getMessage()).errorType(ex.getClass().getSimpleName()).stacktrace(ExceptionUtils.getStackTrace((Throwable)ex)).build();
    }
}

