/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.zion.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelHttpRequestFacet;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import de.gematik.test.tiger.zion.config.ZionRequestMatchDefinition;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.http.server.PathContainer;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZionRequestMatchDefinition {
    private String path;
    private String method;
    @JsonProperty
    private List<String> additionalCriterions;

    public PathMatchingResult matchPathVariables(RbelElement requestRbelMessage, TigerJexlContext context) {
        if (this.path == null) {
            return PathMatchingResult.EMPTY_MATCH;
        }
        String fullUrlFromRequest = requestRbelMessage.getFacet(RbelHttpRequestFacet.class).map(f -> f.getPath().getRawStringContent()).orElse("");
        String pathFromRequest = (String)context.getOptional("remainingPathToMatch").orElseGet(() -> ZionRequestMatchDefinition.getPathFromFullUrl((String)fullUrlFromRequest));
        PathPattern pathPattern = PathPatternParser.defaultInstance.parse(this.path);
        PathPattern.PathRemainingMatchInfo matchInfo = pathPattern.matchStartOfPath(PathContainer.parsePath((String)pathFromRequest));
        if (matchInfo == null) {
            return PathMatchingResult.NO_MATCH;
        }
        context.set("remainingPathToMatch", (Object)matchInfo.getPathRemaining().value());
        Map capturedVariables = matchInfo.getUriVariables();
        return new PathMatchingResult(true, capturedVariables);
    }

    private static String getPathFromFullUrl(String fullUrlFromRequest) {
        return new URI(fullUrlFromRequest).getPath();
    }

    public List<String> extractAdditionalCriteria() {
        ArrayList<String> additionalCriteria = new ArrayList<String>(this.additionalCriterions);
        if (this.method != null) {
            additionalCriteria.add("message.method == '%s'".formatted(this.method));
        }
        return additionalCriteria;
    }

    @Generated
    private static List<String> $default$additionalCriterions() {
        return new ArrayList<String>();
    }

    @Generated
    public static ZionRequestMatchDefinitionBuilder builder() {
        return new ZionRequestMatchDefinitionBuilder();
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setMethod(String method) {
        this.method = method;
    }

    @JsonProperty
    @Generated
    public void setAdditionalCriterions(List<String> additionalCriterions) {
        this.additionalCriterions = additionalCriterions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZionRequestMatchDefinition)) {
            return false;
        }
        ZionRequestMatchDefinition other = (ZionRequestMatchDefinition)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        List this$additionalCriterions = this.additionalCriterions;
        List other$additionalCriterions = other.additionalCriterions;
        return !(this$additionalCriterions == null ? other$additionalCriterions != null : !((Object)this$additionalCriterions).equals(other$additionalCriterions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ZionRequestMatchDefinition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        List $additionalCriterions = this.additionalCriterions;
        result = result * 59 + ($additionalCriterions == null ? 43 : ((Object)$additionalCriterions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ZionRequestMatchDefinition(path=" + this.getPath() + ", method=" + this.getMethod() + ", additionalCriterions=" + this.additionalCriterions + ")";
    }

    @Generated
    public ZionRequestMatchDefinition() {
        this.additionalCriterions = ZionRequestMatchDefinition.$default$additionalCriterions();
    }

    @ConstructorProperties(value={"path", "method", "additionalCriterions"})
    @JsonIgnore
    @Generated
    public ZionRequestMatchDefinition(String path, String method, List<String> additionalCriterions) {
        this.path = path;
        this.method = method;
        this.additionalCriterions = additionalCriterions;
    }
}

