/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.zion.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.writer.RbelContentType;
import de.gematik.rbellogger.writer.RbelSerializationResult;
import de.gematik.rbellogger.writer.RbelWriter;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import de.gematik.test.tiger.common.jexl.TigerJexlExecutor;
import de.gematik.test.tiger.zion.config.TigerMockResponse;
import de.gematik.test.tiger.zion.config.TigerMockResponseDescription;
import de.gematik.test.tiger.zion.config.ZionBackendRequestDescription;
import de.gematik.test.tiger.zion.config.ZionConfiguration;
import de.gematik.test.tiger.zion.config.ZionRequestMatchDefinition;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import kong.unirest.Headers;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.server.ResponseStatusException;

public class ZionRequestExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZionRequestExecutor.class);
    private static final String CONSIDERING_RESPONSE = "Considering response {} {}";
    @NonNull
    private final RbelElement requestRbelMessage;
    private final int localServerPort;
    @NonNull
    private final RbelHostname clientHostname;
    @NonNull
    private final RbelHostname serverHostname;
    @NonNull
    private final ObjectMapper objectMapper;
    @NonNull
    private final RbelLogger rbelLogger;
    @NonNull
    private final ZionConfiguration configuration;
    @NonNull
    private final RequestEntity<byte[]> request;
    @NonNull
    private final RbelWriter rbelWriter;

    public ResponseEntity<byte[]> execute() {
        TigerJexlContext mainContext = new TigerJexlContext().with("zion.port", String.valueOf(this.localServerPort)).withRootElement((Object)this.requestRbelMessage);
        Optional<Pair<TigerMockResponse, TigerJexlContext>> configuredResponse = this.findResponseForGivenRequest(this.requestRbelMessage, mainContext);
        if (configuredResponse.isPresent()) {
            TigerMockResponse chosenResponse = (TigerMockResponse)configuredResponse.get().getLeft();
            TigerJexlContext responseContext = (TigerJexlContext)configuredResponse.get().getRight();
            ResponseEntity<byte[]> responseEntity = this.renderResponse(chosenResponse, responseContext);
            return this.parseResponseWithRbelLogger(responseEntity);
        }
        return this.spyWithRemoteServer(this.request).orElseThrow(() -> {
            log.warn("Could not match request \n{}", (Object)this.requestRbelMessage.printTreeStructure());
            return new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "No suitable return value found");
        });
    }

    private Optional<Pair<TigerMockResponse, TigerJexlContext>> findResponseForGivenRequest(RbelElement requestRbelMessage, TigerJexlContext context) {
        for (TigerMockResponse response : this.configuration.getMockResponses().values().stream().sorted(Comparator.comparing(TigerMockResponse::getImportance).reversed()).toList()) {
            if (response.getResponse() != null) {
                log.trace(CONSIDERING_RESPONSE, (Object)response.getResponse().getStatusCode(), (Object)response.getResponse().getBody());
            } else {
                log.trace("Considering response without body, nested responses: {}", response.getNestedResponses().keySet());
            }
            TigerJexlContext localResponseContext = context.withCurrentElement((Object)requestRbelMessage).withRootElement((Object)requestRbelMessage);
            this.doAssignments(response.getAssignments(), requestRbelMessage, localResponseContext);
            this.executeBackendRequestsBeforeDecision(response, localResponseContext);
            Optional<Pair<TigerMockResponse, TigerJexlContext>> responseCandidate = this.findMatchingResponse(response, requestRbelMessage, localResponseContext);
            if (!responseCandidate.isPresent()) continue;
            return responseCandidate;
        }
        return Optional.empty();
    }

    private ResponseEntity<byte[]> renderResponse(TigerMockResponse response, TigerJexlContext context) {
        Optional<RbelSerializationResult> serializationResult = this.renderResponseBody(response, context);
        ResponseEntity.BodyBuilder responseBuilder = ResponseEntity.status((int)response.getResponse().getStatusCode());
        serializationResult.flatMap(RbelSerializationResult::getContentType).map(RbelContentType::getContentTypeString).map(MediaType::parseMediaType).ifPresent(arg_0 -> ((ResponseEntity.BodyBuilder)responseBuilder).contentType(arg_0));
        for (Map.Entry<String, String> entry : response.getResponse().getHeaders().entrySet()) {
            RbelElement convertedElement = this.rbelLogger.getRbelConverter().convertElement(entry.getValue(), null);
            RbelSerializationResult serialized = this.rbelWriter.serialize(convertedElement, new TigerJexlContext().withRootElement((Object)this.requestRbelMessage));
            if (serialized.getContent() != null) {
                responseBuilder.header(entry.getKey(), new String[]{serialized.getContentAsString()});
                continue;
            }
            responseBuilder.header(entry.getKey(), new String[]{""});
        }
        return responseBuilder.body((Object)serializationResult.map(RbelSerializationResult::getContent).orElse(null));
    }

    private void doAssignments(Map<String, String> assignments, RbelElement currentElement, TigerJexlContext jexlContext) {
        if (assignments == null || assignments.isEmpty()) {
            return;
        }
        TigerJexlContext localResponseContext = jexlContext.withCurrentElement((Object)currentElement).withRootElement((Object)currentElement);
        for (Map.Entry<String, String> entry : assignments.entrySet()) {
            String newValue = Optional.of(entry.getValue()).filter(s -> s.startsWith("$.")).flatMap(arg_0 -> ((RbelElement)currentElement).findElement(arg_0)).map(el -> el.seekValue(String.class).orElseGet(() -> ((RbelElement)el).getRawStringContent())).map(TigerGlobalConfiguration::resolvePlaceholders).orElseGet(() -> TigerGlobalConfiguration.resolvePlaceholdersWithContext((String)((String)entry.getValue()), (TigerJexlContext)localResponseContext));
            String key = TigerGlobalConfiguration.resolvePlaceholdersWithContext((String)entry.getKey(), (TigerJexlContext)localResponseContext);
            jexlContext.put(key, (Object)newValue);
        }
    }

    private Optional<Pair<TigerMockResponse, TigerJexlContext>> findMatchingResponse(TigerMockResponse mockResponse, RbelElement requestRbelMessage, TigerJexlContext context) {
        if (!this.doesItMatch(mockResponse, context)) {
            if (log.isTraceEnabled() && mockResponse.getResponse() != null) {
                log.trace("Discarding response {} {} with criterions {} for message {}", new Object[]{mockResponse.getResponse().getStatusCode(), mockResponse.getResponse().getBody(), mockResponse.getRequestCriterions(), requestRbelMessage.printTreeStructureWithoutColors()});
            }
            return Optional.empty();
        }
        if (mockResponse.getResponse() != null) {
            log.trace(CONSIDERING_RESPONSE, (Object)mockResponse.getResponse().getStatusCode(), (Object)mockResponse.getResponse().getBody());
            return Optional.of(Pair.of((Object)mockResponse, (Object)context));
        }
        return Optional.ofNullable(mockResponse.getNestedResponses()).map(Map::values).stream().flatMap(Collection::stream).sorted(Comparator.comparing(TigerMockResponse::getImportance).reversed()).map(r -> this.findMatchingResponse((TigerMockResponse)r, requestRbelMessage, context.cloneContext())).filter(Optional::isPresent).map(Optional::get).peek(respPair -> log.trace(CONSIDERING_RESPONSE, (Object)((TigerMockResponse)respPair.getKey()).getResponse().getStatusCode(), (Object)((TigerMockResponse)respPair.getKey()).getResponse().getBody())).findFirst();
    }

    private boolean doesItMatch(TigerMockResponse mockResponse, TigerJexlContext context) {
        ArrayList<String> combinedRequestCriterions = new ArrayList<String>(mockResponse.getRequestCriterions());
        mockResponse.getRequestOptional().map(ZionRequestMatchDefinition::extractAdditionalCriteria).ifPresent(combinedRequestCriterions::addAll);
        RbelElement currentRequestRbelMessage = (RbelElement)context.getCurrentElement();
        ZionRequestMatchDefinition.PathMatchingResult pathMatchingResult = mockResponse.getRequestOptional().map(r -> r.matchPathVariables(currentRequestRbelMessage, context)).orElse(ZionRequestMatchDefinition.PathMatchingResult.EMPTY_MATCH);
        if (ZionRequestMatchDefinition.PathMatchingResult.EMPTY_MATCH.equals(pathMatchingResult) && combinedRequestCriterions.isEmpty()) {
            return true;
        }
        this.doAssignments(pathMatchingResult.capturedVariables(), currentRequestRbelMessage, context);
        return combinedRequestCriterions.stream().allMatch(criterion -> TigerJexlExecutor.matchesAsJexlExpression((String)TigerGlobalConfiguration.resolvePlaceholdersWithContext((String)criterion, (TigerJexlContext)context), (TigerJexlContext)context)) && pathMatchingResult.doesItMatch();
    }

    private void executeBackendRequestsBeforeDecision(TigerMockResponse mockResponse, TigerJexlContext jexlContext) {
        if (mockResponse.getBackendRequests() == null) {
            return;
        }
        for (ZionBackendRequestDescription requestDescription : mockResponse.getBackendRequests().values()) {
            try {
                HttpResponse<byte[]> unirestResponse = this.prepareAndExecuteBackendRequest(requestDescription);
                RbelElement rbelResponse = this.rbelLogger.getRbelConverter().convertElement(this.responseToRawMessage(unirestResponse), null);
                this.doAssignments(requestDescription.getAssignments(), rbelResponse, jexlContext);
            }
            catch (RuntimeException e) {
                log.error("Error during backend request '" + requestDescription.getMethod() + " " + requestDescription.getUrl() + "'", (Throwable)e);
                throw e;
            }
        }
    }

    private HttpResponse<byte[]> prepareAndExecuteBackendRequest(ZionBackendRequestDescription requestDescription) {
        HttpResponse unirestResponse;
        String method = ZionRequestExecutor.getMethod(requestDescription);
        HttpRequestWithBody unirestRequest = Unirest.request((String)method, (String)TigerGlobalConfiguration.resolvePlaceholdersWithContext((String)requestDescription.getUrl(), (TigerJexlContext)new TigerJexlContext().withRootElement((Object)this.requestRbelMessage)));
        if (requestDescription.getHeaders() != null) {
            requestDescription.getHeaders().forEach((arg_0, arg_1) -> ((HttpRequestWithBody)unirestRequest).header(arg_0, arg_1));
        }
        if (StringUtils.isNotEmpty((CharSequence)requestDescription.getBody())) {
            RbelSerializationResult body = this.getBody(requestDescription);
            if (log.isTraceEnabled()) {
                log.trace("About to sent {} with body {} to {}", new Object[]{unirestRequest.getHttpMethod().name(), new String(body.getContent()), unirestRequest.getUrl()});
            }
            unirestResponse = unirestRequest.body(body.getContent()).asBytes();
        } else {
            if (log.isTraceEnabled()) {
                log.trace("About to sent {} without body to {}", (Object)unirestRequest.getHttpMethod().name(), (Object)unirestRequest.getUrl());
            }
            unirestResponse = unirestRequest.asBytes();
        }
        return unirestResponse;
    }

    private RbelSerializationResult getBody(ZionBackendRequestDescription requestDescription) {
        String rawContent = TigerGlobalConfiguration.resolvePlaceholders((String)requestDescription.getBody());
        RbelElement input = this.rbelLogger.getRbelConverter().convertElement(rawContent, null);
        return this.rbelWriter.serialize(input, new TigerJexlContext().withRootElement((Object)this.requestRbelMessage));
    }

    private static String getMethod(ZionBackendRequestDescription requestDescription) {
        if (StringUtils.isEmpty((CharSequence)requestDescription.getMethod())) {
            if (StringUtils.isEmpty((CharSequence)requestDescription.getBody())) {
                return "GET";
            }
            return "POST";
        }
        return TigerGlobalConfiguration.resolvePlaceholders((String)requestDescription.getMethod());
    }

    private byte[] responseToRawMessage(HttpResponse<byte[]> response) {
        byte[] httpResponseHeader = ("HTTP/1.1 " + response.getStatus() + " " + (response.getStatusText() != null ? response.getStatusText() : "") + "\r\n" + this.formatHeaderList(response.getHeaders()) + "\r\n\r\n").getBytes(StandardCharsets.US_ASCII);
        return ArrayUtils.addAll((byte[])httpResponseHeader, (byte[])((byte[])response.getBody()));
    }

    private String formatHeaderList(Headers headerList) {
        return headerList.all().stream().map(h -> h.getName() + ": " + h.getValue()).collect(Collectors.joining("\r\n"));
    }

    private Optional<ResponseEntity<byte[]>> spyWithRemoteServer(RequestEntity<byte[]> request) {
        if (this.configuration.getSpy() == null) {
            return Optional.empty();
        }
        URI targetUri = new URIBuilder(this.configuration.getSpy().getUrl()).setPath(request.getUrl().getPath()).setQuery(request.getUrl().getQuery()).build();
        String name = Optional.ofNullable(request.getMethod()).map(HttpMethod::name).orElse("");
        HttpRequestWithBody unirestRequest = (HttpRequestWithBody)Unirest.request((String)name, (String)targetUri.toString()).headers(request.getHeaders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, header -> String.join((CharSequence)",", (Iterable)header.getValue()))));
        if (request.hasBody()) {
            unirestRequest.body((byte[])request.getBody());
        }
        HttpResponse unirestResponse = unirestRequest.asBytes();
        ResponseEntity<byte[]> responseEntity = this.parseResponseWithRbelLogger((ResponseEntity<byte[]>)ResponseEntity.status((int)unirestResponse.getStatus()).body((Object)((byte[])unirestResponse.getBody())));
        RbelElement responseRbelMessage = (RbelElement)this.rbelLogger.getMessageHistory().getLast();
        TigerMockResponse mockResponse = TigerMockResponse.builder().requestCriterions(List.of("message.method == '" + name + "'", "message.url =$ '" + this.getUriEnding(targetUri) + "'")).response(TigerMockResponseDescription.builder().body(responseRbelMessage.getFirst("body").map(bodyElement -> this.rbelWriter.serializeWithEnforcedContentType(bodyElement, RbelContentType.JSON, new TigerJexlContext())).map(RbelSerializationResult::getContentAsString).orElse(null)).build()).build();
        FileUtils.writeStringToFile((File)Path.of(this.configuration.getSpy().getProtocolToPath(), "spy_" + UUID.randomUUID() + ".yaml").toFile(), (String)this.objectMapper.writeValueAsString((Object)mockResponse), (Charset)Charset.defaultCharset());
        return Optional.of(responseEntity);
    }

    private String getUriEnding(URI targetUri) {
        if (StringUtils.isEmpty((CharSequence)targetUri.getQuery())) {
            return targetUri.getPath();
        }
        return targetUri.getPath() + "?" + targetUri.getQuery();
    }

    private ResponseEntity<byte[]> parseResponseWithRbelLogger(ResponseEntity<byte[]> el) {
        this.rbelLogger.getRbelConverter().parseMessage(this.buildRawMessageApproximate(el), this.serverHostname, this.clientHostname, Optional.of(ZonedDateTime.now()));
        return el;
    }

    private byte[] buildRawMessageApproximate(ResponseEntity<byte[]> response) {
        String header = "HTTP/1.1 " + response.getStatusCode().value();
        if (!response.getHeaders().isEmpty()) {
            header = header + "\r\n" + response.getHeaders().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(v -> (String)entry.getKey() + ": " + v)).collect(Collectors.joining("\r\n"));
        }
        header = header + "\r\n\r\n";
        if (response.hasBody()) {
            return ArrayUtils.addAll((byte[])header.getBytes(), (byte[])((byte[])response.getBody()));
        }
        return header.getBytes();
    }

    private Optional<RbelSerializationResult> renderResponseBody(TigerMockResponse response, TigerJexlContext context) {
        Optional<String> bodyBlueprint = Optional.ofNullable(response.getResponse().getBody()).filter(Objects::nonNull).or(() -> Optional.ofNullable(response.getResponse().getBodyFile()).map(x$0 -> Path.of(x$0, new String[0])).map(p -> {
            try {
                return Files.readString(p);
            }
            catch (IOException e) {
                return null;
            }
        }).filter(Objects::nonNull));
        if (bodyBlueprint.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.rbelWriter.serialize(this.rbelLogger.getRbelConverter().convertElement(bodyBlueprint.get(), null), context));
    }

    @ConstructorProperties(value={"requestRbelMessage", "localServerPort", "clientHostname", "serverHostname", "objectMapper", "rbelLogger", "configuration", "request", "rbelWriter"})
    @Generated
    ZionRequestExecutor(@NonNull RbelElement requestRbelMessage, int localServerPort, @NonNull RbelHostname clientHostname, @NonNull RbelHostname serverHostname, @NonNull ObjectMapper objectMapper, @NonNull RbelLogger rbelLogger, @NonNull ZionConfiguration configuration, @NonNull RequestEntity<byte[]> request, @NonNull RbelWriter rbelWriter) {
        if (requestRbelMessage == null) {
            throw new NullPointerException("requestRbelMessage is marked non-null but is null");
        }
        if (clientHostname == null) {
            throw new NullPointerException("clientHostname is marked non-null but is null");
        }
        if (serverHostname == null) {
            throw new NullPointerException("serverHostname is marked non-null but is null");
        }
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (rbelLogger == null) {
            throw new NullPointerException("rbelLogger is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (rbelWriter == null) {
            throw new NullPointerException("rbelWriter is marked non-null but is null");
        }
        this.requestRbelMessage = requestRbelMessage;
        this.localServerPort = localServerPort;
        this.clientHostname = clientHostname;
        this.serverHostname = serverHostname;
        this.objectMapper = objectMapper;
        this.rbelLogger = rbelLogger;
        this.configuration = configuration;
        this.request = request;
        this.rbelWriter = rbelWriter;
    }

    @Generated
    public static ZionRequestExecutorBuilder builder() {
        return new ZionRequestExecutorBuilder();
    }

    @Generated
    public static class ZionRequestExecutorBuilder {
        @Generated
        private RbelElement requestRbelMessage;
        @Generated
        private int localServerPort;
        @Generated
        private RbelHostname clientHostname;
        @Generated
        private RbelHostname serverHostname;
        @Generated
        private ObjectMapper objectMapper;
        @Generated
        private RbelLogger rbelLogger;
        @Generated
        private ZionConfiguration configuration;
        @Generated
        private RequestEntity<byte[]> request;
        @Generated
        private RbelWriter rbelWriter;

        @Generated
        ZionRequestExecutorBuilder() {
        }

        @Generated
        public ZionRequestExecutorBuilder requestRbelMessage(@NonNull RbelElement requestRbelMessage) {
            if (requestRbelMessage == null) {
                throw new NullPointerException("requestRbelMessage is marked non-null but is null");
            }
            this.requestRbelMessage = requestRbelMessage;
            return this;
        }

        @Generated
        public ZionRequestExecutorBuilder localServerPort(int localServerPort) {
            this.localServerPort = localServerPort;
            return this;
        }

        @Generated
        public ZionRequestExecutorBuilder clientHostname(@NonNull RbelHostname clientHostname) {
            if (clientHostname == null) {
                throw new NullPointerException("clientHostname is marked non-null but is null");
            }
            this.clientHostname = clientHostname;
            return this;
        }

        @Generated
        public ZionRequestExecutorBuilder serverHostname(@NonNull RbelHostname serverHostname) {
            if (serverHostname == null) {
                throw new NullPointerException("serverHostname is marked non-null but is null");
            }
            this.serverHostname = serverHostname;
            return this;
        }

        @Generated
        public ZionRequestExecutorBuilder objectMapper(@NonNull ObjectMapper objectMapper) {
            if (objectMapper == null) {
                throw new NullPointerException("objectMapper is marked non-null but is null");
            }
            this.objectMapper = objectMapper;
            return this;
        }

        @Generated
        public ZionRequestExecutorBuilder rbelLogger(@NonNull RbelLogger rbelLogger) {
            if (rbelLogger == null) {
                throw new NullPointerException("rbelLogger is marked non-null but is null");
            }
            this.rbelLogger = rbelLogger;
            return this;
        }

        @Generated
        public ZionRequestExecutorBuilder configuration(@NonNull ZionConfiguration configuration) {
            if (configuration == null) {
                throw new NullPointerException("configuration is marked non-null but is null");
            }
            this.configuration = configuration;
            return this;
        }

        @Generated
        public ZionRequestExecutorBuilder request(@NonNull RequestEntity<byte[]> request) {
            if (request == null) {
                throw new NullPointerException("request is marked non-null but is null");
            }
            this.request = request;
            return this;
        }

        @Generated
        public ZionRequestExecutorBuilder rbelWriter(@NonNull RbelWriter rbelWriter) {
            if (rbelWriter == null) {
                throw new NullPointerException("rbelWriter is marked non-null but is null");
            }
            this.rbelWriter = rbelWriter;
            return this;
        }

        @Generated
        public ZionRequestExecutor build() {
            return new ZionRequestExecutor(this.requestRbelMessage, this.localServerPort, this.clientHostname, this.serverHostname, this.objectMapper, this.rbelLogger, this.configuration, this.request, this.rbelWriter);
        }

        @Generated
        public String toString() {
            return "ZionRequestExecutor.ZionRequestExecutorBuilder(requestRbelMessage=" + this.requestRbelMessage + ", localServerPort=" + this.localServerPort + ", clientHostname=" + this.clientHostname + ", serverHostname=" + this.serverHostname + ", objectMapper=" + this.objectMapper + ", rbelLogger=" + this.rbelLogger + ", configuration=" + this.configuration + ", request=" + this.request + ", rbelWriter=" + this.rbelWriter + ")";
        }
    }
}

