/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.zion.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.writer.RbelContentType;
import de.gematik.rbellogger.writer.RbelWriter;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.config.TigerScopedExecutor;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import de.gematik.test.tiger.common.jexl.TigerJexlExecutor;
import de.gematik.test.tiger.zion.config.TigerMockResponse;
import de.gematik.test.tiger.zion.config.TigerMockResponseDescription;
import de.gematik.test.tiger.zion.config.ZionBackendRequestDescription;
import de.gematik.test.tiger.zion.config.ZionConfiguration;
import de.gematik.test.tiger.zion.services.ZionRequestExecutor;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import kong.unirest.Headers;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.server.ResponseStatusException;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZionRequestExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZionRequestExecutor.class);
    @NonNull
    private final RbelElement requestRbelMessage;
    @NonNull
    private final int localServerPort;
    @NonNull
    private final RbelHostname clientHostname;
    @NonNull
    private final RbelHostname serverHostname;
    @NonNull
    private final ObjectMapper objectMapper;
    @NonNull
    private final RbelLogger rbelLogger;
    @NonNull
    private final ZionConfiguration configuration;
    @NonNull
    private final RequestEntity<byte[]> request;
    @NonNull
    private final RbelWriter rbelWriter;
    private TigerScopedExecutor tigerScopedExecutor;

    public ResponseEntity<byte[]> execute() {
        this.tigerScopedExecutor = TigerGlobalConfiguration.localScope().withValue("zion.port", String.valueOf(this.localServerPort));
        return (ResponseEntity)this.tigerScopedExecutor.retrieve(() -> this.findResponseForGivenRequest(this.requestRbelMessage).map(arg_0 -> this.renderResponse(arg_0)).map(arg_0 -> this.parseResponseWithRbelLogger(arg_0)).or(() -> this.spyWithRemoteServer(this.request)).orElseThrow(() -> {
            log.warn("Could not match request \n{}", (Object)this.requestRbelMessage.printTreeStructure());
            return new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "No suitable return value found");
        }));
    }

    private Optional<TigerMockResponse> findResponseForGivenRequest(RbelElement requestRbelMessage) {
        return this.configuration.getMockResponses().values().stream().sorted(Comparator.comparing(TigerMockResponse::getImportance).reversed()).peek(resp -> {
            if (resp.getResponse() != null) {
                log.trace("Considering response {} {}", (Object)resp.getResponse().getStatusCode(), (Object)resp.getResponse().getBody());
            } else {
                log.trace("Considering response without body, nested responses: {}", resp.getNestedResponses().keySet());
            }
        }).map(entry -> this.findMatchingResponse(entry, requestRbelMessage)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private ResponseEntity<byte[]> renderResponse(TigerMockResponse response) {
        this.doAssignments(response.getAssignments(), this.requestRbelMessage);
        ResponseEntity.BodyBuilder responseBuilder = ResponseEntity.status((int)response.getResponse().getStatusCode());
        response.getResponse().getHeaders().forEach((key, value) -> responseBuilder.header(key, new String[]{new String(this.rbelWriter.serialize(this.rbelLogger.getRbelConverter().convertElement(value, null), new TigerJexlContext().withRootElement((Object)this.requestRbelMessage)))}));
        return responseBuilder.body((Object)this.renderResponseBody(response));
    }

    private void doAssignments(Map<String, String> assignments, RbelElement currentElement) {
        if (assignments == null || assignments.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : assignments.entrySet()) {
            currentElement.findElement(entry.getValue()).map(RbelElement::getRawStringContent).map(TigerGlobalConfiguration::resolvePlaceholders).or(() -> TigerJexlExecutor.evaluateJexlExpression((String)((String)entry.getValue()), (TigerJexlContext)new TigerJexlContext().withRootElement((Object)currentElement)).map(Object::toString)).ifPresent(value -> TigerGlobalConfiguration.putValue((String)TigerGlobalConfiguration.resolvePlaceholders((String)((String)entry.getKey())), (String)value));
        }
    }

    private Optional<TigerMockResponse> findMatchingResponse(TigerMockResponse mockResponse, RbelElement requestRbelMessage) {
        this.executeBackendRequestsBeforeDecision(mockResponse);
        if (!this.doesItMatch(mockResponse.getRequestCriterions(), requestRbelMessage)) {
            if (log.isTraceEnabled() && mockResponse.getResponse() != null) {
                log.trace("Discarding response {} {} with criterions {} for message {}", new Object[]{mockResponse.getResponse().getStatusCode(), mockResponse.getResponse().getBody(), mockResponse.getRequestCriterions(), requestRbelMessage.printTreeStructureWithoutColors()});
            }
            return Optional.empty();
        }
        if (mockResponse.getResponse() != null) {
            log.trace("Considering response {} {}", (Object)mockResponse.getResponse().getStatusCode(), (Object)mockResponse.getResponse().getBody());
            return Optional.of(mockResponse);
        }
        return Optional.ofNullable(mockResponse.getNestedResponses()).map(Map::values).stream().flatMap(Collection::stream).sorted(Comparator.comparing(TigerMockResponse::getImportance).reversed()).map(r -> this.findMatchingResponse(r, requestRbelMessage)).filter(Optional::isPresent).map(Optional::get).peek(resp -> log.trace("Considering response {} {}", (Object)resp.getResponse().getStatusCode(), (Object)resp.getResponse().getBody())).findFirst();
    }

    private boolean doesItMatch(List<String> requestCriterions, RbelElement requestRbelMessage) {
        if (requestCriterions == null) {
            return true;
        }
        return requestCriterions.stream().filter(criterion -> !TigerJexlExecutor.matchesAsJexlExpression((String)TigerGlobalConfiguration.resolvePlaceholders((String)criterion), (TigerJexlContext)new TigerJexlContext().withCurrentElement((Object)requestRbelMessage).withRootElement((Object)requestRbelMessage))).findAny().isEmpty();
    }

    private void executeBackendRequestsBeforeDecision(TigerMockResponse mockResponse) {
        if (mockResponse.getBackendRequests() == null) {
            return;
        }
        for (ZionBackendRequestDescription requestDescription : mockResponse.getBackendRequests().values()) {
            HttpResponse unirestResponse;
            String method = ZionRequestExecutor.getMethod((ZionBackendRequestDescription)requestDescription);
            HttpRequestWithBody unirestRequest = Unirest.request((String)method, (String)TigerGlobalConfiguration.resolvePlaceholders((String)requestDescription.getUrl()));
            if (requestDescription.getHeaders() != null) {
                requestDescription.getHeaders().forEach((arg_0, arg_1) -> ((HttpRequestWithBody)unirestRequest).header(arg_0, arg_1));
            }
            if (StringUtils.isNotEmpty((CharSequence)requestDescription.getBody())) {
                byte[] body = this.getBody(requestDescription);
                if (log.isTraceEnabled()) {
                    log.trace("About to sent {} with body {} to {}", new Object[]{unirestRequest.getHttpMethod().name(), new String(body), unirestRequest.getUrl()});
                }
                unirestResponse = unirestRequest.body(body).asBytes();
            } else {
                if (log.isTraceEnabled()) {
                    log.trace("About to sent {} without body to {}", (Object)unirestRequest.getHttpMethod().name(), (Object)unirestRequest.getUrl());
                }
                unirestResponse = unirestRequest.asBytes();
            }
            RbelElement rbelResponse = this.rbelLogger.getRbelConverter().convertElement(this.responseToRawMessage(unirestResponse), null);
            this.doAssignments(requestDescription.getAssignments(), rbelResponse);
        }
    }

    private byte[] getBody(ZionBackendRequestDescription requestDescription) {
        String rawContent = TigerGlobalConfiguration.resolvePlaceholders((String)requestDescription.getBody());
        RbelElement input = this.rbelLogger.getRbelConverter().convertElement(rawContent, null);
        return this.rbelWriter.serialize(input, new TigerJexlContext().withRootElement((Object)this.requestRbelMessage));
    }

    private static String getMethod(ZionBackendRequestDescription requestDescription) {
        if (StringUtils.isEmpty((CharSequence)requestDescription.getMethod())) {
            if (StringUtils.isEmpty((CharSequence)requestDescription.getBody())) {
                return "GET";
            }
            return "POST";
        }
        return TigerGlobalConfiguration.resolvePlaceholders((String)requestDescription.getMethod());
    }

    private byte[] responseToRawMessage(HttpResponse<byte[]> response) {
        byte[] httpResponseHeader = ("HTTP/1.1 " + response.getStatus() + " " + (response.getStatusText() != null ? response.getStatusText() : "") + "\r\n" + this.formatHeaderList(response.getHeaders()) + "\r\n\r\n").getBytes(StandardCharsets.US_ASCII);
        return ArrayUtils.addAll((byte[])httpResponseHeader, (byte[])((byte[])response.getBody()));
    }

    private String formatHeaderList(Headers headerList) {
        return headerList.all().stream().map(h -> h.getName() + ": " + h.getValue()).collect(Collectors.joining("\r\n"));
    }

    private Optional<ResponseEntity<byte[]>> spyWithRemoteServer(RequestEntity<byte[]> request) {
        if (this.configuration.getSpy() == null) {
            return Optional.empty();
        }
        URI targetUri = new URIBuilder(this.configuration.getSpy().getUrl()).setPath(request.getUrl().getPath()).setQuery(request.getUrl().getQuery()).build();
        String name = Optional.ofNullable(request.getMethod()).map(HttpMethod::name).orElse("");
        HttpRequestWithBody unirestRequest = (HttpRequestWithBody)Unirest.request((String)name, (String)targetUri.toString()).headers(request.getHeaders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, header -> ((List)header.getValue()).stream().collect(Collectors.joining(",")))));
        if (request.hasBody()) {
            unirestRequest.body((byte[])request.getBody());
        }
        HttpResponse unirestResponse = unirestRequest.asBytes();
        ResponseEntity responseEntity = this.parseResponseWithRbelLogger(ResponseEntity.status((int)unirestResponse.getStatus()).body((Object)((byte[])unirestResponse.getBody())));
        RbelElement responseRbelMessage = (RbelElement)this.rbelLogger.getMessageHistory().getLast();
        TigerMockResponse mockResponse = TigerMockResponse.builder().requestCriterions(List.of("message.method == '" + name + "'", "message.url =$ '" + this.getUriEnding(targetUri) + "'")).response(TigerMockResponseDescription.builder().body((String)responseRbelMessage.getFirst("body").map(bodyElement -> this.rbelWriter.serializeWithEnforcedContentType(bodyElement, RbelContentType.JSON, new TigerJexlContext())).map(String::new).orElse(null)).build()).build();
        FileUtils.writeStringToFile((File)Path.of(this.configuration.getSpy().getProtocolToPath(), "spy_" + UUID.randomUUID() + ".yaml").toFile(), (String)this.objectMapper.writeValueAsString((Object)mockResponse), (Charset)Charset.defaultCharset());
        return Optional.of(responseEntity);
    }

    private String getUriEnding(URI targetUri) {
        if (StringUtils.isEmpty((CharSequence)targetUri.getQuery())) {
            return targetUri.getPath();
        }
        return targetUri.getPath() + "?" + targetUri.getQuery();
    }

    private ResponseEntity<byte[]> parseResponseWithRbelLogger(ResponseEntity<byte[]> el) {
        this.rbelLogger.getRbelConverter().parseMessage(this.buildRawMessageApproximate(el), this.serverHostname, this.clientHostname, Optional.of(ZonedDateTime.now()));
        return el;
    }

    private byte[] buildRawMessageApproximate(ResponseEntity<byte[]> response) {
        String header = "HTTP/1.1 " + response.getStatusCode().value();
        if (!response.getHeaders().isEmpty()) {
            header = header + "\r\n" + response.getHeaders().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(v -> (String)entry.getKey() + ": " + v)).collect(Collectors.joining("\r\n"));
        }
        header = header + "\r\n\r\n";
        if (response.hasBody()) {
            return ArrayUtils.addAll((byte[])header.getBytes(), (byte[])((byte[])response.getBody()));
        }
        return header.getBytes();
    }

    private byte[] renderResponseBody(TigerMockResponse response) {
        Optional<String> bodyBlueprint = Optional.ofNullable(response.getResponse().getBody()).filter(Objects::nonNull).or(() -> Optional.ofNullable(response.getResponse().getBodyFile()).map(x$0 -> Path.of(x$0, new String[0])).map(p -> {
            try {
                return Files.readString(p);
            }
            catch (IOException e) {
                return null;
            }
        }).filter(Objects::nonNull));
        if (bodyBlueprint.isEmpty()) {
            return null;
        }
        return this.rbelWriter.serialize(this.rbelLogger.getRbelConverter().convertElement(bodyBlueprint.get(), null), new TigerJexlContext().withRootElement((Object)this.requestRbelMessage));
    }

    @ConstructorProperties(value={"requestRbelMessage", "localServerPort", "clientHostname", "serverHostname", "objectMapper", "rbelLogger", "configuration", "request", "rbelWriter", "tigerScopedExecutor"})
    @Generated
    ZionRequestExecutor(@NonNull RbelElement requestRbelMessage, @NonNull int localServerPort, @NonNull RbelHostname clientHostname, @NonNull RbelHostname serverHostname, @NonNull ObjectMapper objectMapper, @NonNull RbelLogger rbelLogger, @NonNull ZionConfiguration configuration, @NonNull RequestEntity<byte[]> request, @NonNull RbelWriter rbelWriter, TigerScopedExecutor tigerScopedExecutor) {
        if (requestRbelMessage == null) {
            throw new NullPointerException("requestRbelMessage is marked non-null but is null");
        }
        if (clientHostname == null) {
            throw new NullPointerException("clientHostname is marked non-null but is null");
        }
        if (serverHostname == null) {
            throw new NullPointerException("serverHostname is marked non-null but is null");
        }
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (rbelLogger == null) {
            throw new NullPointerException("rbelLogger is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (rbelWriter == null) {
            throw new NullPointerException("rbelWriter is marked non-null but is null");
        }
        this.requestRbelMessage = requestRbelMessage;
        this.localServerPort = localServerPort;
        this.clientHostname = clientHostname;
        this.serverHostname = serverHostname;
        this.objectMapper = objectMapper;
        this.rbelLogger = rbelLogger;
        this.configuration = configuration;
        this.request = request;
        this.rbelWriter = rbelWriter;
        this.tigerScopedExecutor = tigerScopedExecutor;
    }

    @Generated
    public static ZionRequestExecutorBuilder builder() {
        return new ZionRequestExecutorBuilder();
    }
}

