/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.zion.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.writer.RbelContentType;
import de.gematik.rbellogger.writer.RbelWriter;
import de.gematik.test.tiger.common.jexl.TigerJexlExecutor;
import de.gematik.test.tiger.zion.config.TigerMockResponse;
import de.gematik.test.tiger.zion.config.TigerMockResponseDescription;
import de.gematik.test.tiger.zion.config.ZionConfiguration;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

@RestController
@RequestMapping(value={"/"})
public class CatchAllController
implements WebMvcConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CatchAllController.class);
    private final RbelLogger rbelLogger;
    private final RbelWriter rbelWriter;
    private final ZionConfiguration configuration;
    private final ObjectMapper objectMapper;

    @PostConstruct
    public void loadMockReponsesFromFile() {
        for (Map.Entry<String, String> entry : this.configuration.getMockResponseFiles().entrySet()) {
            try (FileInputStream fileInputStream = new FileInputStream(Path.of(entry.getValue(), new String[0]).toFile());){
                TigerMockResponse mockResponse = (TigerMockResponse)new Yaml((BaseConstructor)new Constructor(TigerMockResponse.class)).load((InputStream)fileInputStream);
                this.configuration.getMockResponses().put(entry.getKey(), mockResponse);
            }
        }
    }

    @RequestMapping(value={"**"}, consumes={"*/*", "application/*"}, produces={"*/*"}, method={RequestMethod.GET, RequestMethod.POST, RequestMethod.HEAD, RequestMethod.OPTIONS, RequestMethod.PUT, RequestMethod.PATCH, RequestMethod.DELETE, RequestMethod.TRACE})
    public ResponseEntity<byte[]> getAnythingelse(RequestEntity<byte[]> request, HttpServletRequest servletRequest) {
        log.info("Got new request {} {}", (Object)request.getMethod(), (Object)request.getUrl());
        byte[] rawMessage = this.buildRawMessageApproximate(request);
        RbelHostname client = RbelHostname.builder().hostname(servletRequest.getRemoteHost()).port(servletRequest.getRemotePort()).build();
        RbelHostname server = RbelHostname.builder().hostname(servletRequest.getLocalAddr()).port(servletRequest.getLocalPort()).build();
        RbelElement requestRbelMessage = this.rbelLogger.getRbelConverter().parseMessage(rawMessage, client, server, Optional.of(ZonedDateTime.now()));
        TigerJexlExecutor.ELEMENT_STACK.push(requestRbelMessage);
        ResponseEntity responseEntity = this.configuration.getMockResponses().values().stream().filter(entry -> this.doesItMatch(entry.getRequestCriterions(), requestRbelMessage)).findAny().map(this::renderResponse).map(el -> this.parseResponseWithRbelLogger(client, server, (ResponseEntity<byte[]>)el)).or(() -> this.spyWithRemoteServer(request, client, server)).orElseThrow(() -> {
            log.warn("Could not match request \n{}", (Object)requestRbelMessage.printTreeStructure());
            return new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, "No suitable return value found");
        });
        TigerJexlExecutor.ELEMENT_STACK.removeFirstOccurrence(requestRbelMessage);
        return responseEntity;
    }

    private Optional<ResponseEntity<byte[]>> spyWithRemoteServer(RequestEntity<byte[]> request, RbelHostname client, RbelHostname server) {
        if (this.configuration.getSpy() == null) {
            return Optional.empty();
        }
        URI targetUri = new URIBuilder(this.configuration.getSpy().getUrl()).setPath(request.getUrl().getPath()).setQuery(request.getUrl().getQuery()).build();
        String name = Optional.ofNullable(request.getMethod()).map(Enum::name).orElse("");
        HttpRequestWithBody unirestRequest = (HttpRequestWithBody)Unirest.request((String)name, (String)targetUri.toString()).headers(request.getHeaders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, header -> ((List)header.getValue()).stream().collect(Collectors.joining(",")))));
        if (request.hasBody()) {
            unirestRequest.body((byte[])request.getBody());
        }
        HttpResponse unirestResponse = unirestRequest.asBytes();
        ResponseEntity<byte[]> responseEntity = this.parseResponseWithRbelLogger(client, server, (ResponseEntity<byte[]>)ResponseEntity.status((int)unirestResponse.getStatus()).body((Object)((byte[])unirestResponse.getBody())));
        RbelElement responseRbelMessage = (RbelElement)this.rbelLogger.getMessageHistory().getLast();
        TigerMockResponse mockResponse = TigerMockResponse.builder().requestCriterions(List.of("message.method == '" + name + "'", "message.url =$ '" + this.getUriEnding(targetUri) + "'")).response(TigerMockResponseDescription.builder().body(responseRbelMessage.getFirst("body").map(bodyElement -> this.rbelWriter.serializeWithEnforcedContentType(bodyElement, RbelContentType.JSON)).map(String::new).orElse(null)).build()).build();
        FileUtils.writeStringToFile((File)Path.of(this.configuration.getSpy().getProtocolToPath(), "spy_" + UUID.randomUUID() + ".yaml").toFile(), (String)this.objectMapper.writeValueAsString((Object)mockResponse));
        return Optional.of(responseEntity);
    }

    private String getUriEnding(URI targetUri) {
        if (StringUtils.isEmpty((CharSequence)targetUri.getQuery())) {
            return targetUri.getPath();
        }
        return targetUri.getPath() + "?" + targetUri.getQuery();
    }

    private ResponseEntity<byte[]> parseResponseWithRbelLogger(RbelHostname client, RbelHostname server, ResponseEntity<byte[]> el) {
        try {
            this.rbelLogger.getRbelConverter().parseMessage(this.buildRawMessageApproximate(el), server, client, Optional.of(ZonedDateTime.now()));
            RbelHtmlRenderer rbelRenderer = new RbelHtmlRenderer();
            FileUtils.writeStringToFile((File)new File("target/traffic.html"), (String)rbelRenderer.doRender((Collection)this.rbelLogger.getMessageList()));
            return el;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ResponseEntity<byte[]> renderResponse(TigerMockResponse response) {
        ResponseEntity.BodyBuilder responseBuilder = ResponseEntity.status((int)response.getResponse().getStatusCode());
        response.getResponse().getHeaders().forEach((key, value) -> responseBuilder.header(key, new String[]{new String(this.rbelWriter.serialize(this.rbelLogger.getRbelConverter().convertElement(value, null)))}));
        return responseBuilder.body((Object)this.renderResponseBody(response));
    }

    private byte[] renderResponseBody(TigerMockResponse response) {
        Optional<String> bodyBlueprint = Optional.ofNullable(response.getResponse().getBody()).filter(Objects::nonNull).or(() -> Optional.ofNullable(response.getResponse().getBodyFile()).map(x$0 -> Path.of(x$0, new String[0])).map(p -> {
            try {
                return Files.readString(p);
            }
            catch (IOException e) {
                return null;
            }
        }).filter(Objects::nonNull));
        if (bodyBlueprint.isEmpty()) {
            return null;
        }
        byte[] renderedBody = this.rbelWriter.serialize(this.rbelLogger.getRbelConverter().convertElement(bodyBlueprint.get(), null));
        log.info("Returning {}", (Object)new String(renderedBody));
        return renderedBody;
    }

    private boolean doesItMatch(List<String> requestCriterions, RbelElement requestRbelMessage) {
        return requestCriterions.stream().filter(criterion -> !TigerJexlExecutor.INSTANCE.matchesAsJexlExpression((Object)requestRbelMessage, criterion)).findAny().isEmpty();
    }

    private byte[] buildRawMessageApproximate(RequestEntity<byte[]> request) {
        String header = request.getMethod() + " " + request.getUrl() + " HTTP/1.1\r\n" + request.getHeaders().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(v -> (String)entry.getKey() + ": " + v)).collect(Collectors.joining("\r\n")) + "\r\n\r\n";
        if (request.hasBody()) {
            return ArrayUtils.addAll((byte[])header.getBytes(), (byte[])((byte[])request.getBody()));
        }
        return header.getBytes();
    }

    private byte[] buildRawMessageApproximate(ResponseEntity<byte[]> response) {
        String header = "HTTP/1.1 " + response.getStatusCodeValue();
        if (!response.getHeaders().isEmpty()) {
            header = header + "\r\n" + response.getHeaders().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(v -> (String)entry.getKey() + ": " + v)).collect(Collectors.joining("\r\n"));
        }
        header = header + "\r\n\r\n";
        if (response.hasBody()) {
            return ArrayUtils.addAll((byte[])header.getBytes(), (byte[])((byte[])response.getBody()));
        }
        return header.getBytes();
    }

    @ConstructorProperties(value={"rbelLogger", "rbelWriter", "configuration", "objectMapper"})
    @Generated
    public CatchAllController(RbelLogger rbelLogger, RbelWriter rbelWriter, ZionConfiguration configuration, ObjectMapper objectMapper) {
        this.rbelLogger = rbelLogger;
        this.rbelWriter = rbelWriter;
        this.configuration = configuration;
        this.objectMapper = objectMapper;
    }
}

