/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.env.TigerServerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.servers.AbstractExternalTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.ExternalUrlServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerStatus;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@TigerServerType(value="externalUrl")
public class ExternalUrlServer
extends AbstractExternalTigerServer {
    public ExternalUrlServer(TigerTestEnvMgr tigerTestEnvMgr, String serverId, CfgServer configuration) {
        super(ExternalUrlServer.determineHostname((CfgServer)configuration, (String)serverId), serverId, configuration, tigerTestEnvMgr);
        if (StringUtils.isEmpty((CharSequence)this.getConfiguration().getHealthcheckUrl())) {
            this.getConfiguration().setHealthcheckUrl((String)this.getConfiguration().getSource().get(0));
        }
    }

    public void assertThatConfigurationIsCorrect() {
        if (StringUtils.isEmpty((CharSequence)this.getConfiguration().getHealthcheckUrl())) {
            this.getConfiguration().setHealthcheckUrl((String)this.getConfiguration().getSource().get(0));
        }
        super.assertThatConfigurationIsCorrect();
        this.assertCfgPropertySet((Object)this.getConfiguration(), new String[]{"source"});
    }

    public void performStartup() {
        this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().type("externalUrl").statusMessage("Starting external URL instance " + this.getServerId() + "...").build());
        URL url = this.buildUrl();
        this.addServerToLocalProxyRouteMap(url);
        this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().baseUrl(this.extractBaseUrl(url)).build());
        this.waitForServerUp();
    }

    public void shutdown() {
        this.log.info("Stopping external url {}...", (Object)this.getServerId());
        this.setStatus(TigerServerStatus.STOPPED, "Disconnected external url " + this.getServerId());
    }

    public Optional<String> getHealthcheckUrl() {
        if (StringUtils.isEmpty((CharSequence)this.getConfiguration().getHealthcheckUrl())) {
            return Optional.of((String)this.getConfiguration().getSource().get(0));
        }
        return Optional.ofNullable(this.getConfiguration().getHealthcheckUrl());
    }

    private URL buildUrl() {
        try {
            return new URL(this.getTigerTestEnvMgr().replaceSysPropsInString((String)this.getConfiguration().getSource().get(0)));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not parse source URL '" + (String)this.getConfiguration().getSource().get(0) + "'!", e);
        }
    }

    @Generated
    public static ExternalUrlServerBuilder builder() {
        return new ExternalUrlServerBuilder();
    }
}

