/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.servers.AbstractTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerProxyServer;
import de.gematik.test.tiger.testenvmgr.servers.log.CustomerAppender;
import de.gematik.test.tiger.testenvmgr.servers.log.CustomerLocalProxyAppender;
import de.gematik.test.tiger.testenvmgr.servers.log.CustomerProxyServerAppender;
import java.io.File;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerServerLogManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerServerLogManager.class);
    private static final String DEFAULT_LOGFILE_LOCATION = "./target/serverLogs/";
    private static final String LOGFILE_EXTENSION = ".log";
    private static final String DEFAULT_PATTERN_LAYOUT = "%date %level [%thread] %logger{10} [%file:%line] %msg%n";

    public static void addAppenders(AbstractTigerServer server) {
        TigerServerLogManager.createAndAddAppenders(server, (ch.qos.logback.classic.Logger)server.getLog());
    }

    public static void setLoggingLevel(String loggerName, String levelString) {
        log.debug("Changing loglevel for '{}' to ({})", (Object)loggerName, (Object)levelString);
        ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)loggerName);
        logger.setLevel(Level.toLevel((String)levelString.toUpperCase(), (Level)Level.INFO));
    }

    private static void createAndAddAppenders(AbstractTigerServer server, ch.qos.logback.classic.Logger log) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        PatternLayoutEncoder patternLayoutEncoder = new PatternLayoutEncoder();
        patternLayoutEncoder.setPattern(DEFAULT_PATTERN_LAYOUT);
        patternLayoutEncoder.setContext((Context)loggerContext);
        patternLayoutEncoder.start();
        if (server.getConfiguration().getExternalJarOptions() == null || server.getConfiguration().getExternalJarOptions().isActivateLogs()) {
            log.addAppender(TigerServerLogManager.createFileAppender(server.getServerId(), server.getConfiguration().getLogFile(), loggerContext, patternLayoutEncoder));
            log.addAppender(TigerServerLogManager.createConsoleAppender(loggerContext, patternLayoutEncoder));
            log.addAppender((Appender)TigerServerLogManager.createCustomerAppender(server, loggerContext));
        }
        log.setAdditive(false);
    }

    private static FileAppender<ILoggingEvent> createFileAppender(String serverId, String logFilePath, LoggerContext loggerContext, PatternLayoutEncoder patternLayoutEncoder) {
        String fileName = TigerServerLogManager.createFileName(serverId, logFilePath);
        FileAppender fileAppender = new FileAppender();
        fileAppender.setFile(fileName);
        fileAppender.setAppend(false);
        fileAppender.setEncoder((Encoder)patternLayoutEncoder);
        fileAppender.setContext((Context)loggerContext);
        fileAppender.start();
        return fileAppender;
    }

    private static ConsoleAppender<ILoggingEvent> createConsoleAppender(LoggerContext loggerContext, PatternLayoutEncoder patternLayoutEncoder) {
        ConsoleAppender consoleAppender = new ConsoleAppender();
        consoleAppender.setEncoder((Encoder)patternLayoutEncoder);
        consoleAppender.setContext((Context)loggerContext);
        consoleAppender.start();
        return consoleAppender;
    }

    private static String createFileName(String serverId, String logFilePath) {
        if (logFilePath != null) {
            File file = new File(logFilePath);
            if (file.isDirectory()) {
                return file.getAbsolutePath() + serverId + LOGFILE_EXTENSION;
            }
            return file.getAbsolutePath();
        }
        return DEFAULT_LOGFILE_LOCATION + serverId + LOGFILE_EXTENSION;
    }

    private static CustomerAppender createCustomerAppender(AbstractTigerServer server, LoggerContext loggerContext) {
        CustomerAppender customerAppender = new CustomerAppender(server);
        customerAppender.setContext((Context)loggerContext);
        customerAppender.start();
        return customerAppender;
    }

    public static void addProxyCustomerAppender(TigerProxyServer tigerProxyServer) {
        ch.qos.logback.classic.Logger logbackLogger = (ch.qos.logback.classic.Logger)tigerProxyServer.getTigerProxy().getLog();
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        CustomerProxyServerAppender customerAppender = new CustomerProxyServerAppender(tigerProxyServer);
        customerAppender.setContext((Context)loggerContext);
        customerAppender.start();
        logbackLogger.addAppender((Appender)customerAppender);
    }

    public static void addProxyCustomerAppender(TigerTestEnvMgr tigerTestEnvMgr, Logger log) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        CustomerLocalProxyAppender customerAppender = new CustomerLocalProxyAppender(tigerTestEnvMgr);
        customerAppender.setContext((Context)loggerContext);
        customerAppender.start();
        ((ch.qos.logback.classic.Logger)log).addAppender((Appender)customerAppender);
    }

    @Generated
    private TigerServerLogManager() {
    }
}

