/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.test.tiger.common.Ansi;
import de.gematik.test.tiger.common.config.TigerConfigurationKeys;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerProxyConfiguration;
import de.gematik.test.tiger.mockserver.proxyconfiguration.ProxyConfiguration;
import de.gematik.test.tiger.proxy.AbstractTigerProxy;
import de.gematik.test.tiger.proxy.configuration.ProxyConfigurationConverter;
import de.gematik.test.tiger.proxy.handler.TigerExceptionUtils;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.servers.AbstractTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerStatus;
import de.gematik.test.tiger.testenvmgr.util.InsecureTrustAllManager;
import de.gematik.test.tiger.testenvmgr.util.TigerEnvironmentStartupException;
import de.gematik.test.tiger.testenvmgr.util.TigerTestEnvException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.bouncycastle.tls.TlsException;

public abstract class AbstractExternalTigerServer
extends AbstractTigerServer {
    public static final String SERVER = "Server ";
    protected final AtomicReference<Throwable> startupException = new AtomicReference();

    protected AbstractExternalTigerServer(String hostname, String serverId, CfgServer configuration, TigerTestEnvMgr tigerTestEnvMgr) {
        super(hostname, serverId, tigerTestEnvMgr, configuration);
    }

    protected void waitForServerUp() {
        if (this.getStatus() == TigerServerStatus.NEW) {
            this.setStatus(TigerServerStatus.STARTING);
        }
        this.waitForServiceToBeUpForHalfOfTheConnectionTimeout(true);
        TigerTestEnvException exceptionAtStartup = new TigerTestEnvException(this.startupException.get(), "Unable to start %s '%s' (Status %s)!", this.getConfiguration().getType(), this.getServerId(), this.getStatus().toString());
        if (this.startupException.get() != null) {
            throw exceptionAtStartup;
        }
        if (this.getStatus() == TigerServerStatus.STOPPED) {
            throw new TigerTestEnvException("%s Server %s stopped unexpectedly!", this.getConfiguration().getType(), this.getServerId());
        }
        if (this.getStatus() == TigerServerStatus.STARTING) {
            this.waitForServiceToBeUpForHalfOfTheConnectionTimeout(false);
            if (this.startupException.get() != null) {
                throw exceptionAtStartup;
            }
            if (this.getStatus() != TigerServerStatus.RUNNING) {
                throw new TigerTestEnvException("%s Server %s still not running (Status %s)!", this.getConfiguration().getType(), this.getServerId(), this.getStatus().toString());
            }
        }
        this.statusMessage(this.getConfiguration().getType() + " " + this.getServerId() + " started");
    }

    protected void waitForServiceToBeUpForHalfOfTheConnectionTimeout(boolean quiet) {
        block5: {
            long timeOutInMs = (long)this.getStartupTimeoutSec().orElse(20).intValue() * 1000L / 2L;
            if (this.isHealthCheckNone()) {
                this.waitForConfiguredTimeAndSetRunning(timeOutInMs);
            } else {
                if (!quiet) {
                    this.log.info("  Checking {} instance '{}' is available ...", (Object)this.getClass().getSimpleName(), (Object)this.getServerId());
                }
                try {
                    Awaitility.await().atMost(Math.max(timeOutInMs, 1000L), TimeUnit.MILLISECONDS).pollInterval(200L, TimeUnit.MILLISECONDS).until(() -> this.updateStatus(quiet) != TigerServerStatus.STARTING && this.getStatus() != TigerServerStatus.NEW);
                }
                catch (ConditionTimeoutException cte) {
                    if (quiet) break block5;
                    throw new TigerTestEnvException("Timeout waiting for external server '" + this.getServerId() + "' to respond at '" + this.getHealthcheckUrl().orElse("<null>") + "'!");
                }
            }
        }
    }

    public TigerServerStatus updateStatus(boolean noErrorLogging) {
        block7: {
            URL url = this.buildHealthcheckUrl();
            if (!noErrorLogging) {
                this.statusMessage("Waiting for URL '" + url + "' to be healthy...");
            }
            try {
                this.checkUrlOrThrowException(url);
                this.printServerUpMessage();
                this.setStatus(TigerServerStatus.RUNNING, SERVER + this.getServerId() + " up & healthy");
            }
            catch (ConnectException | SocketTimeoutException cex) {
                if (!noErrorLogging) {
                    this.handleNoTcpConnectionException(url);
                }
            }
            catch (SSLHandshakeException | TlsException sslhe) {
                this.handleSslHandshakeErrorAndSetServerRunning((IOException)sslhe);
            }
            catch (SSLException sslex) {
                this.handleOtherSslError(noErrorLogging, sslex);
            }
            catch (Exception e) {
                if (noErrorLogging) break block7;
                this.handleOtherException(e);
            }
        }
        return this.getStatus();
    }

    private void handleNoTcpConnectionException(URL url) {
        this.log.info("No connection to {} of {}...", (Object)url, (Object)this.getServerId());
    }

    private void handleOtherException(Exception e) {
        this.log.error("Failed to connect - " + e.getMessage(), (Throwable)e);
    }

    private void handleOtherSslError(boolean noErrorLogging, SSLException sslex) {
        if (sslex.getMessage().equals("Unsupported or unrecognized SSL message")) {
            if (!noErrorLogging) {
                this.log.error("Unsupported or unrecognized SSL message - MAYBE you mismatched http/httpS?");
            }
        } else if (!noErrorLogging) {
            this.log.error("SSL Error - " + sslex.getMessage(), (Throwable)sslex);
        }
    }

    private void handleSslHandshakeErrorAndSetServerRunning(IOException sslhe) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(Ansi.colorize((String)"SSL handshake but server at least seems to be up! {}", (RbelAnsiColors)RbelAnsiColors.YELLOW_BOLD), (Object)sslhe.getMessage());
        }
        this.setStatus(TigerServerStatus.RUNNING, SERVER + this.getServerId() + " up & healthy");
    }

    private void checkUrlOrThrowException(URL url) throws IOException {
        block4: {
            URLConnection con = this.getUrlConnectionToServer(url);
            if (con instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)con;
                InsecureTrustAllManager.allowAllSsl(con);
                con.setConnectTimeout((Integer)TigerConfigurationKeys.EXTERNAL_SERVER_CONNECTION_TIMEOUT.getValueOrDefault());
                con.connect();
                try {
                    int responseCode = httpConnection.getResponseCode();
                    if (this.getConfiguration().getHealthcheckReturnCode() != null && !this.getConfiguration().getHealthcheckReturnCode().equals(responseCode)) {
                        throw new TigerEnvironmentStartupException("Return code for server '%s' does not match: %nExpected %d but got %d", this.getServerId(), this.getConfiguration().getHealthcheckReturnCode(), responseCode);
                    }
                }
                catch (SocketException e) {
                    if (e.getClass() == SocketException.class && this.getConfiguration().getHealthcheckReturnCode() == null && !TigerExceptionUtils.getCauseWithMessageMatching((Throwable)e, message -> "Connection reset".equals(message) || "Unexpected end of file from server".equals(message)).isEmpty()) break block4;
                    throw e;
                }
            }
        }
    }

    private URLConnection getUrlConnectionToServer(URL url) throws IOException {
        Optional<ProxyConfiguration> forwardProxyInfo = this.createProxyConfiguration();
        if (forwardProxyInfo.isPresent() && !url.getHost().matches("((127\\.0\\.0\\.1)|(localhost))")) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(forwardProxyInfo.get().getProxyAddress().getHostName(), forwardProxyInfo.get().getProxyAddress().getPort()));
            return url.openConnection(proxy);
        }
        return url.openConnection();
    }

    private Optional<ProxyConfiguration> createProxyConfiguration() {
        return this.getTigerTestEnvMgr().getLocalTigerProxyOptional().map(AbstractTigerProxy::getTigerProxyConfiguration).map(TigerProxyConfiguration::getForwardToProxy).flatMap(ProxyConfigurationConverter::createMockServerProxyConfiguration).filter(pc -> pc.getProxyAddress() != null).filter(pc -> StringUtils.isNotEmpty((CharSequence)pc.getProxyAddress().getHostName()));
    }

    void printServerUpMessage() {
        String message = "External server Startup OK for '" + this.getServerId() + "'";
        if (this.getConfiguration().getSource() != null && !this.getConfiguration().getSource().isEmpty()) {
            message = message + " downloaded from '" + (String)this.getConfiguration().getSource().get(0) + "'";
        }
        if (this.log.isInfoEnabled()) {
            this.log.info(Ansi.colorize((String)message, (RbelAnsiColors)RbelAnsiColors.GREEN_BOLD));
        }
    }

    private void waitForConfiguredTimeAndSetRunning(long timeOutInMs) {
        this.log.warn("No health check URL configured! Resorting to simple wait with timeout {}s", (Object)(timeOutInMs / 1000L));
        this.log.info("Waiting {}s for external server {}...", (Object)(timeOutInMs / 1000L), (Object)this.getServerId());
        try {
            Thread.sleep(timeOutInMs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.setStatus(TigerServerStatus.RUNNING, SERVER + this.getServerId() + " up & healthy (default timeout)");
    }

    URL buildHealthcheckUrl() {
        try {
            return new URL(this.getHealthcheckUrl().orElseThrow(() -> new TigerTestEnvException("No Healthcheck Url is set for server " + this.getServerId())));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not build healthcheck URL from '" + this.getHealthcheckUrl() + "'!", e);
        }
    }

    public Optional<String> getHealthcheckUrl() {
        return Optional.ofNullable(this.getConfiguration().getHealthcheckUrl());
    }

    @Override
    public String getDestinationUrl(String fallbackProtocol) {
        try {
            URIBuilder uriBuilder = new URIBuilder(this.getHealthcheckUrl().orElseThrow(() -> new TigerTestEnvException("No Healthcheck Url is set for server " + this.getServerId()))).setPath("");
            if (StringUtils.isNotEmpty((CharSequence)fallbackProtocol)) {
                uriBuilder.setScheme(fallbackProtocol);
            }
            return uriBuilder.build().toURL().toString();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new TigerEnvironmentStartupException("Unable to build destination URL", e);
        }
    }

    boolean isHealthCheckNone() {
        return this.getHealthcheckUrl().filter(StringUtils::isNotEmpty).filter(s -> !s.equals("NONE")).isEmpty();
    }

    protected void applyEnvPropertiesToProcess(ProcessBuilder processBuilder) {
        processBuilder.environment().putAll(this.getEnvironmentProperties().stream().map(str -> str.split("=", 2)).filter(ar -> ((String[])ar).length == 2).collect(Collectors.toMap(ar -> ar[0].trim(), ar -> ar[1].trim())));
    }
}

