/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.env;

import de.gematik.test.tiger.testenvmgr.controller.ReplayController;
import de.gematik.test.tiger.testenvmgr.controller.ReplayableFeature;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.runtime.FeatureSupplier;
import io.cucumber.core.runtime.Runtime;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.springframework.stereotype.Component;

@Component
public class ScenarioReplayer {
    private Runtime runtime;

    public void rerunTest(ReplayController.ScenarioIdentifier scenarioLocation) {
        List features = ((FeatureSupplier)FieldUtils.readField((Object)this.runtime, (String)"featureSupplier", (boolean)true)).get();
        List<Pickle> matchingPickles = features.stream().filter(f -> f.getUri().equals(scenarioLocation.getScenarioUri())).flatMap(f -> f.getPickles().stream()).filter(p -> this.doesLocationMatch((Pickle)p, scenarioLocation)).toList();
        if (matchingPickles.isEmpty()) {
            throw new NoSuchElementException("Failed to find a Scenario matching the given identifier: " + scenarioLocation);
        }
        Pickle toReplay = scenarioLocation.isScenarioOutline() ? matchingPickles.get(scenarioLocation.getVariantIndex()) : matchingPickles.get(0);
        this.createFeatureWithSinglePickle(features, toReplay).ifPresent(this::replayFeature);
    }

    private boolean doesLocationMatch(Pickle pickle, ReplayController.ScenarioIdentifier scenarioLocation) {
        if (scenarioLocation.isScenarioOutline()) {
            return pickle.getScenarioLocation().equals((Object)scenarioLocation.getLocation());
        }
        return pickle.getLocation().equals((Object)scenarioLocation.getLocation());
    }

    private synchronized void replayFeature(Feature feature) {
        MethodUtils.invokeMethod((Object)this.runtime, (boolean)true, (String)"runFeatures", (Object[])new Object[]{List.of(feature)});
    }

    private Optional<Feature> createFeatureWithSinglePickle(List<Feature> features, Pickle pickle) {
        for (Feature feature : features) {
            Optional<Pickle> matchingPickle = feature.getPickles().stream().filter(p -> p.equals(pickle)).findAny();
            if (!matchingPickle.isPresent()) continue;
            return Optional.of(new ReplayableFeature(feature, UUID.fromString(matchingPickle.get().getId())));
        }
        return Optional.empty();
    }

    @Generated
    public ScenarioReplayer() {
    }

    @Generated
    public void setRuntime(Runtime runtime) {
        this.runtime = runtime;
    }
}

