/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.controller;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.gematik.test.tiger.testenvmgr.env.ScenarioReplayer;
import io.cucumber.plugin.event.Location;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/replay"})
public class ReplayController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReplayController.class);
    private final ScenarioReplayer scenarioReplayer;

    public ReplayController(@Autowired ScenarioReplayer scenarioReplayer) {
        this.scenarioReplayer = scenarioReplayer;
    }

    @PostMapping
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void replayScenario(@Valid @RequestBody ScenarioIdentifier scenarioIdentifier) {
        this.scenarioReplayer.rerunTest(scenarioIdentifier);
    }

    @ExceptionHandler(value={NoSuchElementException.class})
    public ResponseEntity<String> handleNotFound() {
        return ResponseEntity.notFound().build();
    }

    public static class ScenarioIdentifier {
        private final URI scenarioUri;
        private final Location location;
        private final int variantIndex;

        @JsonCreator
        public ScenarioIdentifier(@JsonProperty(value="scenarioUri") @NotNull URI scenarioUri, @JsonProperty(value="location") @NotNull Map<String, Integer> location, @JsonProperty(value="variantIndex") @NotNull Integer variantIndex) {
            this.scenarioUri = scenarioUri;
            this.location = location == null ? null : new Location(location.get("line").intValue(), location.get("column").intValue());
            this.variantIndex = variantIndex;
        }

        public boolean isScenarioOutline() {
            return this.variantIndex >= 0;
        }

        @Generated
        public URI getScenarioUri() {
            return this.scenarioUri;
        }

        @Generated
        public Location getLocation() {
            return this.location;
        }

        @Generated
        public int getVariantIndex() {
            return this.variantIndex;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScenarioIdentifier)) {
                return false;
            }
            ScenarioIdentifier other = (ScenarioIdentifier)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getVariantIndex() != other.getVariantIndex()) {
                return false;
            }
            URI this$scenarioUri = this.getScenarioUri();
            URI other$scenarioUri = other.getScenarioUri();
            if (this$scenarioUri == null ? other$scenarioUri != null : !((Object)this$scenarioUri).equals(other$scenarioUri)) {
                return false;
            }
            Location this$location = this.getLocation();
            Location other$location = other.getLocation();
            return !(this$location == null ? other$location != null : !this$location.equals(other$location));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ScenarioIdentifier;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getVariantIndex();
            URI $scenarioUri = this.getScenarioUri();
            result = result * 59 + ($scenarioUri == null ? 43 : ((Object)$scenarioUri).hashCode());
            Location $location = this.getLocation();
            result = result * 59 + ($location == null ? 43 : $location.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ReplayController.ScenarioIdentifier(scenarioUri=" + this.getScenarioUri() + ", location=" + this.getLocation() + ", variantIndex=" + this.getVariantIndex() + ")";
        }
    }
}

