/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.env.TigerServerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.servers.AbstractExternalTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.HttpBinServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerType;
import java.net.URI;
import org.gaul.httpbin.HttpBin;

@TigerServerType(value="httpbin")
public class HttpBinServer
extends AbstractExternalTigerServer {
    private HttpBin httpbin;

    public HttpBinServer(TigerTestEnvMgr tigerTestEnvMgr, String serverId, CfgServer configuration) {
        super(serverId, serverId, configuration, tigerTestEnvMgr);
    }

    public void performStartup() {
        this.log.info("Pre-startup of HttpBin server {}", (Object)this.getServerId());
        this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().statusMessage("Pre-start HttpBin-Server " + this.getServerId()).build());
        if (this.getTigerTestEnvMgr().isShuttingDown()) {
            this.log.debug("Skipping startup, already shutting down...");
            this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().statusMessage("Skipped startup of HttpBin-Server " + this.getServerId()).build());
            return;
        }
        this.log.info("Actually performing startup of HttpBin-Server {}", (Object)this.getServerId());
        URI httpBinEndpoint = new URI("http://localhost:" + this.getServerport());
        this.httpbin = new HttpBin(httpBinEndpoint);
        this.httpbin.start();
        this.waitForServerUp();
        this.addServerToLocalProxyRouteMap(httpBinEndpoint.toURL());
    }

    private HttpBinConfiguration getHttbBinConfiguration() {
        CfgServer configuration = this.getConfiguration();
        if (configuration instanceof HttpBinConfiguration) {
            HttpBinConfiguration httpBinConfiguration = (HttpBinConfiguration)configuration;
            return httpBinConfiguration;
        }
        throw new TigerConfigurationException("Unexpected configuration type. Expected %s but found %s".formatted(HttpBinConfiguration.class.getName(), configuration.getClass().getName()));
    }

    private int getServerport() {
        return this.getHttbBinConfiguration().getServerPort();
    }

    public void shutdown() {
        this.log.info("Stopping HttpBin-Server {}...", (Object)this.getServerId());
        if (this.httpbin != null) {
            this.httpbin.stop();
        }
    }

    public Class<? extends CfgServer> getConfigurationBeanClass() {
        return HttpBinConfiguration.class;
    }
}

