/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.env.TigerServerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.servers.AbstractExternalTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerType;
import java.net.URI;
import lombok.Generated;
import org.gaul.httpbin.HttpBin;

@TigerServerType(value="httpbin")
public class HttpBinServer
extends AbstractExternalTigerServer {
    private HttpBin httpbin;

    public HttpBinServer(TigerTestEnvMgr tigerTestEnvMgr, String serverId, CfgServer configuration) {
        super(serverId, serverId, configuration, tigerTestEnvMgr);
    }

    @Override
    public void performStartup() {
        this.log.info("Pre-startup of HttpBin server {}", (Object)this.getServerId());
        this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().statusMessage("Pre-start HttpBin-Server " + this.getServerId()).build());
        if (this.getTigerTestEnvMgr().isShuttingDown()) {
            this.log.debug("Skipping startup, already shutting down...");
            this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().statusMessage("Skipped startup of HttpBin-Server " + this.getServerId()).build());
            return;
        }
        this.log.info("Actually performing startup of HttpBin-Server {}", (Object)this.getServerId());
        URI httpBinEndpoint = new URI("http://localhost:" + this.getServerport());
        this.httpbin = new HttpBin(httpBinEndpoint);
        this.httpbin.start();
        this.waitForServerUp();
        this.addServerToLocalProxyRouteMap(httpBinEndpoint.toURL());
    }

    private HttpBinConfiguration getHttbBinConfiguration() {
        CfgServer configuration = this.getConfiguration();
        if (configuration instanceof HttpBinConfiguration) {
            HttpBinConfiguration httpBinConfiguration = (HttpBinConfiguration)configuration;
            return httpBinConfiguration;
        }
        throw new TigerConfigurationException("Unexpected configuration type. Expected %s but found %s".formatted(HttpBinConfiguration.class.getName(), configuration.getClass().getName()));
    }

    private int getServerport() {
        return this.getHttbBinConfiguration().getServerPort();
    }

    @Override
    public void shutdown() {
        this.log.info("Stopping HttpBin-Server {}...", (Object)this.getServerId());
        if (this.httpbin != null) {
            this.httpbin.stop();
        }
    }

    @Override
    public Class<? extends CfgServer> getConfigurationBeanClass() {
        return HttpBinConfiguration.class;
    }

    public static class HttpBinConfiguration
    extends CfgServer {
        private int serverPort;

        @Generated
        public HttpBinConfiguration() {
        }

        @Generated
        public int getServerPort() {
            return this.serverPort;
        }

        @Generated
        public void setServerPort(int serverPort) {
            this.serverPort = serverPort;
        }

        @Generated
        public String toString() {
            return "HttpBinServer.HttpBinConfiguration(serverPort=" + this.getServerPort() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpBinConfiguration)) {
                return false;
            }
            HttpBinConfiguration other = (HttpBinConfiguration)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            return this.getServerPort() == other.getServerPort();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof HttpBinConfiguration;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.getServerPort();
            return result;
        }
    }
}

