/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.controller;

import de.gematik.test.tiger.proxy.data.MessageMetaDataDto;
import de.gematik.test.tiger.spring_utils.TigerBuildPropertiesService;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.data.BannerType;
import de.gematik.test.tiger.testenvmgr.data.TigerEnvStatusDto;
import de.gematik.test.tiger.testenvmgr.data.TigerServerStatusDto;
import de.gematik.test.tiger.testenvmgr.env.FeatureUpdate;
import de.gematik.test.tiger.testenvmgr.env.ScenarioUpdate;
import de.gematik.test.tiger.testenvmgr.env.StepUpdate;
import de.gematik.test.tiger.testenvmgr.env.TestResult;
import de.gematik.test.tiger.testenvmgr.env.TigerServerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.env.TigerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.env.TigerUpdateListener;
import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/status"})
public class EnvStatusController
implements TigerUpdateListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnvStatusController.class);
    private final TigerEnvStatusDto tigerEnvStatus = new TigerEnvStatusDto();
    private final TigerTestEnvMgr tigerTestEnvMgr;
    private final TigerBuildPropertiesService buildProperties;

    public EnvStatusController(TigerTestEnvMgr tigerTestEnvMgr, TigerBuildPropertiesService buildProperties) {
        this.tigerTestEnvMgr = tigerTestEnvMgr;
        this.tigerTestEnvMgr.registerNewListener(this);
        this.buildProperties = buildProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void receiveTestEnvUpdate(TigerStatusUpdate update) {
        log.trace("receiving update {}", (Object)update);
        try {
            this.receiveTestSuiteUpdate(update.getFeatureMap());
            update.getServerUpdate().forEach(this::receiveServerStatusUpdate);
            if (update.getBannerMessage() != null) {
                this.tigerEnvStatus.setBannerMessage(update.getBannerMessage());
                this.tigerEnvStatus.setBannerColor(update.getBannerColor());
                this.tigerEnvStatus.setBannerType(update.getBannerType());
                this.tigerEnvStatus.setBannerIsHtml(update.isBannerIsHtml());
            }
            TigerEnvStatusDto tigerEnvStatusDto = this.tigerEnvStatus;
            synchronized (tigerEnvStatusDto) {
                if (update.getIndex() > this.tigerEnvStatus.getCurrentIndex()) {
                    this.tigerEnvStatus.setCurrentIndex(update.getIndex());
                }
            }
        }
        catch (Exception e) {
            log.error("Unable to parse update", (Throwable)e);
        }
    }

    private void receiveTestSuiteUpdate(Map<String, FeatureUpdate> update) {
        update.forEach((key, value) -> {
            try {
                if (this.tigerEnvStatus.getFeatureMap().containsKey(key)) {
                    FeatureUpdate feature = this.tigerEnvStatus.getFeatureMap().get(key);
                    if (value.getStatus() != TestResult.UNUSED) {
                        feature.setStatus(value.getStatus());
                    }
                    feature.setDescription(value.getDescription());
                    value.getScenarios().forEach((skey, svalue) -> {
                        if (feature.getScenarios().containsKey(skey)) {
                            ScenarioUpdate scenario = feature.getScenarios().get(skey);
                            if (svalue.getStatus() != TestResult.UNUSED) {
                                scenario.setStatus(svalue.getStatus());
                            }
                            scenario.setDescription(svalue.getDescription());
                            scenario.setExampleKeys(svalue.getExampleKeys());
                            scenario.setExampleList(svalue.getExampleList());
                            scenario.setVariantIndex(svalue.getVariantIndex());
                            svalue.getSteps().forEach((stkey, stvalue) -> {
                                if (scenario.getSteps().containsKey(stkey)) {
                                    StepUpdate step = scenario.getSteps().get(stkey);
                                    if (stvalue.getStatus() != TestResult.UNUSED) {
                                        step.setStatus(stvalue.getStatus());
                                    }
                                    step.setDescription(stvalue.getDescription());
                                    step.setStepIndex(stvalue.getStepIndex());
                                    if (stvalue.getRbelMetaData() != null) {
                                        if (step.getRbelMetaData() == null) {
                                            step.setRbelMetaData(new ArrayList<MessageMetaDataDto>());
                                        }
                                        step.getRbelMetaData().addAll(stvalue.getRbelMetaData());
                                    }
                                } else {
                                    scenario.getSteps().put((String)stkey, (StepUpdate)stvalue);
                                }
                            });
                        } else {
                            feature.getScenarios().put((String)skey, (ScenarioUpdate)svalue);
                        }
                    });
                } else {
                    this.tigerEnvStatus.getFeatureMap().put((String)key, (FeatureUpdate)value);
                }
            }
            catch (Exception e) {
                log.error("Unable to parse update", (Throwable)e);
            }
        });
    }

    private synchronized void receiveServerStatusUpdate(String serverName, TigerServerStatusUpdate statusUpdate) {
        log.trace("Status update for server {}", (Object)serverName);
        TigerServerStatusDto serverStatus = this.tigerEnvStatus.getServers().getOrDefault(serverName, new TigerServerStatusDto());
        serverStatus.setName(serverName);
        if (statusUpdate.getStatus() != null) {
            serverStatus.setStatus(statusUpdate.getStatus());
        }
        if (statusUpdate.getType() != null) {
            serverStatus.setType(statusUpdate.getType());
        }
        if (statusUpdate.getBaseUrl() != null) {
            serverStatus.setBaseUrl(statusUpdate.getBaseUrl());
        }
        if (statusUpdate.getStatusMessage() != null) {
            serverStatus.setStatusMessage(statusUpdate.getStatusMessage());
            serverStatus.getStatusUpdates().add(statusUpdate.getStatusMessage());
        }
        this.tigerEnvStatus.getServers().put(serverName, serverStatus);
    }

    @GetMapping(produces={"application/json"})
    public TigerEnvStatusDto getStatus() {
        log.trace("Fetch request to getStatus() received");
        this.tigerTestEnvMgr.setWorkflowUiSentFetch(true);
        log.trace("Sending test env status {}", (Object)this.tigerEnvStatus);
        return this.tigerEnvStatus;
    }

    @GetMapping(path={"/confirmShutdown"})
    public void getConfirmShutdown() {
        log.trace("Received shutdown confirmation");
        this.tigerTestEnvMgr.receivedConfirmationFromWorkflowUi(false);
    }

    @GetMapping(path={"/continueExecution"})
    public void getConfirmContinueExecution() {
        log.trace("Received confirmation to continue test execution");
        this.tigerTestEnvMgr.receivedConfirmationFromWorkflowUi(false);
    }

    @GetMapping(path={"/failExecution"})
    public void getConfirmToFailExecution() {
        log.trace("Received confirmation for failing test step");
        this.tigerTestEnvMgr.receivedConfirmationFromWorkflowUi(true);
        TigerStatusUpdate update = TigerStatusUpdate.builder().bannerMessage("Failing test run").bannerType(BannerType.MESSAGE).bannerColor("red").build();
        this.tigerTestEnvMgr.receiveTestEnvUpdate(update);
    }

    @GetMapping(path={"/version"})
    public String getTigerVersion() {
        log.trace("Fetch requests the tiger version {}", (Object)this.buildProperties.tigerVersionAsString());
        return this.buildProperties.tigerVersionAsString();
    }

    @GetMapping(path={"/build"})
    public String getBuildDate() {
        log.trace("Fetch requests the build date ", (Object)this.buildProperties.tigerBuildDateAsString());
        return this.buildProperties.tigerBuildDateAsString();
    }
}

