/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.controller;

import de.gematik.test.tiger.common.config.SourceType;
import de.gematik.test.tiger.common.config.TigerConfigurationKey;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.testenvmgr.data.TigerConfigurationPropertyDto;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/global_configuration"})
public class TigerGlobalConfigurationController {
    @GetMapping
    public List<TigerConfigurationPropertyDto> getGlobalConfiguration() {
        return TigerGlobalConfiguration.exportConfiguration().entrySet().stream().map(e -> TigerConfigurationPropertyDto.of((String)((String)e.getKey()), (String)((String)((Pair)e.getValue()).getRight()), (String)((SourceType)((Pair)e.getValue()).getLeft()).toString())).sorted(Comparator.comparing(TigerConfigurationPropertyDto::getKey)).toList();
    }

    @PutMapping
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateConfiguration(@RequestBody TigerConfigurationPropertyDto propertyToUpdate) {
        boolean exists = TigerGlobalConfiguration.readStringOptional((String)propertyToUpdate.getKey()).isPresent();
        if (!exists) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        TigerGlobalConfiguration.putValue((String)propertyToUpdate.getKey(), (String)propertyToUpdate.getValue());
    }

    @DeleteMapping
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteConfiguration(@RequestBody TigerConfigurationPropertyDto propertyToDelete) {
        TigerGlobalConfiguration.deleteFromAllSources((TigerConfigurationKey)new TigerConfigurationKey(new String[]{propertyToDelete.getKey()}));
    }
}

