/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.env.TigerServerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.servers.AbstractExternalTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerStatus;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@TigerServerType(value="externalUrl")
public class ExternalUrlServer
extends AbstractExternalTigerServer {
    public ExternalUrlServer(TigerTestEnvMgr tigerTestEnvMgr, String serverId, CfgServer configuration) {
        super(ExternalUrlServer.determineHostname(configuration, serverId), serverId, configuration, tigerTestEnvMgr);
        if (StringUtils.isEmpty((CharSequence)this.getConfiguration().getHealthcheckUrl())) {
            this.getConfiguration().setHealthcheckUrl((String)this.getConfiguration().getSource().get(0));
        }
    }

    @Override
    public void assertThatConfigurationIsCorrect() {
        if (StringUtils.isEmpty((CharSequence)this.getConfiguration().getHealthcheckUrl())) {
            this.getConfiguration().setHealthcheckUrl((String)this.getConfiguration().getSource().get(0));
        }
        super.assertThatConfigurationIsCorrect();
        this.assertCfgPropertySet(this.getConfiguration(), "source");
    }

    @Override
    public void performStartup() {
        this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().type("externalUrl").statusMessage("Starting external URL instance " + this.getServerId() + "...").build());
        URL url = this.buildUrl();
        this.addServerToLocalProxyRouteMap(url);
        this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().baseUrl(this.extractBaseUrl(url)).build());
        this.waitForServerUp();
    }

    @Override
    public void shutdown() {
        this.log.info("Stopping external url {}...", (Object)this.getServerId());
        this.removeAllRoutes();
        this.setStatus(TigerServerStatus.STOPPED, "Disconnected external url " + this.getServerId());
    }

    @Override
    public Optional<String> getHealthcheckUrl() {
        if (StringUtils.isEmpty((CharSequence)this.getConfiguration().getHealthcheckUrl())) {
            return Optional.of((String)this.getConfiguration().getSource().get(0));
        }
        return Optional.ofNullable(this.getConfiguration().getHealthcheckUrl());
    }

    private URL buildUrl() {
        try {
            return new URL(this.getTigerTestEnvMgr().replaceSysPropsInString((String)this.getConfiguration().getSource().get(0)));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not parse source URL '" + (String)this.getConfiguration().getSource().get(0) + "'!", e);
        }
    }

    @Generated
    public static ExternalUrlServerBuilder builder() {
        return new ExternalUrlServerBuilder();
    }

    @Generated
    public static class ExternalUrlServerBuilder {
        @Generated
        private TigerTestEnvMgr tigerTestEnvMgr;
        @Generated
        private String serverId;
        @Generated
        private CfgServer configuration;

        @Generated
        ExternalUrlServerBuilder() {
        }

        @Generated
        public ExternalUrlServerBuilder tigerTestEnvMgr(TigerTestEnvMgr tigerTestEnvMgr) {
            this.tigerTestEnvMgr = tigerTestEnvMgr;
            return this;
        }

        @Generated
        public ExternalUrlServerBuilder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        @Generated
        public ExternalUrlServerBuilder configuration(CfgServer configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public ExternalUrlServer build() {
            return new ExternalUrlServer(this.tigerTestEnvMgr, this.serverId, this.configuration);
        }

        @Generated
        public String toString() {
            return "ExternalUrlServer.ExternalUrlServerBuilder(tigerTestEnvMgr=" + this.tigerTestEnvMgr + ", serverId=" + this.serverId + ", configuration=" + this.configuration + ")";
        }
    }
}

