/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.env;

import com.google.common.util.concurrent.Monitor;
import de.gematik.test.tiger.common.util.TigerSerializationUtil;
import de.gematik.test.tiger.testenvmgr.exceptions.TigerDownloadManagerException;
import de.gematik.test.tiger.testenvmgr.servers.ExternalJarServer;
import de.gematik.test.tiger.testenvmgr.util.TigerEnvironmentStartupException;
import de.gematik.test.tiger.testenvmgr.util.TigerTestEnvException;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kong.unirest.GetRequest;
import kong.unirest.Unirest;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.function.ThrowingFunction;

public class DownloadManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DownloadManager.class);
    private static final String DOWNLOAD_PROPERTIES_SUFFIX = ".dwnProps";
    private static final Set<File> RESERVED_FILES = ConcurrentHashMap.newKeySet();
    private static final Set<String> DOWNLOADING_URLS = ConcurrentHashMap.newKeySet();
    private final Monitor monitor = new Monitor();

    private static Stream<Path> streamOfCandidateFiles(String workingDir, String jarName) {
        try {
            return Files.walk(Path.of(workingDir, new String[0]), 1, new FileVisitOption[0]).filter(path -> path.getFileName().startsWith(jarName)).filter(path -> !path.getFileName().endsWith(DOWNLOAD_PROPERTIES_SUFFIX));
        }
        catch (IOException e) {
            throw new TigerDownloadManagerException("IO-Error during jar-downloading", e);
        }
    }

    private static boolean isJarDownloadedFromUrl(Path path, String downloadUrl) {
        return DownloadManager.readAssociatedFileProperties(path.toFile()).map(FileDownloadProperties::getDownloadUrl).map(url -> url.equals(downloadUrl)).orElse(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File seekNewUniqueFile(String workingDir, String jarName) {
        Set<File> set = RESERVED_FILES;
        synchronized (set) {
            if (DownloadManager.streamOfCandidateFiles(workingDir, jarName).findAny().isEmpty()) {
                return Path.of(workingDir, jarName).toFile();
            }
            AtomicReference<File> candidateFile = new AtomicReference<File>();
            do {
                candidateFile.set(Path.of(workingDir, jarName + "_" + RandomStringUtils.randomAlphanumeric((int)10)).toFile());
            } while (DownloadManager.streamOfCandidateFiles(workingDir, jarName).anyMatch(path -> path.getFileName().equals(((File)candidateFile.get()).toPath())));
            RESERVED_FILES.add((File)candidateFile.get());
            return (File)candidateFile.get();
        }
    }

    private static Optional<FileDownloadProperties> readAssociatedFileProperties(File candidateFile) {
        File propertiesFile = new File(candidateFile.getAbsolutePath() + DOWNLOAD_PROPERTIES_SUFFIX);
        if (!propertiesFile.exists()) {
            return Optional.empty();
        }
        return Optional.of((FileDownloadProperties)TigerSerializationUtil.fromJson((String)FileUtils.readFileToString((File)propertiesFile, (Charset)StandardCharsets.UTF_8), FileDownloadProperties.class));
    }

    private static void downloadJar(String workingDir, String jarUrl, File jarFile, String serverId) {
        log.info("Downloading jar for external server {} from '{}'...", (Object)serverId, (Object)jarUrl);
        File workDir = new File(workingDir);
        if (!workDir.exists() && !workDir.mkdirs()) {
            throw new TigerTestEnvException("Unable to create working directory " + workDir.getAbsolutePath());
        }
        AtomicReference<LocalDateTime> lastTimePrinted = new AtomicReference<LocalDateTime>(LocalDateTime.now());
        AtomicReference<Long> lastSizePrinted = new AtomicReference<Long>(0L);
        LocalDateTime firstTimePrinted = LocalDateTime.now();
        ((GetRequest)Unirest.get((String)jarUrl).downloadMonitor((field, fileName, bytesWritten, totalBytes) -> {
            if (((LocalDateTime)lastTimePrinted.get()).isBefore(LocalDateTime.now().minusSeconds(2L)) || bytesWritten - 10000000L > (Long)lastSizePrinted.get()) {
                Duration downloadDuration = Duration.between(firstTimePrinted, LocalDateTime.now());
                double speedInBytesPerMilliSecond = (double)bytesWritten.longValue() / (double)downloadDuration.toMillis();
                Duration remainingTime = Duration.ofMillis((long)((double)(totalBytes - bytesWritten) / speedInBytesPerMilliSecond));
                log.info("Downloading jar for {}. {} kb of {} kb completed (Elapsed time {}, estimated {} till completion)", new Object[]{serverId, bytesWritten / 1000L, totalBytes / 1000L, DownloadManager.prettyPrintDuration(downloadDuration), DownloadManager.prettyPrintDuration(remainingTime)});
                lastTimePrinted.set(LocalDateTime.now());
                lastSizePrinted.set(bytesWritten);
            }
        })).asFile(jarFile.getAbsolutePath(), new CopyOption[0]).ifSuccess(downloadResponse -> {
            try {
                FileUtils.writeByteArrayToFile((File)new File(jarFile.getAbsolutePath() + DOWNLOAD_PROPERTIES_SUFFIX), (byte[])DownloadManager.generateDownloadPropertiesFile(jarUrl));
            }
            catch (IOException e) {
                throw new TigerEnvironmentStartupException("Error during local saving of jar-file", e);
            }
        }).ifFailure(errorResponse -> {
            throw new TigerEnvironmentStartupException("Error during jar-file download (status %s)", errorResponse.getStatus());
        });
    }

    private static String prettyPrintDuration(Duration duration) {
        return Duration.ofSeconds(duration.toSeconds()).toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase();
    }

    private static byte[] generateDownloadPropertiesFile(String url) {
        return TigerSerializationUtil.toJson((Object)FileDownloadProperties.builder().downloadUrl(url).build()).getBytes(StandardCharsets.UTF_8);
    }

    public File downloadJarAndReturnFile(ExternalJarServer externalJarServer, String jarUrl, String workingDir) {
        if (jarUrl.startsWith("local:")) {
            String localJarString = jarUrl.replaceFirst("local:", "");
            String jarFileName = DownloadManager.getFileNameFromPath(localJarString);
            Optional<String> jarFileFiltered = Optional.of(jarFileName).filter(file -> !file.contains("*"));
            Optional<String> localJarFiltered = Optional.of(localJarString).filter(file -> !file.contains("*"));
            ThrowingFunction relativeJarResolver = dir -> Files.find(dir, 1, (p, a) -> new WildcardFileFilter(jarFileName).accept(p.toFile()), new FileVisitOption[0]);
            List<Supplier<Optional>> candidateFileSuppliers = List.of(() -> jarFileFiltered.map(filename -> Paths.get(workingDir, filename).toFile()), () -> localJarFiltered.map(filename -> Paths.get(workingDir, filename).toFile()), () -> Optional.ofNullable(new File(workingDir).listFiles((FilenameFilter)new WildcardFileFilter(jarFileName))).filter(ar -> ((File[])ar).length > 0).map(ar -> ar[0]), () -> Optional.of(DownloadManager.getParentFolderFromPath(localJarString)).map(x$0 -> Path.of(x$0, new String[0])).map(p -> Path.of(workingDir, new String[0]).resolve((Path)p)).filter(p -> p.toFile().exists()).stream().flatMap(relativeJarResolver).findFirst().map(Path::toFile).filter(File::exists));
            File jarFile = candidateFileSuppliers.stream().map(Supplier::get).filter(Optional::isPresent).map(Optional::get).filter(File::exists).findFirst().orElseThrow(() -> new TigerTestEnvException("Local jar-file '" + localJarString + "' with working directory '" + workingDir + "' not found!"));
            externalJarServer.statusMessage("Starting " + externalJarServer.getServerId() + " from local JAR-File '" + jarFile.getAbsolutePath() + "'");
            return jarFile;
        }
        externalJarServer.statusMessage("Downloading " + externalJarServer.getServerId() + " JAR-File from '" + jarUrl + "'...");
        return this.executeDownload(workingDir, jarUrl, externalJarServer.getServerId());
    }

    private static String getFileNameFromPath(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        String[] splits = value.split("/");
        return splits[splits.length - 1];
    }

    private static String getParentFolderFromPath(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        int pathCutoffPosition = value.lastIndexOf("/");
        if (pathCutoffPosition < 0) {
            return value;
        }
        return value.substring(0, pathCutoffPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File executeDownload(String workingDir, String jarUrl, String serverId) {
        String jarName = jarUrl.substring(jarUrl.lastIndexOf("/") + 1).replaceAll("\\W+", "");
        Monitor.Guard jarCurrentlyNotDownloading = this.monitor.newGuard(() -> !DOWNLOADING_URLS.contains(jarUrl));
        log.trace("{} tries to enter the monitor...", (Object)serverId);
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.enterWhen(jarCurrentlyNotDownloading);
        }
        log.trace("{} has entered the monitor!", (Object)serverId);
        try {
            object = DownloadManager.streamOfCandidateFiles(workingDir, jarName).filter(path -> DownloadManager.isJarDownloadedFromUrl(path, jarUrl)).map(Path::toFile).findAny().orElseGet(() -> {
                File jarFile = DownloadManager.seekNewUniqueFile(workingDir, jarName);
                DownloadManager.downloadJar(workingDir, jarUrl, jarFile, serverId);
                return jarFile;
            });
        }
        catch (Throwable throwable) {
            log.trace("{} tries to leave the monitor...", (Object)serverId);
            this.monitor.leave();
            log.trace("{} has left the monitor!", (Object)serverId);
            throw throwable;
        }
        log.trace("{} tries to leave the monitor...", (Object)serverId);
        this.monitor.leave();
        log.trace("{} has left the monitor!", (Object)serverId);
        return object;
    }

    public static class FileDownloadProperties {
        private String downloadUrl;
        private String etag;

        @ConstructorProperties(value={"downloadUrl", "etag"})
        @Generated
        FileDownloadProperties(String downloadUrl, String etag) {
            this.downloadUrl = downloadUrl;
            this.etag = etag;
        }

        @Generated
        public static FileDownloadPropertiesBuilder builder() {
            return new FileDownloadPropertiesBuilder();
        }

        @Generated
        public String getDownloadUrl() {
            return this.downloadUrl;
        }

        @Generated
        public String getEtag() {
            return this.etag;
        }

        @Generated
        public void setDownloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
        }

        @Generated
        public void setEtag(String etag) {
            this.etag = etag;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileDownloadProperties)) {
                return false;
            }
            FileDownloadProperties other = (FileDownloadProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$downloadUrl = this.getDownloadUrl();
            String other$downloadUrl = other.getDownloadUrl();
            if (this$downloadUrl == null ? other$downloadUrl != null : !this$downloadUrl.equals(other$downloadUrl)) {
                return false;
            }
            String this$etag = this.getEtag();
            String other$etag = other.getEtag();
            return !(this$etag == null ? other$etag != null : !this$etag.equals(other$etag));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FileDownloadProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $downloadUrl = this.getDownloadUrl();
            result = result * 59 + ($downloadUrl == null ? 43 : $downloadUrl.hashCode());
            String $etag = this.getEtag();
            result = result * 59 + ($etag == null ? 43 : $etag.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DownloadManager.FileDownloadProperties(downloadUrl=" + this.getDownloadUrl() + ", etag=" + this.getEtag() + ")";
        }

        @Generated
        public static class FileDownloadPropertiesBuilder {
            @Generated
            private String downloadUrl;
            @Generated
            private String etag;

            @Generated
            FileDownloadPropertiesBuilder() {
            }

            @Generated
            public FileDownloadPropertiesBuilder downloadUrl(String downloadUrl) {
                this.downloadUrl = downloadUrl;
                return this;
            }

            @Generated
            public FileDownloadPropertiesBuilder etag(String etag) {
                this.etag = etag;
                return this;
            }

            @Generated
            public FileDownloadProperties build() {
                return new FileDownloadProperties(this.downloadUrl, this.etag);
            }

            @Generated
            public String toString() {
                return "DownloadManager.FileDownloadProperties.FileDownloadPropertiesBuilder(downloadUrl=" + this.downloadUrl + ", etag=" + this.etag + ")";
            }
        }
    }
}

