/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.env;

import com.google.common.util.concurrent.Monitor;
import de.gematik.test.tiger.common.util.TigerSerializationUtil;
import de.gematik.test.tiger.testenvmgr.env.DownloadManager;
import de.gematik.test.tiger.testenvmgr.exceptions.TigerDownloadManagerException;
import de.gematik.test.tiger.testenvmgr.servers.ExternalJarServer;
import de.gematik.test.tiger.testenvmgr.util.TigerEnvironmentStartupException;
import de.gematik.test.tiger.testenvmgr.util.TigerTestEnvException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kong.unirest.GetRequest;
import kong.unirest.Unirest;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.function.ThrowingFunction;

/*
 * Exception performing whole class analysis ignored.
 */
public class DownloadManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DownloadManager.class);
    private static final String DOWNLOAD_PROPERTIES_SUFFIX = ".dwnProps";
    private static final Set<File> RESERVED_FILES = ConcurrentHashMap.newKeySet();
    private static final Set<String> DOWNLOADING_URLS = ConcurrentHashMap.newKeySet();
    private final Monitor monitor = new Monitor();

    private static Stream<Path> streamOfCandidateFiles(String workingDir, String jarName) {
        try {
            return Files.walk(Path.of(workingDir, new String[0]), 1, new FileVisitOption[0]).filter(path -> path.getFileName().startsWith(jarName)).filter(path -> !path.getFileName().endsWith(".dwnProps"));
        }
        catch (IOException e) {
            throw new TigerDownloadManagerException("IO-Error during jar-downloading", (Exception)e);
        }
    }

    private static boolean isJarDownloadedFromUrl(Path path, String downloadUrl) {
        return DownloadManager.readAssociatedFileProperties((File)path.toFile()).map(FileDownloadProperties::getDownloadUrl).map(url -> url.equals(downloadUrl)).orElse(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File seekNewUniqueFile(String workingDir, String jarName) {
        Set set = RESERVED_FILES;
        synchronized (set) {
            if (DownloadManager.streamOfCandidateFiles((String)workingDir, (String)jarName).findAny().isEmpty()) {
                return Path.of(workingDir, jarName).toFile();
            }
            AtomicReference<File> candidateFile = new AtomicReference<File>();
            do {
                candidateFile.set(Path.of(workingDir, jarName + "_" + RandomStringUtils.randomAlphanumeric((int)10)).toFile());
            } while (DownloadManager.streamOfCandidateFiles((String)workingDir, (String)jarName).anyMatch(path -> path.getFileName().equals(((File)candidateFile.get()).toPath())));
            RESERVED_FILES.add((File)candidateFile.get());
            return (File)candidateFile.get();
        }
    }

    private static Optional<FileDownloadProperties> readAssociatedFileProperties(File candidateFile) {
        File propertiesFile = new File(candidateFile.getAbsolutePath() + ".dwnProps");
        if (!propertiesFile.exists()) {
            return Optional.empty();
        }
        return Optional.of((FileDownloadProperties)TigerSerializationUtil.fromJson((String)FileUtils.readFileToString((File)propertiesFile, (Charset)StandardCharsets.UTF_8), FileDownloadProperties.class));
    }

    private static void downloadJar(String workingDir, String jarUrl, File jarFile, String serverId) {
        log.info("Downloading jar for external server {} from '{}'...", (Object)serverId, (Object)jarUrl);
        File workDir = new File(workingDir);
        if (!workDir.exists() && !workDir.mkdirs()) {
            throw new TigerTestEnvException("Unable to create working directory " + workDir.getAbsolutePath());
        }
        AtomicReference<LocalDateTime> lastTimePrinted = new AtomicReference<LocalDateTime>(LocalDateTime.now());
        AtomicReference<Long> lastSizePrinted = new AtomicReference<Long>(0L);
        LocalDateTime firstTimePrinted = LocalDateTime.now();
        ((GetRequest)Unirest.get((String)jarUrl).downloadMonitor((field, fileName, bytesWritten, totalBytes) -> {
            if (((LocalDateTime)lastTimePrinted.get()).isBefore(LocalDateTime.now().minusSeconds(2L)) || bytesWritten - 10000000L > (Long)lastSizePrinted.get()) {
                Duration downloadDuration = Duration.between(firstTimePrinted, LocalDateTime.now());
                double speedInBytesPerMilliSecond = (double)bytesWritten.longValue() / (double)downloadDuration.toMillis();
                Duration remainingTime = Duration.ofMillis((long)((double)(totalBytes - bytesWritten) / speedInBytesPerMilliSecond));
                log.info("Downloading jar for {}. {} kb of {} kb completed (Elapsed time {}, estimated {} till completion)", new Object[]{serverId, bytesWritten / 1000L, totalBytes / 1000L, DownloadManager.prettyPrintDuration((Duration)downloadDuration), DownloadManager.prettyPrintDuration((Duration)remainingTime)});
                lastTimePrinted.set(LocalDateTime.now());
                lastSizePrinted.set(bytesWritten);
            }
        })).asFile(jarFile.getAbsolutePath(), new CopyOption[0]).ifSuccess(downloadResponse -> {
            try {
                FileUtils.writeByteArrayToFile((File)new File(jarFile.getAbsolutePath() + ".dwnProps"), (byte[])DownloadManager.generateDownloadPropertiesFile((String)jarUrl));
            }
            catch (IOException e) {
                throw new TigerEnvironmentStartupException("Error during local saving of jar-file", (Exception)e);
            }
        }).ifFailure(errorResponse -> {
            throw new TigerEnvironmentStartupException("Error during jar-file download (status %s)", new Object[]{errorResponse.getStatus()});
        });
    }

    private static String prettyPrintDuration(Duration duration) {
        return Duration.ofSeconds(duration.toSeconds()).toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase();
    }

    private static byte[] generateDownloadPropertiesFile(String url) {
        return TigerSerializationUtil.toJson((Object)FileDownloadProperties.builder().downloadUrl(url).build()).getBytes(StandardCharsets.UTF_8);
    }

    public File downloadJarAndReturnFile(ExternalJarServer externalJarServer, String jarUrl, String workingDir) {
        if (jarUrl.startsWith("local:")) {
            String localJarString = jarUrl.replaceFirst("local:", "");
            String jarFileName = DownloadManager.getFileNameFromPath((String)localJarString);
            ThrowingFunction relativeJarResolver = dir -> Files.find(dir, 1, (p, a) -> new WildcardFileFilter(jarFileName).accept(p.toFile()), new FileVisitOption[0]);
            List<Supplier<Optional>> candidateFileSuppliers = List.of(() -> Optional.of(Paths.get(workingDir, jarFileName).toFile()), () -> Optional.of(Paths.get(workingDir, localJarString).toFile()), () -> Optional.ofNullable(new File(workingDir).listFiles((FilenameFilter)new WildcardFileFilter(jarFileName))).filter(ar -> ((File[])ar).length > 0).map(ar -> ar[0]), () -> Optional.of(DownloadManager.getParentFolderFromPath((String)localJarString)).map(x$0 -> Path.of(x$0, new String[0])).map(p -> Path.of(workingDir, new String[0]).resolve((Path)p)).filter(p -> p.toFile().exists()).stream().flatMap(relativeJarResolver).findFirst().map(Path::toFile).filter(File::exists));
            File jarFile = candidateFileSuppliers.stream().map(Supplier::get).filter(Optional::isPresent).map(Optional::get).filter(File::exists).findFirst().orElseThrow(() -> new TigerTestEnvException("Local jar-file '" + localJarString + "' with working directory '" + workingDir + "' not found!"));
            externalJarServer.statusMessage("Starting " + externalJarServer.getServerId() + " from local JAR-File '" + jarFile.getAbsolutePath() + "'");
            return jarFile;
        }
        externalJarServer.statusMessage("Downloading " + externalJarServer.getServerId() + " JAR-File from '" + jarUrl + "'...");
        return this.executeDownload(workingDir, jarUrl, externalJarServer.getServerId());
    }

    private static String getFileNameFromPath(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        String[] splits = value.split("/");
        return splits[splits.length - 1];
    }

    private static String getParentFolderFromPath(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        int pathCutoffPosition = value.lastIndexOf("/");
        if (pathCutoffPosition < 0) {
            return value;
        }
        return value.substring(0, pathCutoffPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File executeDownload(String workingDir, String jarUrl, String serverId) {
        String jarName = jarUrl.substring(jarUrl.lastIndexOf("/") + 1).replaceAll("\\W+", "");
        Monitor.Guard jarCurrentlyNotDownloading = this.monitor.newGuard(() -> !DOWNLOADING_URLS.contains(jarUrl));
        log.trace("{} tries to enter the monitor...", (Object)serverId);
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.enterWhen(jarCurrentlyNotDownloading);
        }
        log.trace("{} has entered the monitor!", (Object)serverId);
        try {
            object = DownloadManager.streamOfCandidateFiles((String)workingDir, (String)jarName).filter(path -> DownloadManager.isJarDownloadedFromUrl((Path)path, (String)jarUrl)).map(Path::toFile).findAny().orElseGet(() -> {
                File jarFile = DownloadManager.seekNewUniqueFile((String)workingDir, (String)jarName);
                DownloadManager.downloadJar((String)workingDir, (String)jarUrl, (File)jarFile, (String)serverId);
                return jarFile;
            });
        }
        catch (Throwable throwable) {
            log.trace("{} tries to leave the monitor...", (Object)serverId);
            this.monitor.leave();
            log.trace("{} has left the monitor!", (Object)serverId);
            throw throwable;
        }
        log.trace("{} tries to leave the monitor...", (Object)serverId);
        this.monitor.leave();
        log.trace("{} has left the monitor!", (Object)serverId);
        return object;
    }
}

