/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers.log;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.servers.AbstractTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerProxyServer;
import de.gematik.test.tiger.testenvmgr.servers.log.CustomerAppender;
import de.gematik.test.tiger.testenvmgr.servers.log.CustomerLocalProxyAppender;
import de.gematik.test.tiger.testenvmgr.servers.log.CustomerProxyServerAppender;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerServerLogManager {
    private static final String DEFAULT_LOGFILE_LOCATION = "./target/serverLogs/";
    private static final String LOGFILE_EXTENSION = ".log";
    private static final String DEFAULT_PATTERN_LAYOUT = "%date %level [%thread] %logger{10} [%file:%line] %msg%n";

    public static void addAppenders(AbstractTigerServer server) {
        ch.qos.logback.classic.Logger logbackLogger = (ch.qos.logback.classic.Logger)server.getLog();
        TigerServerLogManager.createAndAddAppenders(server, logbackLogger);
    }

    private static void createAndAddAppenders(AbstractTigerServer server, ch.qos.logback.classic.Logger log) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        PatternLayoutEncoder patternLayoutEncoder = new PatternLayoutEncoder();
        patternLayoutEncoder.setPattern(DEFAULT_PATTERN_LAYOUT);
        patternLayoutEncoder.setContext((Context)loggerContext);
        patternLayoutEncoder.start();
        log.addAppender(TigerServerLogManager.createFileAppender(server.getServerId(), server.getConfiguration().getLogFile(), loggerContext, patternLayoutEncoder));
        log.addAppender(TigerServerLogManager.createConsoleAppender(loggerContext, patternLayoutEncoder));
        log.addAppender((Appender)TigerServerLogManager.createCustomerAppender(server, loggerContext));
        log.setAdditive(false);
    }

    private static FileAppender<ILoggingEvent> createFileAppender(String serverId, String logFilePath, LoggerContext loggerContext, PatternLayoutEncoder patternLayoutEncoder) {
        String fileName = TigerServerLogManager.createFileName(serverId, logFilePath);
        FileAppender fileAppender = new FileAppender();
        fileAppender.setFile(fileName);
        fileAppender.setAppend(false);
        fileAppender.setEncoder((Encoder)patternLayoutEncoder);
        fileAppender.setContext((Context)loggerContext);
        fileAppender.start();
        return fileAppender;
    }

    private static ConsoleAppender<ILoggingEvent> createConsoleAppender(LoggerContext loggerContext, PatternLayoutEncoder patternLayoutEncoder) {
        ConsoleAppender consoleAppender = new ConsoleAppender();
        consoleAppender.setEncoder((Encoder)patternLayoutEncoder);
        consoleAppender.setContext((Context)loggerContext);
        consoleAppender.start();
        return consoleAppender;
    }

    private static String createFileName(String serverId, String logFilePath) {
        if (logFilePath != null) {
            File file = new File(logFilePath);
            if (file.isDirectory()) {
                return file.getAbsolutePath() + serverId + LOGFILE_EXTENSION;
            }
            return file.getAbsolutePath();
        }
        return DEFAULT_LOGFILE_LOCATION + serverId + LOGFILE_EXTENSION;
    }

    private static CustomerAppender createCustomerAppender(AbstractTigerServer server, LoggerContext loggerContext) {
        CustomerAppender customerAppender = new CustomerAppender(server);
        customerAppender.setContext((Context)loggerContext);
        customerAppender.start();
        return customerAppender;
    }

    public static void addProxyCustomerAppender(TigerProxyServer tigerProxyServer) {
        ch.qos.logback.classic.Logger logbackLogger = (ch.qos.logback.classic.Logger)tigerProxyServer.getTigerProxy().getLog();
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        CustomerProxyServerAppender customerAppender = new CustomerProxyServerAppender(tigerProxyServer);
        customerAppender.setContext((Context)loggerContext);
        customerAppender.start();
        logbackLogger.addAppender((Appender)customerAppender);
    }

    public static void addProxyCustomerAppender(TigerTestEnvMgr tigerTestEnvMgr, Logger log) {
        ch.qos.logback.classic.Logger logbackLoggerLocalProxy = (ch.qos.logback.classic.Logger)log;
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        CustomerLocalProxyAppender customerAppender = new CustomerLocalProxyAppender(tigerTestEnvMgr);
        customerAppender.setContext((Context)loggerContext);
        customerAppender.start();
        logbackLoggerLocalProxy.addAppender((Appender)customerAppender);
    }
}

