/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.controller;

import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.data.TigerServerLogDto;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerLogListener;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerLogUpdate;
import java.beans.ConstructorProperties;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Service;

@Service
public class UpdateLogController
implements TigerServerLogListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdateLogController.class);
    public final SimpMessagingTemplate template;
    public final TigerTestEnvMgr tigerTestEnvMgr;

    @PostConstruct
    public void addWebSocketListener() {
        this.tigerTestEnvMgr.getServers().values().forEach(server -> server.registerLogListener(this));
        this.tigerTestEnvMgr.registerLogListener(this);
    }

    @Override
    public void receiveServerLogUpdate(TigerServerLogUpdate update) {
        log.trace("Propagating tiger server log update {}", (Object)update);
        this.template.convertAndSend((Object)"/topic/serverLog", (Object)TigerServerLogDto.createFrom(update));
    }

    @ConstructorProperties(value={"template", "tigerTestEnvMgr"})
    @Generated
    public UpdateLogController(SimpMessagingTemplate template, TigerTestEnvMgr tigerTestEnvMgr) {
        this.template = template;
        this.tigerTestEnvMgr = tigerTestEnvMgr;
    }
}

