/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.test.tiger.common.Ansi;
import de.gematik.test.tiger.common.banner.Banner;
import de.gematik.test.tiger.common.config.SourceType;
import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.config.TigerConfigurationKeys;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.common.util.TigerSerializationUtil;
import de.gematik.test.tiger.proxy.AbstractTigerProxy;
import de.gematik.test.tiger.proxy.IRbelMessageListener;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.TigerProxyApplication;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.config.Configuration;
import de.gematik.test.tiger.testenvmgr.env.DownloadManager;
import de.gematik.test.tiger.testenvmgr.env.TigerEnvUpdateSender;
import de.gematik.test.tiger.testenvmgr.env.TigerServerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.env.TigerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.env.TigerUpdateListener;
import de.gematik.test.tiger.testenvmgr.servers.AbstractTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerLogListener;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerStatus;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerType;
import de.gematik.test.tiger.testenvmgr.servers.log.TigerServerLogManager;
import de.gematik.test.tiger.testenvmgr.util.TigerEnvironmentStartupException;
import de.gematik.test.tiger.testenvmgr.util.TigerTestEnvException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class TigerTestEnvMgr
implements TigerEnvUpdateSender,
TigerUpdateListener,
DisposableBean,
AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerTestEnvMgr.class);
    public static final String HTTP = "http://";
    public static final String HTTPS = "https://";
    private final Configuration configuration;
    private final Map<String, Object> environmentVariables;
    private TigerProxy localTigerProxy;
    public static final String CFG_PROP_NAME_LOCAL_PROXY_ADMIN_PORT = "tiger.tigerProxy.adminPort";
    public static final String CFG_PROP_NAME_LOCAL_PROXY_PROXY_PORT = "tiger.tigerProxy.proxyPort";
    public static final String LOCAL_TIGER_PROXY_TYPE = "local_tiger_proxy";
    private final List<TigerRoute> routesList = new ArrayList<TigerRoute>();
    private final Map<String, AbstractTigerServer> servers = new HashMap<String, AbstractTigerServer>();
    private final ExecutorService cachedExecutor = Executors.newCachedThreadPool();
    private final ExecutorService fixedPoolExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
    private final List<TigerUpdateListener> listeners = new ArrayList<TigerUpdateListener>();
    private final List<TigerServerLogListener> logListeners = new ArrayList<TigerServerLogListener>();
    private final DownloadManager downloadManager = new DownloadManager();
    private ServletWebServerApplicationContext localTigerProxyApplicationContext;
    private boolean userAcknowledgedShutdown = false;
    private boolean userAcknowledgedContinueTestRun = false;
    private boolean userAcknowledgedFailingTestRun = false;
    private boolean isShuttingDown = false;
    private boolean isShutDown = false;
    private boolean workflowUiSentFetch = false;
    private final Map<String, Class<? extends AbstractTigerServer>> serverClasses = new HashMap<String, Class<? extends AbstractTigerServer>>();
    private final Logger localProxyLog;

    public TigerTestEnvMgr() {
        this.configuration = TigerTestEnvMgr.readConfiguration();
        this.environmentVariables = new HashMap<String, Object>();
        this.localProxyLog = LoggerFactory.getLogger((String)"localTigerProxy");
        this.logConfiguration();
        this.lookupServerPluginsInClasspath();
        try {
            this.createServerObjects();
            log.info("Tiger Testenv mgr created OK");
        }
        catch (RuntimeException e) {
            this.shutDown();
            throw e;
        }
    }

    public void startLocalTigerProxyIfActivated() {
        if (this.configuration.isLocalProxyActive()) {
            TigerServerLogManager.addProxyCustomerAppender(this, this.localProxyLog);
            this.localTigerProxy = this.startLocalTigerProxy(this.configuration);
            this.proxyStatusMessage("Local Tiger Proxy URL http://localhost:" + this.localTigerProxy.getProxyPort(), RbelAnsiColors.BLUE_BOLD);
            this.proxyStatusMessage("Local Tiger Proxy UI http://localhost:" + this.localTigerProxyApplicationContext.getWebServer().getPort() + "/webui", RbelAnsiColors.BLUE_BOLD);
            this.environmentVariables.put("PROXYHOST", "host.docker.internal");
            this.environmentVariables.put("PROXYPORT", this.localTigerProxy.getProxyPort());
            TigerServerLogManager.addProxyCustomerAppender(this, this.localTigerProxy.getLog());
        } else {
            log.info(Ansi.colorize((String)"Local Tiger Proxy deactivated", (RbelAnsiColors)RbelAnsiColors.RED_BOLD));
            this.localTigerProxy = null;
        }
    }

    private void proxyStatusMessage(String statusMessage, RbelAnsiColors color) {
        this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().type(LOCAL_TIGER_PROXY_TYPE).status(TigerServerStatus.RUNNING).statusMessage(statusMessage).baseUrl("http://localhost:" + this.localTigerProxyApplicationContext.getWebServer().getPort() + "/webui").build());
        if (this.localProxyLog.isInfoEnabled()) {
            this.localProxyLog.info(Ansi.colorize((String)statusMessage, (RbelAnsiColors)color));
        }
    }

    private void logConfiguration() {
        if (log.isDebugEnabled()) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
            try {
                log.debug("Tiger configuration: " + mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.configuration));
            }
            catch (JsonProcessingException e) {
                log.error("Unable to dump tiger configuration in " + this.getClass().getSimpleName(), (Throwable)e);
            }
            try {
                log.debug("Environment variables: " + mapper.writerWithDefaultPrettyPrinter().writeValueAsString(System.getenv()));
            }
            catch (JsonProcessingException e) {
                log.error("Unable to dump os env variables in " + this.getClass().getSimpleName(), (Throwable)e);
            }
        }
    }

    private void lookupServerPluginsInClasspath() {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(TigerServerType.class));
        Set serverBeanDefinitions = scanner.findCandidateComponents("de.gematik.test.tiger");
        for (BeanDefinition serverBeanDefinition : serverBeanDefinitions) {
            try {
                Class<?> clz = Class.forName(serverBeanDefinition.getBeanClassName());
                String typeToken = clz.getAnnotation(TigerServerType.class).value();
                this.serverClasses.put(typeToken, clz.asSubclass(AbstractTigerServer.class));
                log.info("Registered server type {} with class {}", (Object)typeToken, (Object)serverBeanDefinition.getBeanClassName());
            }
            catch (ClassNotFoundException e) {
                throw new TigerTestEnvException("Unable to instantiate / find class " + serverBeanDefinition.getBeanClassName() + " for server", e);
            }
        }
    }

    private TigerProxy startLocalTigerProxy(Configuration configuration) {
        log.info("\n" + Banner.toBannerStr((String)"STARTING LOCAL PROXY...", (String)RbelAnsiColors.BLUE_BOLD.toString()));
        if (configuration.getTigerProxy() == null) {
            configuration.setTigerProxy(TigerProxyConfiguration.builder().build());
        }
        TigerProxyConfiguration proxyConfig = configuration.getTigerProxy();
        proxyConfig.setName(LOCAL_TIGER_PROXY_TYPE);
        proxyConfig.setSkipTrafficEndpointsSubscription(true);
        if (proxyConfig.getProxyRoutes() == null) {
            proxyConfig.setProxyRoutes(List.of());
        }
        HashMap<String, String> properties = new HashMap<String, String>(TigerSerializationUtil.toMap((Object)proxyConfig, (String[])new String[]{"tigerProxy"}));
        if (configuration.getTigerProxy().getAdminPort() == 0) {
            int port = (Integer)TigerConfigurationKeys.LOCALPROXY_ADMIN_RESERVED_PORT.getValue().orElseThrow(() -> new TigerEnvironmentStartupException("No free port reserved for local Tiger Proxy admin"));
            properties.put("server.port", Integer.toString(port));
        } else {
            properties.put("server.port", Integer.toString(configuration.getTigerProxy().getAdminPort()));
            TigerConfigurationKeys.LOCALPROXY_ADMIN_RESERVED_PORT.putValue((Object)configuration.getTigerProxy().getAdminPort());
        }
        this.localTigerProxyApplicationContext = (ServletWebServerApplicationContext)new SpringApplicationBuilder(new Class[0]).bannerMode(Banner.Mode.OFF).properties(properties).sources(new Class[]{TigerProxyApplication.class}).web(WebApplicationType.SERVLET).registerShutdownHook(false).initializers(new ApplicationContextInitializer[0]).run(new String[0]);
        TigerProxy localTigerProxy = (TigerProxy)this.localTigerProxyApplicationContext.getBean(TigerProxy.class);
        TigerConfigurationKeys.LOCAL_PROXY_PROXY_PORT.putValue((Object)localTigerProxy.getProxyPort());
        TigerConfigurationKeys.LOCAL_PROXY_ADMIN_PORT.putValue((Object)localTigerProxy.getAdminPort());
        return localTigerProxy;
    }

    public void publishNewStatusUpdate(TigerServerStatusUpdate update) {
        this.publishStatusUpdateToListeners(TigerStatusUpdate.builder().serverUpdate(new LinkedHashMap<String, TigerServerStatusUpdate>(Map.of(this.getLocalTigerProxyOptional().flatMap(AbstractTigerProxy::getName).orElse(this.getLocalTigerProxy().proxyName()), update))).build(), this.listeners);
    }

    public synchronized void publishStatusUpdateToListeners(TigerStatusUpdate update, List<TigerUpdateListener> listeners) {
        if (!this.isShuttingDown) {
            this.getFixedPoolExecutor().submit(() -> listeners.stream().forEach(listener -> listener.receiveTestEnvUpdate(update)));
        }
    }

    private static void readCommandFromInput(String textToEnter, String message, Function<Void, String> readLine) {
        String cmd = null;
        while (cmd == null || !cmd.equals(textToEnter)) {
            log.info(message);
            if (cmd != null) {
                log.warn("Received: '{}'", (Object)cmd);
            }
            cmd = readLine.apply(null);
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new TigerTestEnvException("Interrupt received while waiting for console input", e);
            }
        }
    }

    private static void readTemplates() {
        try {
            URL templatesUrl = TigerTestEnvMgr.class.getResource("templates.yaml");
            String templatesYaml = IOUtils.toString((URI)Objects.requireNonNull(templatesUrl).toURI(), (Charset)StandardCharsets.UTF_8);
            TigerGlobalConfiguration.readTemplates((String)templatesYaml, (String[])new String[]{"tiger", "servers"});
        }
        catch (IOException | URISyntaxException e) {
            throw new TigerConfigurationException("Unable to read templates YAML!", (Throwable)e);
        }
    }

    private static Configuration readConfiguration() {
        TigerGlobalConfiguration.initialize();
        TigerTestEnvMgr.readTemplates();
        TigerTestEnvMgr.addDefaults();
        Configuration configuration = TigerGlobalConfiguration.instantiateConfigurationBean(Configuration.class, (String[])new String[]{"tiger"}).orElseGet(Configuration::new);
        for (CfgServer cfgServer : configuration.getServers().values()) {
            if (!StringUtils.isNotEmpty((CharSequence)cfgServer.getTemplate())) continue;
            throw new TigerConfigurationException("Could not resolve template '" + cfgServer.getTemplate() + "'");
        }
        return configuration;
    }

    private static void addDefaults() {
        TigerGlobalConfiguration.putValue((String)"tiger.tigerProxy.parsingShouldBlockCommunication", (String)"true", (SourceType)SourceType.DEFAULTS);
    }

    private void assertNoCyclesInGraph() {
        this.servers.values().forEach(server -> this.cycleChecker((AbstractTigerServer)server, (Set<AbstractTigerServer>)new HashSet<AbstractTigerServer>()));
    }

    private void cycleChecker(AbstractTigerServer currentPosition, Set<AbstractTigerServer> visitedServer) {
        if (visitedServer.contains(currentPosition)) {
            throw new TigerEnvironmentStartupException("Cyclic graph detected in startup sequence: %s", visitedServer.stream().map(AbstractTigerServer::getServerId).collect(Collectors.toList()));
        }
        if (currentPosition.getDependUponList().isEmpty()) {
            return;
        }
        for (AbstractTigerServer server : currentPosition.getDependUponList()) {
            HashSet<AbstractTigerServer> newSet = new HashSet<AbstractTigerServer>(visitedServer);
            newSet.add(currentPosition);
            this.cycleChecker(server, newSet);
        }
    }

    private void createServerObjects() {
        for (Map.Entry serverEntry : this.configuration.getServers().entrySet()) {
            if (!((CfgServer)serverEntry.getValue()).isActive()) continue;
            AbstractTigerServer server = this.createServer((String)serverEntry.getKey(), (CfgServer)serverEntry.getValue());
            this.servers.put((String)serverEntry.getKey(), server);
            server.registerNewListener(this);
        }
    }

    public AbstractTigerServer createServer(String serverId, CfgServer config) {
        if (config.getType() == null) {
            throw new TigerTestEnvException("Unable to instantiate server of null type! Please check your config");
        }
        try {
            String serverType = config.getType().value();
            if (!this.serverClasses.containsKey(serverType)) {
                throw new TigerTestEnvException("No server class registered for type " + serverType + " used in server " + serverId);
            }
            return this.serverClasses.get(serverType).getDeclaredConstructor(TigerTestEnvMgr.class, String.class, CfgServer.class).newInstance(this, serverId, config);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
            if (e.getCause() != null) {
                if (e.getCause() instanceof TigerConfigurationException) {
                    throw (TigerConfigurationException)e.getCause();
                }
                if (e.getCause() instanceof TigerTestEnvException) {
                    throw (TigerTestEnvException)e.getCause();
                }
            }
            throw new TigerTestEnvException(e, "Unable to instantiate server of type %s, does it have a constructor(TigerTestenvMgr, String, CfgServer)?", config.getType().value());
        }
    }

    public void setUpEnvironment() {
        this.setUpEnvironment(Optional.empty());
    }

    public void setUpEnvironment(Optional<IRbelMessageListener> localTigerProxyMessageListener) {
        this.assertNoCyclesInGraph();
        this.assertNoUnknownServersInDependencies();
        this.startLocalTigerProxyIfActivated();
        localTigerProxyMessageListener.ifPresent(provider -> this.getLocalTigerProxyOptional().ifPresent(proxy -> proxy.addRbelMessageListener(provider)));
        Map<String, TigerServerStatusUpdate> activeServers = this.servers.values().stream().filter(server -> server.getConfiguration().isActive()).collect(Collectors.toMap(AbstractTigerServer::getServerId, server -> TigerServerStatusUpdate.builder().type(server.getConfiguration().getType().value()).status(TigerServerStatus.NEW).build()));
        this.getFixedPoolExecutor().submit(() -> this.listeners.parallelStream().forEach(listener -> listener.receiveTestEnvUpdate(TigerStatusUpdate.builder().serverUpdate(new LinkedHashMap<String, TigerServerStatusUpdate>(activeServers)).build())));
        List initialServersToBoot = this.servers.values().parallelStream().filter(server -> server.getDependUponList().isEmpty()).collect(Collectors.toList());
        log.info("Booting following server(s): {}", initialServersToBoot.stream().map(AbstractTigerServer::getHostname).collect(Collectors.toList()));
        initialServersToBoot.parallelStream().forEach(this::startServer);
        if (this.isLocalTigerProxyActive()) {
            this.localTigerProxy.subscribeToTrafficEndpoints(this.configuration.getTigerProxy());
        }
        log.info(Ansi.colorize((String)"Finished set up test environment OK", (RbelAnsiColors)RbelAnsiColors.GREEN_BOLD));
    }

    private void assertNoUnknownServersInDependencies() {
        this.getServers().values().forEach(AbstractTigerServer::getDependUponList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServer(AbstractTigerServer server) {
        try {
            if (this.isShuttingDown) {
                log.warn("Aborting startup of {}, already shutting down!", (Object)server.getServerId());
                return;
            }
            AbstractTigerServer abstractTigerServer = server;
            synchronized (abstractTigerServer) {
                if (server.getStatus() != TigerServerStatus.NEW) {
                    return;
                }
                server.start(this);
            }
            this.cachedExecutor.submit(() -> this.servers.values().parallelStream().peek(toBeStartedServer -> log.debug("Considering to start server {} with status {}...", (Object)toBeStartedServer.getServerId(), (Object)toBeStartedServer.getStatus())).filter(candidate -> candidate.getStatus() == TigerServerStatus.NEW).filter(candidate -> candidate.getDependUponList().stream().filter(depending -> depending.getStatus() != TigerServerStatus.RUNNING).findAny().isEmpty()).peek(toBeStartedServer -> log.info("Starting server {} with status {}", (Object)toBeStartedServer.getServerId(), (Object)toBeStartedServer.getStatus())).forEach(this::startServer)).get();
        }
        catch (RuntimeException e) {
            this.shutDown();
            throw e;
        }
        catch (ExecutionException e) {
            throw new TigerEnvironmentStartupException("Error during server startup", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TigerTestEnvException("Interrupt received while starting servers", e);
        }
    }

    public String replaceSysPropsInString(String str) {
        return str;
    }

    public synchronized void shutDown() {
        if (this.isShuttingDown) {
            return;
        }
        this.isShuttingDown = true;
        log.info(Ansi.colorize((String)"Shutting down all servers...", (RbelAnsiColors)RbelAnsiColors.RED_BOLD));
        for (AbstractTigerServer server : this.servers.values()) {
            try {
                server.shutdown();
            }
            catch (RuntimeException e) {
                log.warn("Exception while shutting down server " + server.getServerId(), (Throwable)e);
            }
        }
        log.info(Ansi.colorize((String)"Sending shutdown to executor pool...", (RbelAnsiColors)RbelAnsiColors.RED_BOLD));
        this.cachedExecutor.shutdownNow();
        this.fixedPoolExecutor.shutdownNow();
        if (this.localTigerProxy != null) {
            log.info(Ansi.colorize((String)"Shutting down local tiger proxy...", (RbelAnsiColors)RbelAnsiColors.RED_BOLD));
            this.localTigerProxy.shutdown();
        }
        if (this.localTigerProxyApplicationContext != null) {
            this.localTigerProxyApplicationContext.close();
            this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().type(LOCAL_TIGER_PROXY_TYPE).status(TigerServerStatus.STOPPED).statusMessage("Local Tiger Proxy stopped").build());
            log.info(Ansi.colorize((String)"Local tiger proxy SHUTDOWN...", (RbelAnsiColors)RbelAnsiColors.RED_BOLD));
        }
        log.info(Ansi.colorize((String)"Finished shutdown test environment OK", (RbelAnsiColors)RbelAnsiColors.RED_BOLD));
        this.isShutDown = true;
    }

    @Override
    public void receiveTestEnvUpdate(TigerStatusUpdate statusUpdate) {
        this.listeners.forEach(listener -> listener.receiveTestEnvUpdate(statusUpdate));
    }

    public List<TigerRoute> getRoutes() {
        return this.servers.values().stream().map(AbstractTigerServer::getRoutes).flatMap(Collection::stream).collect(Collectors.toUnmodifiableList());
    }

    public Optional<AbstractTigerServer> findServer(String serverName) {
        return Optional.ofNullable(this.servers.get(serverName));
    }

    @Deprecated(since="1.1.1", forRemoval=true)
    public TigerProxy getLocalTigerProxy() {
        return this.localTigerProxy;
    }

    public TigerProxy getLocalTigerProxyOrFail() {
        if (this.localTigerProxy == null) {
            if (this.isLocalTigerProxyActive()) {
                throw new TigerTestEnvException("Local Tiger Proxy is not activated!");
            }
            throw new TigerTestEnvException("Local Tiger Proxy is null!");
        }
        return this.localTigerProxy;
    }

    public Optional<TigerProxy> getLocalTigerProxyOptional() {
        if (this.localTigerProxy == null) {
            return Optional.empty();
        }
        return Optional.of(this.localTigerProxy);
    }

    public boolean isLocalTigerProxyActive() {
        if (this.configuration == null) {
            return true;
        }
        return this.configuration.isLocalProxyActive();
    }

    public ExecutorService getExecutor() {
        return this.cachedExecutor;
    }

    @Override
    public void registerNewListener(TigerUpdateListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void registerLogListener(TigerServerLogListener listener) {
        this.logListeners.add(listener);
    }

    public void receivedUserAcknowledgementForShutdown() {
        this.userAcknowledgedShutdown = true;
    }

    public void receivedResumeTestRunExecution() {
        this.userAcknowledgedContinueTestRun = true;
    }

    public void receivedCancelTestRunExecution() {
        this.userAcknowledgedFailingTestRun = true;
    }

    public void resetUserInput() {
        this.userAcknowledgedContinueTestRun = false;
        this.userAcknowledgedFailingTestRun = false;
    }

    public void destroy() throws Exception {
        this.shutDown();
    }

    @Override
    public void close() throws Exception {
        this.shutDown();
    }

    @Generated
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public Map<String, Object> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Generated
    public List<TigerRoute> getRoutesList() {
        return this.routesList;
    }

    @Generated
    public Map<String, AbstractTigerServer> getServers() {
        return this.servers;
    }

    @Generated
    public ExecutorService getCachedExecutor() {
        return this.cachedExecutor;
    }

    @Generated
    public ExecutorService getFixedPoolExecutor() {
        return this.fixedPoolExecutor;
    }

    @Generated
    public List<TigerUpdateListener> getListeners() {
        return this.listeners;
    }

    @Generated
    public List<TigerServerLogListener> getLogListeners() {
        return this.logListeners;
    }

    @Generated
    public DownloadManager getDownloadManager() {
        return this.downloadManager;
    }

    @Generated
    public ServletWebServerApplicationContext getLocalTigerProxyApplicationContext() {
        return this.localTigerProxyApplicationContext;
    }

    @Generated
    public boolean isUserAcknowledgedShutdown() {
        return this.userAcknowledgedShutdown;
    }

    @Generated
    public boolean isUserAcknowledgedContinueTestRun() {
        return this.userAcknowledgedContinueTestRun;
    }

    @Generated
    public boolean isUserAcknowledgedFailingTestRun() {
        return this.userAcknowledgedFailingTestRun;
    }

    @Generated
    public boolean isShuttingDown() {
        return this.isShuttingDown;
    }

    @Generated
    public Map<String, Class<? extends AbstractTigerServer>> getServerClasses() {
        return this.serverClasses;
    }

    @Generated
    public Logger getLocalProxyLog() {
        return this.localProxyLog;
    }

    @Generated
    public boolean isShutDown() {
        return this.isShutDown;
    }

    @Generated
    public void setWorkflowUiSentFetch(boolean workflowUiSentFetch) {
        this.workflowUiSentFetch = workflowUiSentFetch;
    }

    @Generated
    public boolean isWorkflowUiSentFetch() {
        return this.workflowUiSentFetch;
    }
}

