/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.test.tiger.common.data.config.tigerProxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.common.util.TigerSerializationUtil;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.TigerProxyApplication;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.config.tigerProxyStandalone.CfgStandaloneProxy;
import de.gematik.test.tiger.testenvmgr.env.TigerServerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.servers.AbstractExternalTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.AbstractTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerStatus;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerType;
import de.gematik.test.tiger.testenvmgr.servers.log.TigerServerLogManager;
import de.gematik.test.tiger.testenvmgr.util.TigerTestEnvException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.SocketUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@TigerServerType(value="tigerProxy")
public class TigerProxyServer
extends AbstractExternalTigerServer {
    private ConfigurableApplicationContext applicationContext;

    public TigerProxyServer(TigerTestEnvMgr tigerTestEnvMgr, String serverId, CfgServer configuration) {
        super(TigerProxyServer.determineHostname((CfgServer)configuration, (String)serverId), serverId, configuration, tigerTestEnvMgr);
    }

    public void assertThatConfigurationIsCorrect() {
        super.assertThatConfigurationIsCorrect();
        if (this.getConfiguration().getTigerProxyCfg() == null) {
            this.getConfiguration().setTigerProxyCfg(new TigerProxyConfiguration());
        }
        if (this.getConfiguration().getTigerProxyCfg().getAdminPort() <= 0) {
            this.getConfiguration().getTigerProxyCfg().setAdminPort(SocketUtils.findAvailableTcpPort());
        }
        if (this.getConfiguration().getTigerProxyCfg().getProxyPort() == null || this.getConfiguration().getTigerProxyCfg().getProxyPort() <= 0) {
            throw new TigerTestEnvException("Missing proxy-port configuration for server '" + this.getServerId() + "'");
        }
    }

    public void performStartup() {
        this.log.info("Entering pre-startup of tiger-proxy {}", (Object)this.getServerId());
        this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().statusMessage("Pre-start Tiger Proxy " + this.getServerId()).build());
        TigerProxyConfiguration reverseProxyCfg = this.getConfiguration().getTigerProxyCfg();
        CfgStandaloneProxy standaloneCfg = new CfgStandaloneProxy();
        standaloneCfg.setTigerProxy(reverseProxyCfg);
        if (reverseProxyCfg.getProxyRoutes() == null) {
            reverseProxyCfg.setProxyRoutes(new ArrayList());
        }
        if (reverseProxyCfg.getProxiedServer() != null) {
            this.getDestinationUrlFromProxiedServer(reverseProxyCfg);
        }
        reverseProxyCfg.getProxyRoutes().forEach(route -> {
            route.setFrom(this.getTigerTestEnvMgr().replaceSysPropsInString(route.getFrom()));
            route.setTo(this.getTigerTestEnvMgr().replaceSysPropsInString(route.getTo()));
        });
        if (this.getTigerTestEnvMgr().isShuttingDown()) {
            this.log.debug("Skipping startup, already shutting down...");
            this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().statusMessage("Skipped startup of Tiger Proxy " + this.getServerId()).build());
            return;
        }
        this.log.info("Actually performing startup of tiger-proxy {}", (Object)this.getServerId());
        this.statusMessage("Starting Tiger Proxy " + this.getServerId() + " at " + reverseProxyCfg.getAdminPort() + "...");
        this.applicationContext = new SpringApplicationBuilder(new Class[0]).bannerMode(Banner.Mode.OFF).properties(new HashMap(TigerSerializationUtil.toMap((Object)standaloneCfg, (String[])new String[0]))).sources(new Class[]{TigerProxyApplication.class}).web(WebApplicationType.SERVLET).registerShutdownHook(false).initializers(new ApplicationContextInitializer[0]).run(new String[0]);
        TigerServerLogManager.addProxyCustomerAppender((TigerProxyServer)this);
        this.waitForServerUp();
        this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().baseUrl("http://localhost:" + ((ServletWebServerApplicationContext)this.applicationContext).getWebServer().getPort() + "/webui").build());
    }

    public void shutdown() {
        this.log.info("Stopping tiger proxy {}...", (Object)this.getServerId());
        if (this.applicationContext != null && this.applicationContext.isRunning()) {
            this.log.info("Triggering tiger-server shutdown for {}...", (Object)this.getServerId());
            this.applicationContext.close();
            this.setStatus(TigerServerStatus.STOPPED, "Stopped Tiger Proxy " + this.getServerId());
        } else {
            this.log.info("Skipping tiger-server shutdown for {}!", (Object)this.getServerId());
            this.setStatus(TigerServerStatus.STOPPED, "Tiger Proxy " + this.getServerId() + " already stopped");
        }
    }

    private void getDestinationUrlFromProxiedServer(TigerProxyConfiguration cfg) {
        String destUrl = this.getTigerTestEnvMgr().getServers().keySet().stream().filter(srvid -> srvid.equals(cfg.getProxiedServer())).findAny().map(srvid -> (AbstractTigerServer)this.getTigerTestEnvMgr().getServers().get(srvid)).map(srv -> srv.getDestinationUrl(cfg.getProxiedServerProtocol())).orElseThrow(() -> new TigerTestEnvException("Proxied server '" + cfg.getProxiedServer() + "' not found in list!"));
        TigerRoute tigerRoute = new TigerRoute();
        tigerRoute.setFrom("/");
        tigerRoute.setTo(destUrl);
        cfg.getProxyRoutes().add(tigerRoute);
    }

    Optional<String> getHealthcheckUrl() {
        return Optional.of("http://127.0.0.1:" + this.getConfiguration().getTigerProxyCfg().getAdminPort());
    }

    boolean isHealthCheckNone() {
        return false;
    }

    public TigerProxy getTigerProxy() {
        return (TigerProxy)this.applicationContext.getBean(TigerProxy.class);
    }
}

