/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.data.config.CfgExternalJarOptions;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.env.TigerServerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.servers.AbstractExternalTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.ExternalJarServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerStatus;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerType;
import de.gematik.test.tiger.testenvmgr.servers.log.TigerStreamLogFeeder;
import de.gematik.test.tiger.testenvmgr.util.TigerEnvironmentStartupException;
import de.gematik.test.tiger.testenvmgr.util.TigerTestEnvException;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.event.Level;

/*
 * Exception performing whole class analysis ignored.
 */
@TigerServerType(value="externalJar")
public class ExternalJarServer
extends AbstractExternalTigerServer {
    public static final String LOCAL = "local:";
    private final AtomicReference<Process> processReference = new AtomicReference();
    private File jarFile;
    private LocalDateTime processStartTime;

    public ExternalJarServer(TigerTestEnvMgr tigerTestEnvMgr, String serverId, CfgServer configuration) {
        super(ExternalJarServer.determineHostname((CfgServer)configuration, (String)serverId), serverId, configuration, tigerTestEnvMgr);
    }

    public void assertThatConfigurationIsCorrect() {
        String folder;
        super.assertThatConfigurationIsCorrect();
        this.assertCfgPropertySet((Object)this.getConfiguration(), new String[]{"source"});
        if (this.getConfiguration().getExternalJarOptions() == null) {
            folder = new File(".").getAbsolutePath();
            this.log.info("Defaulting to current working folder '{}' as working directory for server {}", (Object)folder, (Object)this.getServerId());
        } else {
            folder = this.getConfiguration().getExternalJarOptions().getWorkingDir();
            if (folder == null) {
                if (((String)this.getConfiguration().getSource().get(0)).startsWith("local:")) {
                    String jarPath = ((String)this.getConfiguration().getSource().get(0)).split("local:")[1];
                    folder = Paths.get(jarPath, new String[0]).toAbsolutePath().getParent().toString();
                    this.getConfiguration().getSource().add(0, "local:" + jarPath.substring(jarPath.lastIndexOf(47)));
                    this.log.info("Defaulting to parent folder '{}' as working directory for server {}", (Object)folder, (Object)this.getServerId());
                } else {
                    folder = Path.of(System.getProperty("java.io.tmpdir"), "tiger_ls").toFile().getAbsolutePath();
                    this.log.info("Defaulting to temp folder '{}' as working directory for server {}", (Object)folder, (Object)this.getServerId());
                }
            }
        }
        this.getConfiguration().getExternalJarOptions().setWorkingDir(folder);
        File f = new File(folder);
        if (!f.exists() && !f.mkdirs()) {
            throw new TigerTestEnvException("Unable to create working dir folder " + f.getAbsolutePath());
        }
        this.assertCfgPropertySet((Object)this.getConfiguration(), new String[]{"healthcheckUrl"});
    }

    public void performStartup() {
        CfgExternalJarOptions externalJarOptions = this.getConfiguration().getExternalJarOptions();
        String workingDir = externalJarOptions != null ? this.getConfiguration().getExternalJarOptions().getWorkingDir() : new File(".").getAbsolutePath();
        this.setStatus(TigerServerStatus.STARTING, "Starting external jar instance " + this.getServerId() + " in folder '" + workingDir + "'...");
        String jarUrl = (String)this.getConfiguration().getSource().get(0);
        this.jarFile = this.getTigerTestEnvMgr().getDownloadManager().downloadJarAndReturnFile(this, jarUrl, workingDir);
        ArrayList<String> options = new ArrayList<String>();
        String javaExe = this.findJavaExecutable();
        options.add(javaExe);
        if (externalJarOptions != null && externalJarOptions.getOptions() != null) {
            options.addAll(externalJarOptions.getOptions().stream().map(arg_0 -> ((TigerTestEnvMgr)this.getTigerTestEnvMgr()).replaceSysPropsInString(arg_0)).collect(Collectors.toList()));
        }
        options.add("-jar");
        options.add(this.jarFile.getName());
        if (externalJarOptions != null && externalJarOptions.getArguments() != null) {
            options.addAll(externalJarOptions.getArguments());
        }
        this.statusMessage("Running '" + String.join((CharSequence)" ", options) + "' in folder '" + new File(workingDir).getAbsolutePath() + "'");
        this.processStartTime = LocalDateTime.now();
        this.getTigerTestEnvMgr().getExecutor().submit(() -> {
            try {
                this.statusMessage("Starting Jar process for " + this.getServerId());
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command((String[])options.toArray(String[]::new)).directory(new File(workingDir)).redirectErrorStream(true);
                this.applyEnvPropertiesToProcess(processBuilder);
                this.processReference.set(processBuilder.start());
                new TigerStreamLogFeeder(this.log, ((Process)this.processReference.get()).getInputStream(), Level.INFO);
                new TigerStreamLogFeeder(this.log, ((Process)this.processReference.get()).getErrorStream(), Level.ERROR);
                this.statusMessage("Started JAR-File for " + this.getServerId() + " with PID '" + ((Process)this.processReference.get()).pid() + "'");
            }
            catch (Throwable t) {
                this.log.error("Failed to start process", t);
                this.startupException.set(t);
            }
            this.log.debug("Proc set in atomic var {}", this.processReference.get());
        });
        if (this.isHealthCheckNone()) {
            this.log.warn("Healthcheck for {} is not configured, so unable to add route to local proxy!", (Object)this.getServerId());
        } else {
            this.addServerToLocalProxyRouteMap(this.buildHealthcheckUrl());
            this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().baseUrl(this.extractBaseUrl(this.buildHealthcheckUrl())).build());
        }
        if (this.startupException.get() != null) {
            throw new TigerTestEnvException("Unable to start external jar '" + this.getServerId() + "'!", (Throwable)this.startupException.get());
        }
        this.waitForServerUp();
    }

    public TigerServerStatus updateStatus(boolean quiet) {
        if (!((Process)this.processReference.get()).isAlive()) {
            this.log.warn("Process {} for {} is stopped!", (Object)((Process)this.processReference.get()).pid(), (Object)this.getServerId());
            this.setStatus(TigerServerStatus.STOPPED, "Jar process for " + this.getServerId() + " stopped unexpectedly");
            if (LocalDateTime.now().isBefore(this.processStartTime.plusSeconds(3L))) {
                this.log.warn("{}: Unusually short process run time ({})! Suspecting defunct jar! (Exitcode={})", new Object[]{this.getServerId(), Duration.between(LocalDateTime.now(), this.processStartTime), ((Process)this.processReference.get()).exitValue()});
                this.cleanupDefunctJar();
            }
            return this.getStatus();
        }
        return super.updateStatus(false);
    }

    private void cleanupDefunctJar() {
        if (!((String)this.getConfiguration().getSource().get(0)).startsWith("local:") && this.jarFile.exists() && !this.jarFile.delete()) {
            this.log.warn("Unable to delete jar file {}", (Object)this.jarFile.getAbsolutePath());
        }
    }

    public void shutdown() {
        this.log.info("Stopping external jar {}...", (Object)this.getServerId());
        this.removeAllRoutes();
        this.stopExternalProcess();
    }

    private void stopExternalProcess() {
        if (this.processReference.get() != null) {
            this.log.info("Stopping external process (pid={})", (Object)((Process)this.processReference.get()).pid());
            this.log.info("Interrupting threads...");
            ((Process)this.processReference.get()).destroy();
            this.log.info("Stopping threads...");
            ((Process)this.processReference.get()).destroyForcibly();
            this.setStatus(TigerServerStatus.STOPPED, "Jar process for " + this.getServerId() + " stopped");
        } else {
            this.setStatus(TigerServerStatus.STOPPED, "No Jar process for " + this.getServerId() + " found");
        }
    }

    private String findJavaExecutable() {
        String javaHomeDirectory = (String)TigerGlobalConfiguration.readStringOptional((String)"tiger.lib.javaHome").or(() -> TigerGlobalConfiguration.readStringOptional((String)"java.home")).orElseThrow(() -> new TigerEnvironmentStartupException("Could not determine java-home. Expected either 'tiger.lib.javaHome' oder 'java.home' to be set, but neither was!"));
        if (System.getProperty("os.name").startsWith("Win")) {
            return javaHomeDirectory + File.separator + "bin" + File.separator + "java.exe";
        }
        return javaHomeDirectory + File.separator + "bin" + File.separator + "java";
    }

    @Generated
    public static ExternalJarServerBuilder builder() {
        return new ExternalJarServerBuilder();
    }
}

