/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.test.tiger.common.config.SourceType;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.data.config.CfgDockerOptions;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.env.DockerMgr;
import de.gematik.test.tiger.testenvmgr.servers.AbstractTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.DockerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerStatus;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerType;
import de.gematik.test.tiger.testenvmgr.util.TigerEnvironmentStartupException;
import de.gematik.test.tiger.testenvmgr.util.TigerTestEnvException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@TigerServerType(value="docker")
public class DockerServer
extends AbstractTigerServer {
    public static final DockerMgr dockerManager = new DockerMgr();

    public DockerServer(TigerTestEnvMgr tigerTestEnvMgr, String serverId, CfgServer configuration) {
        super(DockerServer.determineHostname((CfgServer)configuration, (String)serverId), serverId, tigerTestEnvMgr, configuration);
    }

    public void assertThatConfigurationIsCorrect() {
        super.assertThatConfigurationIsCorrect();
        this.assertCfgPropertySet((Object)this.getConfiguration(), new String[]{"version"});
        this.assertCfgPropertySet((Object)this.getConfiguration(), new String[]{"source"});
    }

    public void performStartup() {
        this.statusMessage("Starting docker container for " + this.getServerId() + " from '" + this.getDockerSource() + "'");
        dockerManager.startContainer(this);
        if (this.getConfiguration().getDockerOptions().getPorts() != null && !this.getConfiguration().getDockerOptions().getPorts().isEmpty()) {
            this.addRoute(TigerRoute.builder().from("http://" + this.getHostname()).to("http://localhost:" + this.getConfiguration().getDockerOptions().getPorts().values().iterator().next()).build());
        }
        this.statusMessage("Docker container " + this.getServerId() + " started");
    }

    protected void processExports() {
        super.processExports();
        if (this.getConfiguration().getDockerOptions().getPorts() != null && !this.getConfiguration().getDockerOptions().getPorts().isEmpty()) {
            this.getConfiguration().getExports().forEach(exp -> {
                String origValue;
                String[] kvp = exp.split("=", 2);
                kvp[1] = origValue = TigerGlobalConfiguration.readString((String)kvp[0]);
                if (this.getConfiguration().getDockerOptions().getPorts() != null) {
                    this.getConfiguration().getDockerOptions().getPorts().forEach((localPort, externPort) -> {
                        kvp[1] = kvp[1].replace("${PORT:" + localPort + "}", String.valueOf(externPort));
                    });
                }
                if (!origValue.equals(kvp[1])) {
                    this.log.info("Setting global property {}={}", (Object)kvp[0], (Object)kvp[1]);
                    TigerGlobalConfiguration.putValue((String)kvp[0], (String)kvp[1], (SourceType)SourceType.RUNTIME_EXPORT);
                }
            });
        }
    }

    public String getDockerSource() {
        return (String)this.getConfiguration().getSource().get(0);
    }

    public CfgDockerOptions getDockerOptions() {
        return this.getConfiguration().getDockerOptions();
    }

    public void shutdown() {
        this.log.info("Stopping docker container {}...", (Object)this.getServerId());
        this.removeAllRoutes();
        dockerManager.stopContainer((AbstractTigerServer)this);
        this.setStatus(TigerServerStatus.STOPPED, "Docker container " + this.getServerId() + " stopped");
    }

    public String getDestinationUrl(String fallbackProtocol) {
        try {
            URIBuilder uriBuilder = new URIBuilder(this.guessAServerUrl()).setPath("");
            if (StringUtils.isNotEmpty((CharSequence)fallbackProtocol)) {
                uriBuilder.setScheme(fallbackProtocol);
            }
            return uriBuilder.build().toURL().toString();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new TigerEnvironmentStartupException("Unable to build destination URL", e);
        }
    }

    private String guessAServerUrl() {
        if (StringUtils.isNotEmpty((CharSequence)this.getConfiguration().getHealthcheckUrl())) {
            return this.getConfiguration().getHealthcheckUrl();
        }
        if (this.getStatus() != TigerServerStatus.RUNNING) {
            throw new TigerTestEnvException("If reverse proxy is to be used with docker container '" + this.getServerId() + "' make sure to start it first or have a valid healthcheck setting!");
        }
        return "http://127.0.0.1:" + this.getConfiguration().getDockerOptions().getPorts().values().iterator().next();
    }

    @Generated
    public static DockerServerBuilder builder() {
        return new DockerServerBuilder();
    }
}

