/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.data.config.CfgDockerOptions;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.servers.AbstractTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.DockerComposeServer;
import de.gematik.test.tiger.testenvmgr.servers.DockerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerStatus;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerType;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@TigerServerType(value="compose")
public class DockerComposeServer
extends AbstractTigerServer {
    public DockerComposeServer(TigerTestEnvMgr tigerTestEnvMgr, String serverId, CfgServer configuration) {
        super("", serverId, tigerTestEnvMgr, configuration);
        if (!StringUtils.isBlank((CharSequence)configuration.getHostname())) {
            throw new TigerConfigurationException("Hostname property is not supported for docker compose nodes!");
        }
    }

    public void assertThatConfigurationIsCorrect() {
        super.assertThatConfigurationIsCorrect();
        if (StringUtils.isNotBlank((CharSequence)this.getHostname())) {
            throw new TigerConfigurationException("Docker compose does not support a hostname for the node!");
        }
        this.assertCfgPropertySet((Object)this.getConfiguration(), new String[]{"source"});
    }

    public void performStartup() {
        this.statusMessage("Starting docker compose for " + this.getServerId() + " from " + this.getDockerSource());
        DockerServer.dockerManager.startComposition(this);
        this.statusMessage("Docker compose " + this.getServerId() + " started");
    }

    public String getDockerSource() {
        return (String)this.getConfiguration().getSource().get(0);
    }

    public CfgDockerOptions getDockerOptions() {
        return this.getConfiguration().getDockerOptions();
    }

    public List<String> getSource() {
        if (this.getConfiguration().getSource() == null) {
            return List.of();
        }
        return Collections.unmodifiableList(this.getConfiguration().getSource());
    }

    public void shutdown() {
        this.log.info("Stopping docker compose {}...", (Object)this.getServerId());
        this.removeAllRoutes();
        this.setStatus(TigerServerStatus.STOPPED, "Docker compose " + this.getServerId() + " stopped");
    }

    @Generated
    public static DockerComposeServerBuilder builder() {
        return new DockerComposeServerBuilder();
    }
}

