/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.test.tiger.common.Ansi;
import de.gematik.test.tiger.common.config.SourceType;
import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.data.config.PkiType;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.common.pki.KeyMgr;
import de.gematik.test.tiger.common.util.TigerSerializationUtil;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.env.TigerEnvUpdateSender;
import de.gematik.test.tiger.testenvmgr.env.TigerServerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.env.TigerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.env.TigerUpdateListener;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerLogListener;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerStatus;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerType;
import de.gematik.test.tiger.testenvmgr.servers.log.TigerServerLogManager;
import de.gematik.test.tiger.testenvmgr.util.TigerEnvironmentStartupException;
import de.gematik.test.tiger.testenvmgr.util.TigerTestEnvException;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTigerServer
implements TigerEnvUpdateSender {
    public static final int DEFAULT_STARTUP_TIMEOUT_IN_SECONDS = 20;
    private final String hostname;
    private final String serverId;
    private final List<String> environmentProperties = new ArrayList();
    private final List<TigerRoute> routes = new ArrayList();
    private final TigerTestEnvMgr tigerTestEnvMgr;
    private final List<TigerUpdateListener> listeners = new ArrayList();
    private final List<TigerServerLogListener> logListeners = new ArrayList();
    private CfgServer configuration;
    private TigerServerStatus status = TigerServerStatus.NEW;
    protected final Logger log;

    protected AbstractTigerServer(String hostname, String serverId, TigerTestEnvMgr tigerTestEnvMgr, CfgServer configuration) {
        this.hostname = hostname;
        this.serverId = serverId;
        this.tigerTestEnvMgr = tigerTestEnvMgr;
        this.configuration = configuration;
        this.log = LoggerFactory.getLogger((String)("TgrSrv-" + serverId));
        TigerServerLogManager.addAppenders((AbstractTigerServer)this);
    }

    public String getServerTypeToken() {
        try {
            return this.getClass().getAnnotation(TigerServerType.class).value();
        }
        catch (NullPointerException npe) {
            throw new TigerTestEnvException("Server class " + this.getClass() + " has no " + TigerServerType.class.getCanonicalName() + " Annotation!");
        }
    }

    static String determineHostname(CfgServer configuration, String serverId) {
        if (StringUtils.isNotBlank((CharSequence)configuration.getHostname())) {
            return configuration.getHostname();
        }
        return serverId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(TigerTestEnvMgr testEnvMgr) {
        AbstractTigerServer abstractTigerServer = this;
        synchronized (abstractTigerServer) {
            if (this.getStatus() != TigerServerStatus.NEW) {
                throw new TigerEnvironmentStartupException("Server %s was already started!", new Object[]{this.getServerId()});
            }
        }
        this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().type(this.getServerTypeToken()).status(TigerServerStatus.STARTING).statusMessage("Checking configuration " + this.getServerId() + "...").build());
        this.reloadConfiguration();
        this.assertThatConfigurationIsCorrect();
        this.configuration.getEnvironment().stream().map(arg_0 -> ((TigerTestEnvMgr)testEnvMgr).replaceSysPropsInString(arg_0)).forEach(this.environmentProperties::add);
        if (this.configuration.getUrlMappings() != null) {
            this.statusMessage("Adding routes to local tiger proxy for server " + this.getServerId() + "...");
            this.configuration.getUrlMappings().forEach(mapping -> {
                if (StringUtils.isBlank((CharSequence)mapping) || !mapping.contains("-->") || mapping.split(" --> ", 2).length != 2) {
                    throw new TigerConfigurationException("The urlMappings configuration '" + mapping + "' is not correct. Please check your .yaml-file.");
                }
                String[] routeParts = mapping.split(" --> ", 2);
                testEnvMgr.getLocalTigerProxy().addRoute(TigerRoute.builder().from(routeParts[0]).to(routeParts[1]).build());
            });
        }
        this.loadPkiForProxy();
        try {
            this.performStartup();
        }
        catch (Throwable t) {
            this.log.warn(String.format(t.getClass().getSimpleName() + " during startup of server %s. Used configuration was %s", this.getServerId(), TigerSerializationUtil.toJson((Object)this.getConfiguration())), t);
            throw t;
        }
        this.statusMessage(this.getServerId() + " started");
        this.processExports();
        abstractTigerServer = this;
        synchronized (abstractTigerServer) {
            this.setStatus(TigerServerStatus.RUNNING, this.getServerId() + " READY");
        }
    }

    private void reloadConfiguration() {
        try {
            this.configuration = (CfgServer)TigerGlobalConfiguration.instantiateConfigurationBean(CfgServer.class, (String[])new String[]{"tiger", "servers", this.getServerId()}).orElseThrow(() -> new TigerEnvironmentStartupException("Could not reload configuration for server with id %s", new Object[]{this.getServerId()}));
            this.tigerTestEnvMgr.getConfiguration().getServers().put(this.getServerId(), this.configuration);
        }
        catch (TigerConfigurationException e) {
            this.log.warn("Could not reload configuration for server {}", (Object)this.getServerId(), (Object)e);
        }
    }

    private void loadPkiForProxy() {
        if (!this.getConfiguration().getPkiKeys().isEmpty()) {
            this.log.info("Loading PKI resources for instance {}...", (Object)this.getServerId());
        }
        this.getConfiguration().getPkiKeys().stream().filter(key -> key.getType() == PkiType.Certificate).forEach(key -> {
            if (StringUtils.isBlank((CharSequence)key.getPem())) {
                throw new TigerConfigurationException("Your certificate is empty, please check your .yaml-file for " + key.getId());
            }
            this.log.info("Adding certificate {}", (Object)key.getId());
            this.getTigerTestEnvMgr().getLocalTigerProxy().addKey(key.getId(), (Key)KeyMgr.readCertificateFromPem((String)("-----BEGIN CERTIFICATE-----\n" + key.getPem().replace(" ", "\n") + "\n-----END CERTIFICATE-----")).getPublicKey());
        });
        this.getConfiguration().getPkiKeys().stream().filter(key -> key.getType() == PkiType.Key).forEach(key -> {
            if (StringUtils.isBlank((CharSequence)key.getPem())) {
                throw new TigerConfigurationException("Your Key is empty, please check your .yaml-file for " + key.getId());
            }
            this.log.info("Adding key {}", (Object)key.getId());
            this.getTigerTestEnvMgr().getLocalTigerProxy().addKey(key.getId(), KeyMgr.readKeyFromPem((String)("-----BEGIN PRIVATE KEY-----\n" + key.getPem().replace(" ", "\n") + "\n-----END PRIVATE KEY-----")));
        });
    }

    public abstract void performStartup();

    protected void processExports() {
        this.configuration.getExports().forEach(exp -> {
            String[] kvp = exp.split("=", 2);
            kvp[1] = kvp[1].replace("${NAME}", this.getHostname());
            this.log.info("Setting global property {}={}", (Object)kvp[0], (Object)kvp[1]);
            TigerGlobalConfiguration.putValue((String)kvp[0], (String)kvp[1], (SourceType)SourceType.RUNTIME_EXPORT);
        });
    }

    public void assertThatConfigurationIsCorrect() {
        ((AbstractStringAssert)Assertions.assertThat((String)this.serverId).withFailMessage("Server Id must not be blank!", new Object[0])).isNotBlank();
        this.assertCfgPropertySet((Object)this.getConfiguration(), new String[]{"type"});
        if (this.getConfiguration().getStartupTimeoutSec() == null) {
            this.log.info("Defaulting startup timeout sec to 20sec for server {}", (Object)this.serverId);
            this.getConfiguration().setStartupTimeoutSec(Integer.valueOf(20));
        }
    }

    protected void assertCfgPropertySet(Object target, String ... propertyNames) {
        for (String propertyName : propertyNames) {
            Method mthd = target.getClass().getMethod("get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1), new Class[0]);
            if ((target = mthd.invoke(target, new Object[0])) == null) {
                throw new TigerTestEnvException("Server %s must have property %s be set and not be NULL!", new Object[]{this.getServerId(), propertyName});
            }
            if (target instanceof List) {
                this.assertListCfgPropertySet((List)target, propertyName);
                continue;
            }
            if (!(target instanceof String) || !((String)target).isBlank()) continue;
            throw new TigerTestEnvException("Server %s must have property %s be set and not be empty!", new Object[]{this.getServerId(), propertyName});
        }
    }

    private void assertListCfgPropertySet(List<?> target, String propertyName) {
        if (target.isEmpty() || target.get(0) == null) {
            throw new TigerTestEnvException("Server %s must have property %s be set and must contain at least one non empty entry", new Object[]{this.getServerId(), propertyName});
        }
        if (target.get(0) instanceof String && ((String)target.get(0)).isBlank()) {
            throw new TigerTestEnvException("Server %s must have property %s be set and contain at least one non empty entry!", new Object[]{this.getServerId(), propertyName});
        }
    }

    public Optional<Integer> getStartupTimeoutSec() {
        return Optional.ofNullable(this.configuration.getStartupTimeoutSec());
    }

    void addServerToLocalProxyRouteMap(URL url) {
        this.addRoute(TigerRoute.builder().from("http://" + this.getHostname()).to(this.extractBaseUrl(url)).build());
    }

    String extractBaseUrl(URL url) {
        try {
            int port = url.getPort();
            if (port == -1) {
                port = url.getDefaultPort();
            }
            return url.toURI().getScheme() + "://" + url.getHost() + ":" + port;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Error while convert to URI: '" + url + "'", e);
        }
    }

    void addRoute(TigerRoute newRoute) {
        this.getTigerTestEnvMgr().getLocalTigerProxy().addRoute(newRoute);
        this.routes.add(newRoute);
    }

    void removeAllRoutes() {
        this.log.info("Removing routes for {}...", (Object)this.getServerId());
        this.routes.stream().map(TigerRoute::getId).forEach(arg_0 -> ((TigerProxy)this.getTigerTestEnvMgr().getLocalTigerProxy()).removeRoute(arg_0));
    }

    public abstract void shutdown();

    public List<AbstractTigerServer> getDependUponList() {
        if (StringUtils.isBlank((CharSequence)this.getConfiguration().getDependsUpon())) {
            return List.of();
        }
        return Stream.of(this.getConfiguration().getDependsUpon().split(",")).filter(StringUtils::isNotBlank).map(String::trim).map(serverName -> (AbstractTigerServer)this.tigerTestEnvMgr.findServer(serverName).orElseThrow(() -> new TigerEnvironmentStartupException("Unknown server: '%s' in dependUponList of server '%s'", new Object[]{serverName, this.getServerId()}))).collect(Collectors.toUnmodifiableList());
    }

    public String getDestinationUrl(String fallbackProtocol) {
        throw new TigerTestEnvException("Sophisticated reverse proxy for '%s' is not supported!", new Object[]{this.getClass().getSimpleName()});
    }

    public void setStatus(TigerServerStatus newStatus) {
        this.setStatus(newStatus, null);
    }

    public void setStatus(TigerServerStatus newStatus, String statusMessage) {
        this.status = newStatus;
        this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().status(newStatus).statusMessage(statusMessage).build());
        if (statusMessage != null && this.log.isInfoEnabled()) {
            if (newStatus == TigerServerStatus.STOPPED) {
                this.log.info(Ansi.colorize((String)statusMessage, (RbelAnsiColors)RbelAnsiColors.RED_BOLD));
            } else {
                this.log.info(Ansi.colorize((String)statusMessage, (RbelAnsiColors)RbelAnsiColors.GREEN_BOLD));
            }
        }
    }

    public void registerNewListener(TigerUpdateListener listener) {
        this.listeners.add(listener);
    }

    public void registerLogListener(TigerServerLogListener listener) {
        this.logListeners.add(listener);
    }

    public void statusMessage(String statusMessage) {
        this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().statusMessage(statusMessage).build());
        if (this.log.isInfoEnabled()) {
            this.log.info(Ansi.colorize((String)statusMessage, (RbelAnsiColors)RbelAnsiColors.GREEN_BOLD));
        }
    }

    void publishNewStatusUpdate(TigerServerStatusUpdate update) {
        if (this.tigerTestEnvMgr.getExecutor() != null) {
            this.tigerTestEnvMgr.getExecutor().submit(() -> this.listeners.parallelStream().forEach(listener -> listener.receiveTestEnvUpdate(TigerStatusUpdate.builder().serverUpdate(new LinkedHashMap<String, TigerServerStatusUpdate>(Map.of(this.serverId, update))).build())));
        }
    }

    protected String findCommandInPath(String command) {
        if (System.getenv("PATH") == null) {
            throw new TigerEnvironmentStartupException("No PATH variable set, unable to find helm and kubectl commands!");
        }
        return Arrays.stream(System.getenv("PATH").split(File.pathSeparator)).map(folder -> folder + File.separator + command).filter(file -> new File((String)file).canExecute()).findFirst().orElseThrow(() -> new TigerEnvironmentStartupException("Unable to locate script '%s'", new Object[]{command}));
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public String getServerId() {
        return this.serverId;
    }

    @Generated
    public List<String> getEnvironmentProperties() {
        return this.environmentProperties;
    }

    @Generated
    public List<TigerRoute> getRoutes() {
        return this.routes;
    }

    @Generated
    public TigerTestEnvMgr getTigerTestEnvMgr() {
        return this.tigerTestEnvMgr;
    }

    @Generated
    public List<TigerUpdateListener> getListeners() {
        return this.listeners;
    }

    @Generated
    public List<TigerServerLogListener> getLogListeners() {
        return this.logListeners;
    }

    @Generated
    public CfgServer getConfiguration() {
        return this.configuration;
    }

    @Generated
    public TigerServerStatus getStatus() {
        return this.status;
    }

    @Generated
    public Logger getLog() {
        return this.log;
    }
}

