/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.test.tiger.common.Ansi;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.servers.AbstractTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerStatus;
import de.gematik.test.tiger.testenvmgr.util.InsecureTrustAllManager;
import de.gematik.test.tiger.testenvmgr.util.TigerEnvironmentStartupException;
import de.gematik.test.tiger.testenvmgr.util.TigerTestEnvException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;

public abstract class AbstractExternalTigerServer
extends AbstractTigerServer {
    protected final AtomicReference<Throwable> startupException = new AtomicReference();

    AbstractExternalTigerServer(String hostname, String serverId, CfgServer configuration, TigerTestEnvMgr tigerTestEnvMgr) {
        super(hostname, serverId, tigerTestEnvMgr, configuration);
    }

    protected void waitForServerUp() {
        if (this.getStatus() == TigerServerStatus.NEW) {
            this.setStatus(TigerServerStatus.STARTING);
        }
        this.waitForServiceHalfTime(true);
        String exMsg = "Unable to start %s '%s' (Status %s)!";
        if (this.startupException.get() != null) {
            throw new TigerTestEnvException((Throwable)this.startupException.get(), exMsg, new Object[]{this.getConfiguration().getType().value(), this.getServerId(), this.getStatus()});
        }
        if (this.getStatus() == TigerServerStatus.STOPPED) {
            throw new TigerTestEnvException(exMsg, new Object[]{this.getConfiguration().getType().value(), this.getServerId(), this.getStatus()});
        }
        if (this.getStatus() == TigerServerStatus.STARTING) {
            this.waitForServiceHalfTime(false);
            if (this.startupException.get() != null) {
                throw new TigerTestEnvException((Throwable)this.startupException.get(), exMsg, new Object[]{this.getConfiguration().getType().value(), this.getServerId(), this.getStatus()});
            }
            if (this.getStatus() != TigerServerStatus.RUNNING) {
                throw new TigerTestEnvException(exMsg, (Throwable)this.startupException.get());
            }
        }
        this.statusMessage(this.getConfiguration().getType().value() + " " + this.getServerId() + " started");
    }

    protected void waitForServiceHalfTime(boolean quiet) {
        block5: {
            long timeOutInMs = (long)this.getStartupTimeoutSec().orElse(20).intValue() * 1000L / 2L;
            if (this.isHealthCheckNone()) {
                this.waitForConfiguredTimeAndSetRunning(timeOutInMs);
            } else {
                if (!quiet) {
                    this.log.info("  Checking {} instance '{}' is available ...", (Object)this.getClass().getSimpleName(), (Object)this.getServerId());
                }
                try {
                    Awaitility.await().atMost(Math.max(timeOutInMs, 1000L), TimeUnit.MILLISECONDS).pollInterval(200L, TimeUnit.MILLISECONDS).until(() -> this.updateStatus(quiet) != TigerServerStatus.STARTING && this.getStatus() != TigerServerStatus.NEW);
                }
                catch (ConditionTimeoutException cte) {
                    if (quiet) break block5;
                    throw new TigerTestEnvException("Timeout waiting for external server '" + this.getServerId() + "' to respond at '" + this.getHealthcheckUrl().orElse("<null>") + "'!");
                }
            }
        }
    }

    public TigerServerStatus updateStatus(boolean quiet) {
        block11: {
            URL url = this.buildHealthcheckUrl();
            if (!quiet) {
                this.statusMessage("Waiting for URL '" + url + "' to be healthy...");
            }
            try {
                this.checkUrlOrThrowException(url);
                this.printServerUpMessage();
                this.setStatus(TigerServerStatus.RUNNING, "Server " + this.getServerId() + " up & healthy");
            }
            catch (ConnectException | SocketTimeoutException cex) {
                if (!quiet) {
                    this.log.info("No connection to {} of {}...", (Object)url, (Object)this.getServerId());
                }
            }
            catch (SSLHandshakeException sslhe) {
                this.log.warn(Ansi.colorize((String)("SSL handshake but server at least seems to be up!" + sslhe.getMessage()), (RbelAnsiColors)RbelAnsiColors.YELLOW_BOLD));
                this.setStatus(TigerServerStatus.RUNNING, "Server " + this.getServerId() + " up & healthy");
            }
            catch (SSLException sslex) {
                if (sslex.getMessage().equals("Unsupported or unrecognized SSL message")) {
                    if (!quiet) {
                        this.log.error("Unsupported or unrecognized SSL message - MAYBE you mismatched http/httpS?");
                    }
                } else if (!quiet) {
                    this.log.error("SSL Error - " + sslex.getMessage(), (Throwable)sslex);
                }
            }
            catch (Exception e) {
                if (quiet) break block11;
                this.log.error("Failed to connect - " + e.getMessage(), (Throwable)e);
            }
        }
        return this.getStatus();
    }

    private void checkUrlOrThrowException(URL url) throws IOException {
        URLConnection con = url.openConnection();
        InsecureTrustAllManager.allowAllSsl((URLConnection)con);
        con.setConnectTimeout(1000);
        con.connect();
        if (this.getConfiguration().getHealthcheckReturnCode() != null && con instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)con;
            if (!this.getConfiguration().getHealthcheckReturnCode().equals(httpConnection.getResponseCode())) {
                throw new TigerEnvironmentStartupException("Return code for server '%s' does not match: %nExpected %d but got %d", new Object[]{this.getServerId(), this.getConfiguration().getHealthcheckReturnCode(), httpConnection.getResponseCode()});
            }
        }
    }

    void printServerUpMessage() {
        String message = "External server Startup OK for '" + this.getServerId() + "'";
        if (this.getConfiguration().getSource() != null && !this.getConfiguration().getSource().isEmpty()) {
            message = message + " downloaded from '" + (String)this.getConfiguration().getSource().get(0) + "'";
        }
        this.log.info(Ansi.colorize((String)message, (RbelAnsiColors)RbelAnsiColors.GREEN_BOLD));
    }

    private void waitForConfiguredTimeAndSetRunning(long timeOutInMs) {
        this.log.warn("No health check URL configured! Resorting to simple wait with timeout {}s", (Object)(timeOutInMs / 1000L));
        this.log.info("Waiting {}s for external server {}...", (Object)(timeOutInMs / 1000L), (Object)this.getServerId());
        try {
            Thread.sleep(timeOutInMs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.setStatus(TigerServerStatus.RUNNING, "Server " + this.getServerId() + " up & healthy (default timeout)");
    }

    URL buildHealthcheckUrl() {
        try {
            return new URL((String)this.getHealthcheckUrl().orElseThrow(() -> new TigerTestEnvException("No Healthcheck Url is set for server " + this.getServerId())));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not build healthcheck URL from '" + this.getConfiguration().getHealthcheckUrl() + "'!", e);
        }
    }

    Optional<String> getHealthcheckUrl() {
        return Optional.ofNullable(this.getConfiguration().getHealthcheckUrl());
    }

    public String getDestinationUrl(String fallbackProtocol) {
        try {
            URIBuilder uriBuilder = new URIBuilder((String)this.getHealthcheckUrl().orElseThrow(() -> new TigerTestEnvException("No Healthcheck Url is set for server " + this.getServerId()))).setPath("");
            if (StringUtils.isNotEmpty((CharSequence)fallbackProtocol)) {
                uriBuilder.setScheme(fallbackProtocol);
            }
            return uriBuilder.build().toURL().toString();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new TigerEnvironmentStartupException("Unable to build destination URL", e);
        }
    }

    boolean isHealthCheckNone() {
        return this.getConfiguration().getHealthcheckUrl() == null || this.getConfiguration().getHealthcheckUrl().isEmpty() || this.getConfiguration().getHealthcheckUrl().equals("NONE");
    }

    protected void applyEnvPropertiesToProcess(ProcessBuilder processBuilder) {
        processBuilder.environment().putAll(this.getEnvironmentProperties().stream().map(str -> str.split("=", 2)).filter(ar -> ((String[])ar).length == 2).collect(Collectors.toMap(ar -> ar[0].trim(), ar -> ar[1].trim())));
    }
}

