/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr;

import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.test.tiger.common.Ansi;
import de.gematik.test.tiger.common.banner.Banner;
import de.gematik.test.tiger.common.config.SourceType;
import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.common.util.TigerSerializationUtil;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.TigerProxyApplication;
import de.gematik.test.tiger.testenvmgr.ITigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.config.Configuration;
import de.gematik.test.tiger.testenvmgr.env.DownloadManager;
import de.gematik.test.tiger.testenvmgr.env.TigerEnvUpdateSender;
import de.gematik.test.tiger.testenvmgr.env.TigerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.env.TigerUpdateListener;
import de.gematik.test.tiger.testenvmgr.servers.AbstractTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerLogListener;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerStatus;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerType;
import de.gematik.test.tiger.testenvmgr.util.TigerEnvironmentStartupException;
import de.gematik.test.tiger.testenvmgr.util.TigerTestEnvException;
import java.awt.Desktop;
import java.awt.HeadlessException;
import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

/*
 * Exception performing whole class analysis ignored.
 */
public class TigerTestEnvMgr
implements ITigerTestEnvMgr,
TigerEnvUpdateSender,
TigerUpdateListener,
DisposableBean,
AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerTestEnvMgr.class);
    public static final String HTTP = "http://";
    public static final String HTTPS = "https://";
    public static final String CFG_PROP_NAME_LOCAL_PROXY_ADMIN_PORT = "tiger.tigerProxy.adminPort";
    public static final String CFG_PROP_NAME_LOCAL_PROXY_PROXY_PORT = "tiger.tigerProxy.proxyPort";
    private final Configuration configuration;
    private final Map<String, Object> environmentVariables;
    private final TigerProxy localTigerProxy;
    private final List<TigerRoute> routesList = new ArrayList();
    private final Map<String, AbstractTigerServer> servers = new HashMap();
    private final ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
    private final List<TigerUpdateListener> listeners = new ArrayList();
    private final DownloadManager downloadManager = new DownloadManager();
    private ServletWebServerApplicationContext localTigerProxyApplicationContext;
    private boolean userAcknowledgedShutdown = false;
    private boolean userAcknowledgedContinueTestRun = false;
    private boolean userAcknowledgedFailingTestRun = false;
    private boolean workflowUiSentFetch = false;
    private final Map<String, Class<? extends AbstractTigerServer>> serverClasses = new HashMap();

    public TigerTestEnvMgr() {
        this.configuration = TigerTestEnvMgr.readConfiguration();
        this.environmentVariables = new HashMap();
        this.lookupServerPluginsInClasspath();
        this.localTigerProxy = this.startLocalTigerProxy(this.configuration);
        try {
            if (this.configuration.isLocalProxyActive()) {
                log.info(Ansi.colorize((String)"Local Tiger Proxy URL http://localhost:{}", (RbelAnsiColors)RbelAnsiColors.BLUE_BOLD), (Object)this.localTigerProxy.getProxyPort());
                log.info(Ansi.colorize((String)"Local Tiger Proxy UI http://localhost:{}/webui", (RbelAnsiColors)RbelAnsiColors.BLUE_BOLD), (Object)this.localTigerProxyApplicationContext.getWebServer().getPort());
                this.environmentVariables.put("PROXYHOST", "host.docker.internal");
                this.environmentVariables.put("PROXYPORT", this.localTigerProxy.getProxyPort());
            } else {
                log.info("Local Tiger Proxy deactivated");
            }
            this.createServerObjects();
            log.info("Tiger Testenv mgr created OK");
        }
        catch (RuntimeException e) {
            this.shutDown();
            throw e;
        }
    }

    private void lookupServerPluginsInClasspath() {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(TigerServerType.class));
        Set serverBeanDefinitions = scanner.findCandidateComponents("de.gematik.test.tiger");
        for (BeanDefinition serverBeanDefinition : serverBeanDefinitions) {
            try {
                Class<?> clz = Class.forName(serverBeanDefinition.getBeanClassName());
                String typeToken = clz.getAnnotation(TigerServerType.class).value();
                this.serverClasses.put(typeToken, clz.asSubclass(AbstractTigerServer.class));
                log.info("Registered server type {} with class {}", (Object)typeToken, (Object)serverBeanDefinition.getBeanClassName());
            }
            catch (ClassNotFoundException e) {
                throw new TigerTestEnvException("Unable to instantiate / find class " + serverBeanDefinition.getBeanClassName() + " for server", (Throwable)e);
            }
        }
    }

    private TigerProxy startLocalTigerProxy(Configuration configuration) {
        log.info("\n" + Banner.toBannerStr((String)"STARTING LOCAL PROXY...", (String)RbelAnsiColors.BLUE_BOLD.toString()));
        if (configuration.getTigerProxy() == null) {
            configuration.setTigerProxy(TigerProxyConfiguration.builder().build());
        }
        TigerProxyConfiguration proxyConfig = configuration.getTigerProxy();
        proxyConfig.setSkipTrafficEndpointsSubscription(true);
        if (proxyConfig.getProxyRoutes() == null) {
            proxyConfig.setProxyRoutes(List.of());
        }
        HashMap<String, String> properties = new HashMap<String, String>(TigerSerializationUtil.toMap((Object)proxyConfig, (String[])new String[]{"tigerProxy"}));
        if (configuration.getTigerProxy().getAdminPort() == 0) {
            int port = (Integer)TigerGlobalConfiguration.readIntegerOptional((String)"tiger.internal.localproxy.admin.port").orElseThrow(() -> new TigerEnvironmentStartupException("No free port reserved for local Tiger Proxy admin"));
            properties.put("server.port", Integer.toString(port));
        } else {
            properties.put("server.port", Integer.toString(configuration.getTigerProxy().getAdminPort()));
            TigerGlobalConfiguration.putValue((String)"tiger.internal.localproxy.port", (String)Integer.toString(configuration.getTigerProxy().getAdminPort()));
        }
        this.localTigerProxyApplicationContext = (ServletWebServerApplicationContext)new SpringApplicationBuilder(new Class[0]).bannerMode(Banner.Mode.OFF).properties(properties).sources(new Class[]{TigerProxyApplication.class}).web(WebApplicationType.SERVLET).registerShutdownHook(false).initializers(new ApplicationContextInitializer[0]).run(new String[0]);
        TigerProxy localTigerProxy = (TigerProxy)this.localTigerProxyApplicationContext.getBean(TigerProxy.class);
        TigerGlobalConfiguration.putValue((String)"tiger.tigerProxy.proxyPort", (int)localTigerProxy.getProxyPort());
        TigerGlobalConfiguration.putValue((String)"tiger.tigerProxy.adminPort", (String)String.valueOf(this.localTigerProxyApplicationContext.getWebServer().getPort()));
        return localTigerProxy;
    }

    public static void waitForConsoleInput(String textToEnter) {
        Console c = System.console();
        String message = "\n" + Banner.toBannerStr((String)("Press " + (String)(textToEnter.isEmpty() ? "" : "'" + textToEnter + "' and ") + "ENTER."), (String)RbelAnsiColors.RED_BOLD.toString());
        if (c != null) {
            TigerTestEnvMgr.readCommandFromInput((String)textToEnter, (String)message, (T v) -> c.readLine());
        } else {
            log.warn("No Console interface found, trying System in stream...");
            BufferedReader rdr = new BufferedReader(new InputStreamReader(System.in));
            TigerTestEnvMgr.readCommandFromInput((String)textToEnter, (String)message, (T v) -> {
                try {
                    return rdr.readLine();
                }
                catch (IOException e) {
                    log.warn("Unable to open input stream from console! Continuing with test run...", (Throwable)e);
                    return null;
                }
            });
        }
        log.info("Step wait acknowledged. Continueing...");
    }

    private static void readCommandFromInput(String textToEnter, String message, Function<Void, String> readLine) {
        String cmd = null;
        while (cmd == null || !cmd.equals(textToEnter)) {
            log.info(message);
            if (cmd != null) {
                log.warn("Received: '{}'", (Object)cmd);
            }
            cmd = readLine.apply(null);
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new TigerTestEnvException("Interrupt received while waiting for console input", (Throwable)e);
            }
        }
    }

    private static void readTemplates() {
        try {
            URL templatesUrl = TigerTestEnvMgr.class.getResource("templates.yaml");
            String templatesYaml = IOUtils.toString((URI)Objects.requireNonNull(templatesUrl).toURI(), (Charset)StandardCharsets.UTF_8);
            TigerGlobalConfiguration.readTemplates((String)templatesYaml, (String[])new String[]{"tiger", "servers"});
        }
        catch (IOException | URISyntaxException e) {
            throw new TigerConfigurationException("Unable to read templates YAML!", (Throwable)e);
        }
    }

    private static Configuration readConfiguration() {
        TigerGlobalConfiguration.initialize();
        TigerTestEnvMgr.readTemplates();
        TigerTestEnvMgr.addDefaults();
        Configuration configuration = TigerGlobalConfiguration.instantiateConfigurationBean(Configuration.class, (String[])new String[]{"tiger"}).orElseGet(Configuration::new);
        for (CfgServer cfgServer : configuration.getServers().values()) {
            if (!StringUtils.isNotEmpty((CharSequence)cfgServer.getTemplate())) continue;
            throw new TigerConfigurationException("Could not resolve template '" + cfgServer.getTemplate() + "'");
        }
        return configuration;
    }

    private static void addDefaults() {
        TigerGlobalConfiguration.putValue((String)"tiger.tigerProxy.parsingShouldBlockCommunication", (String)"true", (SourceType)SourceType.DEFAULTS);
    }

    private void assertNoCyclesInGraph() {
        this.servers.values().forEach(server -> this.cycleChecker(server, new HashSet()));
    }

    private void cycleChecker(AbstractTigerServer currentPosition, Set<AbstractTigerServer> visitedServer) {
        if (visitedServer.contains(currentPosition)) {
            throw new TigerEnvironmentStartupException("Cyclic graph detected in startup sequence: %s", new Object[]{visitedServer.stream().map(AbstractTigerServer::getServerId).collect(Collectors.toList())});
        }
        if (currentPosition.getDependUponList().isEmpty()) {
            return;
        }
        for (AbstractTigerServer server : currentPosition.getDependUponList()) {
            HashSet<AbstractTigerServer> newSet = new HashSet<AbstractTigerServer>(visitedServer);
            newSet.add(currentPosition);
            this.cycleChecker(server, newSet);
        }
    }

    private void createServerObjects() {
        for (Map.Entry serverEntry : this.configuration.getServers().entrySet()) {
            if (!((CfgServer)serverEntry.getValue()).isActive()) continue;
            AbstractTigerServer server = this.createServer((String)serverEntry.getKey(), (CfgServer)serverEntry.getValue());
            this.servers.put((String)serverEntry.getKey(), server);
            server.registerNewListener((TigerUpdateListener)this);
        }
    }

    public AbstractTigerServer createServer(String serverId, CfgServer config) {
        if (config.getType() == null) {
            throw new TigerTestEnvException("Unable to instantiate server of null type! PLease check your config");
        }
        try {
            String serverType = config.getType().value();
            if (!this.serverClasses.containsKey(serverType)) {
                throw new TigerTestEnvException("No server class registered for type " + serverType + " used in server " + serverId);
            }
            return (AbstractTigerServer)((Class)this.serverClasses.get(serverType)).getDeclaredConstructor(TigerTestEnvMgr.class, String.class, CfgServer.class).newInstance(this, serverId, config);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
            if (e.getCause() != null) {
                if (e.getCause() instanceof TigerConfigurationException) {
                    throw (TigerConfigurationException)e.getCause();
                }
                if (e.getCause() instanceof TigerTestEnvException) {
                    throw (TigerTestEnvException)e.getCause();
                }
            }
            throw new TigerTestEnvException((Throwable)e, "Unable to instantiate server of type %s, does it have a constructor(TigerTestenvMgr, String, CfgServer)?", new Object[]{config.getType().value()});
        }
    }

    public void setUpEnvironment() {
        this.assertNoCyclesInGraph();
        this.assertNoUnknownServersInDependencies();
        List initialServersToBoot = this.servers.values().parallelStream().filter(server -> server.getDependUponList().isEmpty()).collect(Collectors.toList());
        log.info("Booting following server(s): {}", initialServersToBoot.stream().map(AbstractTigerServer::getHostname).collect(Collectors.toList()));
        initialServersToBoot.parallelStream().forEach(arg_0 -> this.startServer(arg_0));
        this.localTigerProxy.subscribeToTrafficEndpoints(this.configuration.getTigerProxy());
        log.info(Ansi.colorize((String)"Finished set up test environment OK", (RbelAnsiColors)RbelAnsiColors.GREEN_BOLD));
    }

    private void assertNoUnknownServersInDependencies() {
        this.getServers().values().forEach(AbstractTigerServer::getDependUponList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServer(AbstractTigerServer server) {
        AbstractTigerServer abstractTigerServer = server;
        synchronized (abstractTigerServer) {
            if (server.getStatus() != TigerServerStatus.NEW) {
                return;
            }
            server.start(this);
        }
        this.servers.values().parallelStream().peek(toBeStartedServer -> log.debug("Considering to start server {} with status {}...", (Object)toBeStartedServer.getServerId(), (Object)toBeStartedServer.getStatus())).filter(candidate -> candidate.getStatus() == TigerServerStatus.NEW).filter(candidate -> candidate.getDependUponList().stream().filter(depending -> depending.getStatus() != TigerServerStatus.RUNNING).findAny().isEmpty()).peek(toBeStartedServer -> log.info("Starting server {} with status {}", (Object)toBeStartedServer.getServerId(), (Object)toBeStartedServer.getStatus())).forEach(arg_0 -> this.startServer(arg_0));
    }

    public String replaceSysPropsInString(String str) {
        return str;
    }

    public synchronized void shutDown() {
        log.info(Ansi.colorize((String)"Shutting down all servers...", (RbelAnsiColors)RbelAnsiColors.RED_BOLD));
        for (AbstractTigerServer server : this.servers.values()) {
            try {
                server.shutdown();
            }
            catch (RuntimeException e) {
                log.warn("Exception while shutting down server " + server.getServerId(), (Throwable)e);
            }
        }
        log.info(Ansi.colorize((String)"Shutting down local tiger proxy...", (RbelAnsiColors)RbelAnsiColors.RED_BOLD));
        if (this.localTigerProxy != null) {
            this.localTigerProxy.shutdown();
        }
        if (this.localTigerProxyApplicationContext != null) {
            this.localTigerProxyApplicationContext.close();
        }
        log.info(Ansi.colorize((String)"Finished shutdown test environment OK", (RbelAnsiColors)RbelAnsiColors.RED_BOLD));
    }

    public void receiveTestEnvUpdate(TigerStatusUpdate statusUpdate) {
        this.listeners.forEach(listener -> listener.receiveTestEnvUpdate(statusUpdate));
    }

    public List<TigerRoute> getRoutes() {
        return this.servers.values().stream().map(AbstractTigerServer::getRoutes).flatMap(Collection::stream).collect(Collectors.toUnmodifiableList());
    }

    public Optional<AbstractTigerServer> findServer(String serverName) {
        return Optional.ofNullable((AbstractTigerServer)this.servers.get(serverName));
    }

    public boolean isLocalTigerProxyActive() {
        if (this.configuration == null) {
            return true;
        }
        return this.configuration.isLocalProxyActive();
    }

    public void registerNewListener(TigerUpdateListener listener) {
        this.listeners.add(listener);
    }

    public void registerLogListener(TigerServerLogListener listener) {
    }

    public static void openWorkflowUiInBrowser(String adminPort) {
        try {
            String url = "http://localhost:" + adminPort;
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop desktop = Desktop.getDesktop();
                log.info("Starting Workflow UI via Java Desktop API");
                desktop.browse(new URI(url));
                log.info(Ansi.colorize((String)"Workflow UI {}", (RbelAnsiColors)RbelAnsiColors.BLUE_BOLD), (Object)url);
            } else {
                String command;
                String operatingSystemName = System.getProperty("os.name").toLowerCase();
                if (operatingSystemName.contains("nix") || operatingSystemName.contains("nux")) {
                    command = "xdg-open " + url;
                } else if (operatingSystemName.contains("win")) {
                    command = "rundll32 url.dll,FileProtocolHandler " + url;
                } else if (operatingSystemName.contains("mac")) {
                    command = "open " + url;
                } else {
                    log.error("Unknown operation system '{}'", (Object)operatingSystemName);
                    return;
                }
                log.info("Starting Workflow UI via '{}'", (Object)command);
                Runtime.getRuntime().exec(command);
                log.info(Ansi.colorize((String)("Workflow UI " + url), (RbelAnsiColors)RbelAnsiColors.BLUE_BOLD));
            }
        }
        catch (HeadlessException hex) {
            log.error("Unable to start Workflow UI on a headless server!", (Throwable)hex);
        }
        catch (IOException | RuntimeException | URISyntaxException e) {
            log.error("Exception while trying to start browser for Workflow UI, still continuing with test run", (Throwable)e);
        }
    }

    public void receivedUserAcknowledgementForShutdown() {
        this.userAcknowledgedShutdown = true;
    }

    public void receivedResumeTestRunExecution() {
        this.userAcknowledgedContinueTestRun = true;
    }

    public void receivedCancelTestRunExecution() {
        this.userAcknowledgedFailingTestRun = true;
    }

    public void resetUserInput() {
        this.userAcknowledgedContinueTestRun = false;
        this.userAcknowledgedFailingTestRun = false;
    }

    public void destroy() throws Exception {
        this.shutDown();
    }

    @Override
    public void close() throws Exception {
        this.shutDown();
    }

    @Generated
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public Map<String, Object> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Generated
    public TigerProxy getLocalTigerProxy() {
        return this.localTigerProxy;
    }

    @Generated
    public List<TigerRoute> getRoutesList() {
        return this.routesList;
    }

    @Generated
    public Map<String, AbstractTigerServer> getServers() {
        return this.servers;
    }

    @Generated
    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Generated
    public List<TigerUpdateListener> getListeners() {
        return this.listeners;
    }

    @Generated
    public DownloadManager getDownloadManager() {
        return this.downloadManager;
    }

    @Generated
    public ServletWebServerApplicationContext getLocalTigerProxyApplicationContext() {
        return this.localTigerProxyApplicationContext;
    }

    @Generated
    public boolean isUserAcknowledgedShutdown() {
        return this.userAcknowledgedShutdown;
    }

    @Generated
    public boolean isUserAcknowledgedContinueTestRun() {
        return this.userAcknowledgedContinueTestRun;
    }

    @Generated
    public boolean isUserAcknowledgedFailingTestRun() {
        return this.userAcknowledgedFailingTestRun;
    }

    @Generated
    public Map<String, Class<? extends AbstractTigerServer>> getServerClasses() {
        return this.serverClasses;
    }

    @Generated
    public void setWorkflowUiSentFetch(boolean workflowUiSentFetch) {
        this.workflowUiSentFetch = workflowUiSentFetch;
    }

    @Generated
    public boolean isWorkflowUiSentFetch() {
        return this.workflowUiSentFetch;
    }
}

