/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr;

import de.gematik.test.tiger.common.OsEnvironment;
import de.gematik.test.tiger.common.TokenSubstituteHelper;
import de.gematik.test.tiger.common.banner.Banner;
import de.gematik.test.tiger.common.config.TigerConfigurationHelper;
import de.gematik.test.tiger.common.pki.KeyMgr;
import de.gematik.test.tiger.common.pki.TigerPkiIdentity;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.configuration.TigerProxyConfiguration;
import de.gematik.test.tiger.proxy.data.TigerRoute;
import de.gematik.test.tiger.testenvmgr.DockerMgr;
import de.gematik.test.tiger.testenvmgr.ITigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvException;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.config.Configuration;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerTestEnvMgr
implements ITigerTestEnvMgr {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerTestEnvMgr.class);
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    private static boolean SHUTDOWN_HOOK_ACTIVE = false;
    private final Configuration configuration;
    private final DockerMgr dockerManager;
    private final Map<String, Object> environmentVariables;
    private final TigerProxy localTigerProxy;
    private final List<TigerRoute> routesList = new ArrayList<TigerRoute>();
    private final Map<String, Process> externalProcesses = new HashMap<String, Process>();

    public static void main(String[] args) {
        TigerTestEnvMgr envMgr = new TigerTestEnvMgr();
        try {
            envMgr.setUpEnvironment();
        }
        catch (Exception e) {
            log.error("Error while starting up stand alone tiger testenv mgr! ABORTING...", (Throwable)e);
            System.exit(1);
        }
        log.info("\n" + Banner.toBannerStr((String)"Tiger standalone test environment UP!", (String)"\u001b[1m\u001b[32m"));
        TigerTestEnvMgr.waitForQuit(null, new Object[0]);
        log.info("interrupting " + envMgr.externalProcesses.size() + " threads...");
        envMgr.externalProcesses.values().forEach(Process::destroy);
        log.info("stopping threads...");
        envMgr.externalProcesses.values().forEach(Process::destroyForcibly);
        envMgr.externalProcesses.clear();
        System.exit(0);
    }

    public static void waitForQuit(String message, Object ... args) {
        Console c = System.console();
        if (c != null) {
            if (message != null) {
                c.format(message, args);
            }
            c.format("\n\n\nPress 'quit' and ENTER to stop TIGER standalone test environment.\n\n\n\n\n", new Object[0]);
            String cmd = "";
            while (!cmd.equals("quit")) {
                cmd = c.readLine();
            }
            log.info("Stopping TIGER standalone test environment...");
        } else {
            log.warn("No Console interface found, trying System in stream...");
            log.info("\n\n\nPress 'quit' and ENTER to stop TIGER standalone test environment.\n\n\n\n\n");
            try {
                BufferedReader rdr = new BufferedReader(new InputStreamReader(System.in));
                String cmd = "";
                while (!cmd.equals("quit")) {
                    cmd = rdr.readLine();
                }
            }
            catch (IOException e) {
                log.warn("Unable to open input stream from console! You will have to use Ctrl+C and clean up the processes manually!");
                try {
                    while (true) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
        }
    }

    public TigerTestEnvMgr() {
        TigerProxyConfiguration proxyConfig;
        File cfgFile = new File(OsEnvironment.getAsString((String)"TIGER_TESTENV_CFGFILE", (String)("tiger-testenv-" + this.getComputerName() + ".yaml")));
        if (!cfgFile.exists()) {
            log.warn("Unable to read configuration from " + cfgFile.getAbsolutePath());
            cfgFile = new File("tiger-testenv.yaml");
        }
        log.info("Reading configuration from " + cfgFile.getAbsolutePath() + "...");
        JSONObject jsonCfg = TigerConfigurationHelper.yamlToJson((String)cfgFile.getAbsolutePath());
        JSONObject jsonTemplate = TigerConfigurationHelper.yamlStringToJson((String)IOUtils.toString((URI)Objects.requireNonNull(this.getClass().getResource("templates.yaml")).toURI(), (Charset)StandardCharsets.UTF_8));
        TigerConfigurationHelper.applyTemplate((JSONArray)jsonCfg.getJSONArray("servers"), (String)"template", (JSONArray)jsonTemplate.getJSONArray("templates"), (String)"name");
        TigerConfigurationHelper.overwriteWithSysPropsAndEnvVars((String)"TIGER_TESTENV", (String)"tiger.testenv", (JSONObject)jsonCfg);
        this.configuration = (Configuration)new TigerConfigurationHelper().jsonStringToConfig(jsonCfg.toString(), Configuration.class);
        this.dockerManager = new DockerMgr();
        if (this.configuration.getTigerProxy() == null) {
            this.configuration.setTigerProxy(TigerProxyConfiguration.builder().build());
        }
        if ((proxyConfig = this.configuration.getTigerProxy()).getProxyRoutes() == null) {
            proxyConfig.setProxyRoutes(List.of());
        }
        if (proxyConfig.getServerRootCa() == null) {
            proxyConfig.setServerRootCa(new TigerPkiIdentity("CertificateAuthorityCertificate.pem;PKCS8CertificateAuthorityPrivateKey.pem;PKCS8"));
        }
        log.info("Starting local docker tiger proxy...");
        this.localTigerProxy = new TigerProxy(this.configuration.getTigerProxy());
        this.environmentVariables = this.configuration.isLocalProxyActive() ? new HashMap<String, Integer>(Map.of("PROXYHOST", "host.docker.internal", "PROXYPORT", this.localTigerProxy.getPort())) : new HashMap<String, Object>();
        log.info("Tiger Testenv mgr created OK");
    }

    @Override
    public void setUpEnvironment() {
        log.info("starting set up of test environment...");
        this.configuration.getServers().forEach(server -> this.start((CfgServer)server, this.configuration));
        log.info("finished set up test environment OK");
    }

    @Override
    public List<CfgServer> getTestEnvironment() {
        return this.configuration.getServers();
    }

    @Override
    public void start(CfgServer server, Configuration configuration) {
        String type = server.getType();
        if (server.isActive()) {
            if (type.equalsIgnoreCase("docker")) {
                this.startDocker(server, configuration);
            } else if (type.equalsIgnoreCase("compose")) {
                this.startDocker(server, configuration);
            } else if (type.equalsIgnoreCase("externalUrl")) {
                this.initializeExternalUrl(server);
            } else if (type.equalsIgnoreCase("externalJar")) {
                this.initializeExternalJar(server);
            } else {
                throw new TigerTestEnvException(String.format("Unsupported server type %s found in server %s", type, server.getName()));
            }
            server.getExports().forEach(exp -> {
                String[] kvp = exp.split("=", 2);
                if (type.equalsIgnoreCase("docker") && server.getPorts() != null) {
                    server.getPorts().forEach((localPort, externPort) -> {
                        kvp[1] = kvp[1].replace("${PORT:" + localPort + "}", String.valueOf(externPort));
                    });
                }
                kvp[1] = kvp[1].replace("${NAME}", server.getName());
                log.info("  setting system property " + kvp[0] + "=" + kvp[1]);
                System.setProperty(kvp[0], kvp[1]);
                this.environmentVariables.put(kvp[0], kvp[1]);
            });
        } else {
            log.warn("skipping inactive server " + server.getName());
        }
    }

    private String getComputerName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return InetAddress.getLoopbackAddress().getHostName();
        }
    }

    private void startDocker(CfgServer server, Configuration configuration) {
        log.info("\u001b[1m\u001b[32mStarting docker container for " + server.getName() + ":" + server.getSource().get(0) + "\u001b[0m");
        List<String> imports = server.getEnvironment();
        for (int i = 0; i < imports.size(); ++i) {
            imports.set(i, TokenSubstituteHelper.substitute((String)imports.get(i), (String)"", this.environmentVariables));
        }
        if (server.getUrlMappings() != null) {
            server.getUrlMappings().forEach(mapping -> {
                String[] kvp = mapping.split(" --> ", 2);
                this.localTigerProxy.addRoute(TigerRoute.builder().from(kvp[0]).to(kvp[1]).build());
            });
        }
        if (server.getType().equalsIgnoreCase("docker")) {
            this.dockerManager.startContainer(server, configuration, this);
        } else {
            this.dockerManager.startComposition(server, configuration, this);
        }
        this.loadPKIForProxy(server);
        if (server.getPorts() != null && !server.getPorts().isEmpty()) {
            this.routesList.add(TigerRoute.builder().from(HTTP + server.getName()).to("http://localhost:" + server.getPorts().values().iterator().next()).build());
            this.localTigerProxy.addRoute(TigerRoute.builder().from(HTTP + server.getName()).to("http://localhost:" + server.getPorts().values().iterator().next()).build());
        }
        log.info("\u001b[1m\u001b[32mDocker container Startup OK " + server.getSource().get(0) + "\u001b[0m");
    }

    public void initializeExternalUrl(CfgServer server) {
        log.info("\u001b[1m\u001b[32mstarting external URL instance " + server.getName() + "...\u001b[0m");
        URL url = new URL(server.getSource().get(0));
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        this.localTigerProxy.addRoute(TigerRoute.builder().from(HTTP + server.getName()).to(url.toURI().getScheme() + "://" + url.getHost() + ":" + port).build());
        this.loadPKIForProxy(server);
        log.info("  Waiting 50% of start up time for external URL instance  " + server.getName() + " to come up ...");
        if (this.waitForService(server, (long)server.getStartupTimeoutSec().intValue() * 500L, true)) {
            return;
        }
        this.waitForService(server, (long)server.getStartupTimeoutSec().intValue() * 500L, false);
    }

    /*
     * Exception decompiling
     */
    private boolean waitForService(CfgServer server, long timeoutms, boolean quiet) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void initializeExternalJar(CfgServer server) {
        String jarUrl = server.getSource().get(0);
        String jarName = jarUrl.substring(jarUrl.lastIndexOf("/") + 1);
        File jarFile = Paths.get(server.getWorkingDir(), jarName).toFile();
        if (!jarFile.exists()) {
            this.downloadJar(server, jarUrl, jarFile);
        }
        log.info("\u001b[1m\u001b[32mstarting external jar instance " + server.getName() + " in folder " + server.getWorkingDir() + "...\u001b[0m");
        List options = server.getOptions().stream().map(o -> {
            if (this.configuration.isLocalProxyActive()) {
                return TokenSubstituteHelper.substitute((String)o, (String)"", Map.of("PROXYHOST", "127.0.0.1", "PROXYPORT", this.localTigerProxy.getPort()));
            }
            return o;
        }).map(o -> TokenSubstituteHelper.substitute((String)o, (String)"", this.environmentVariables)).collect(Collectors.toList());
        String[] paths = System.getenv("PATH").split(SystemUtils.IS_OS_WINDOWS ? ";" : ":");
        String javaProg = "java" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
        String javaExe = Arrays.stream(paths).map(path -> Path.of(path, javaProg).toFile()).filter(file -> file.exists() && file.canExecute()).map(File::getAbsolutePath).findAny().orElseThrow(() -> new TigerTestEnvException("Unable to find executable java program in PATH"));
        options.add(0, javaExe);
        options.add("-jar");
        options.add(jarName);
        options.addAll(server.getArguments());
        log.info("executing '" + String.join((CharSequence)" ", options));
        AtomicReference exception = new AtomicReference();
        Thread thread = new Thread(() -> {
            try {
                Process p = new ProcessBuilder(new String[0]).command((String[])options.toArray(String[]::new)).directory(new File(server.getWorkingDir())).inheritIO().start();
                Thread.sleep(2000L);
                if (!p.isAlive()) {
                    throw new TigerTestEnvException("External Jar startup failed");
                }
                this.externalProcesses.put(server.getName(), p);
                log.info("Started " + server.getName());
            }
            catch (Throwable t) {
                exception.set(t);
            }
        });
        thread.setName(server.getName());
        thread.start();
        if (!SHUTDOWN_HOOK_ACTIVE) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                if (!this.externalProcesses.isEmpty()) {
                    log.info("interrupting threads...");
                    this.externalProcesses.values().forEach(Process::destroy);
                    log.info("stopping threads...");
                    this.externalProcesses.values().forEach(Process::destroyForcibly);
                }
            }));
            SHUTDOWN_HOOK_ACTIVE = true;
        }
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)server.getStartupTimeoutSec()).withFailMessage("Startup time in sec is mandatory attribute!", new Object[0])).isNotNull();
        if (exception.get() != null) {
            throw new TigerTestEnvException("Unable to start external jar!", (Throwable)exception.get());
        }
        if (this.waitForService(server, (long)server.getStartupTimeoutSec().intValue() * 500L, true)) {
            return;
        }
        if (exception.get() != null) {
            throw new TigerTestEnvException("Unable to start external jar!", (Throwable)exception.get());
        }
        this.waitForService(server, (long)server.getStartupTimeoutSec().intValue() * 500L, false);
    }

    private void downloadJar(CfgServer server, String jarUrl, File jarFile) throws InterruptedException {
        if (jarUrl.startsWith("local:")) {
            throw new TigerTestEnvException("Local jar " + jarFile.getAbsolutePath() + " not found!");
        }
        log.info("downloading jar for external server from " + jarUrl + "...");
        File workDir = new File(server.getWorkingDir());
        if (!workDir.exists() && !workDir.mkdirs()) {
            throw new TigerTestEnvException("Unable to create working directory " + workDir.getAbsolutePath());
        }
        long startms = System.currentTimeMillis();
        AtomicBoolean finished = new AtomicBoolean(false);
        AtomicReference exception = new AtomicReference();
        Thread t = new Thread(() -> {
            try {
                FileUtils.copyURLToFile((URL)new URL(jarUrl), (File)jarFile);
                finished.set(true);
            }
            catch (IOException ioe) {
                exception.set(ioe);
            }
        });
        t.start();
        int progressCtr = 0;
        while (!finished.get()) {
            if (System.currentTimeMillis() - startms > 900000L) {
                t.interrupt();
                t.stop();
                throw new TigerTestEnvException("Download of " + jarUrl + " took longer then 15 minutes!");
            }
            if (exception.get() != null) {
                throw new TigerTestEnvException("Failure while downloading jar " + jarUrl + "!", (Throwable)exception.get());
            }
            Thread.sleep(500L);
            if (++progressCtr != 6) continue;
            log.info("downloaded " + jarFile.length() / 1000L + " kb");
            progressCtr = 0;
        }
    }

    @Override
    public void shutDown(CfgServer server) {
        String type = server.getType();
        if (type.equalsIgnoreCase("externalUrl")) {
            this.shutDownExternal(server);
        } else if (type.equalsIgnoreCase("docker")) {
            this.shutDownDocker(server);
        } else if (type.equalsIgnoreCase("externalJar")) {
            this.shutDownJar(server);
        } else {
            throw new TigerTestEnvException("Unsupported server uri type " + type);
        }
    }

    private void loadPKIForProxy(CfgServer srv) {
        log.info("  loading PKI resources for instance " + srv.getName() + "...");
        srv.getPkiKeys().stream().filter(key -> key.getType().equals("cert")).forEach(key -> {
            log.info("Adding certificate " + key.getId());
            this.getLocalTigerProxy().addKey(key.getId(), (Key)KeyMgr.readCertificateFromPem((String)("-----BEGIN CERTIFICATE-----\n" + key.getPem().replace(" ", "\n") + "\n-----END CERTIFICATE-----")).getPublicKey());
        });
        srv.getPkiKeys().stream().filter(key -> key.getType().equals("key")).forEach(key -> {
            log.info("Adding key " + key.getId());
            this.getLocalTigerProxy().addKey(key.getId(), KeyMgr.readKeyFromPem((String)("-----BEGIN PRIVATE KEY-----\n" + key.getPem().replace(" ", "\n") + "\n-----END PRIVATE KEY-----")));
        });
    }

    private void shutDownDocker(CfgServer server) {
        log.info("Stopping docker container " + server.getName() + "...");
        this.dockerManager.stopContainer(server);
        this.removeRoute(server);
    }

    private void shutDownExternal(CfgServer server) {
        this.removeRoute(server);
    }

    private void shutDownJar(CfgServer server) {
        Process proc = this.externalProcesses.get(server.getName());
        if (proc != null) {
            log.info("interrupting thread for " + server.getName() + "...");
            proc.destroy();
            log.info("stopping thread for " + server.getName() + "...");
            proc.destroyForcibly();
        }
        this.removeRoute(server);
    }

    private void removeRoute(CfgServer server) {
        log.info("Removing routes for " + server.getName() + "...");
        Predicate<TigerRoute> isServerRoute = route -> route.getFrom().equals(HTTP + server.getName()) || route.getFrom().equals(HTTPS + server.getName());
        this.routesList.stream().filter(isServerRoute).forEach(r -> this.localTigerProxy.removeRoute(r.getFrom()));
        this.routesList.removeIf(isServerRoute);
    }

    public List<TigerRoute> getRoutes() {
        return this.routesList;
    }

    @Override
    @Generated
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public DockerMgr getDockerManager() {
        return this.dockerManager;
    }

    @Generated
    public Map<String, Object> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Generated
    public TigerProxy getLocalTigerProxy() {
        return this.localTigerProxy;
    }

    @Generated
    public List<TigerRoute> getRoutesList() {
        return this.routesList;
    }

    @Generated
    public Map<String, Process> getExternalProcesses() {
        return this.externalProcesses;
    }
}

