/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr;

import de.gematik.test.tiger.common.OsEnvironment;
import de.gematik.test.tiger.common.TokenSubstituteHelper;
import de.gematik.test.tiger.common.config.TigerConfigurationHelper;
import de.gematik.test.tiger.common.pki.KeyMgr;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.configuration.TigerProxyConfiguration;
import de.gematik.test.tiger.proxy.data.TigerRoute;
import de.gematik.test.tiger.testenvmgr.DockerMgr;
import de.gematik.test.tiger.testenvmgr.ITigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.InsecureRestorableTrustAllManager;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvException;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.config.Configuration;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerTestEnvMgr
implements ITigerTestEnvMgr {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerTestEnvMgr.class);
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    private static boolean SHUTDOWN_HOOK_ACTIVE = false;
    private final Configuration configuration;
    private final DockerMgr dockerManager;
    private Map<String, Object> environmentVariables;
    private final TigerProxy localDockerProxy;
    private final List<TigerRoute> routesList = new ArrayList<TigerRoute>();
    private final Map<String, Process> externalProcesses = new HashMap<String, Process>();

    public static void main(String[] args) throws InterruptedException {
        try {
            TigerTestEnvMgr envMgr = new TigerTestEnvMgr();
            envMgr.setUpEnvironment();
        }
        catch (Exception e) {
            log.error("Error while starting up stand alone tiger testenv mgr!", (Throwable)e);
            System.exit(1);
        }
        log.info("Tiger standalone test environment UP!");
        while (true) {
            Thread.sleep(1000L);
        }
    }

    public TigerTestEnvMgr() {
        TigerProxyConfiguration proxyConfig;
        File cfgFile = new File(OsEnvironment.getAsString((String)"TIGER_TESTENV_CFGFILE", (String)"tiger-testenv.yaml"));
        log.info("Reading configuration from " + cfgFile.getAbsolutePath() + "...");
        JSONObject jsonCfg = TigerConfigurationHelper.yamlToJson((String)cfgFile.getAbsolutePath());
        JSONObject jsonTemplate = TigerConfigurationHelper.yamlStringToJson((String)IOUtils.toString((URI)Objects.requireNonNull(this.getClass().getResource("templates.yaml")).toURI(), (Charset)StandardCharsets.UTF_8));
        TigerConfigurationHelper.applyTemplate((JSONArray)jsonCfg.getJSONArray("servers"), (String)"template", (JSONArray)jsonTemplate.getJSONArray("templates"), (String)"name");
        TigerConfigurationHelper.overwriteWithSysPropsAndEnvVars((String)"TIGER_TESTENV", (String)"tiger.testenv", (JSONObject)jsonCfg);
        this.configuration = (Configuration)new TigerConfigurationHelper().jsonStringToConfig(jsonCfg.toString(), Configuration.class);
        this.dockerManager = new DockerMgr();
        if (this.configuration.getTigerProxy() == null) {
            this.configuration.setTigerProxy(TigerProxyConfiguration.builder().build());
        }
        if ((proxyConfig = this.configuration.getTigerProxy()).getProxyRoutes() == null) {
            proxyConfig.setProxyRoutes(List.of());
        }
        if (proxyConfig.getServerRootCaCertPem() == null) {
            proxyConfig.setServerRootCaCertPem("CertificateAuthorityCertificate.pem");
            proxyConfig.setServerRootCaKeyPem("PKCS8CertificateAuthorityPrivateKey.pem");
        }
        log.info("Starting local docker tiger proxy...");
        this.localDockerProxy = new TigerProxy(this.configuration.getTigerProxy());
        this.environmentVariables = new HashMap<String, Integer>(Map.of("PROXYHOST", "host.docker.internal", "PROXYPORT", this.localDockerProxy.getPort()));
        log.info("Tiger Testenv mgr created OK");
    }

    @Override
    public void setUpEnvironment() {
        log.info("starting set up of test environment...");
        this.configuration.getServers().forEach(server -> this.start((CfgServer)server, this.configuration));
        log.info("finished set up test environment OK");
    }

    @Override
    public List<CfgServer> getTestEnvironment() {
        return this.configuration.getServers();
    }

    @Override
    public void start(CfgServer server, Configuration configuration) {
        String type = server.getType();
        if (server.isActive()) {
            if (type.equalsIgnoreCase("docker")) {
                this.startDocker(server, configuration);
            } else if (type.equalsIgnoreCase("compose")) {
                this.startDocker(server, configuration);
            } else if (type.equalsIgnoreCase("externalUrl")) {
                this.initializeExternal(server);
            } else if (type.equalsIgnoreCase("externalJar")) {
                this.initializeExternalJar(server);
            } else {
                throw new TigerTestEnvException(String.format("Unsupported server type %s found in server %s", type, server.getName()));
            }
            server.getExports().forEach(exp -> {
                String[] kvp = exp.split("=", 2);
                if (type.equalsIgnoreCase("docker") && server.getPorts() != null) {
                    server.getPorts().forEach((localPort, externPort) -> {
                        kvp[1] = kvp[1].replace("${PORT:" + localPort + "}", String.valueOf(externPort));
                    });
                }
                kvp[1] = kvp[1].replace("${NAME}", server.getName());
                log.info("  setting system property " + kvp[0] + "=" + kvp[1]);
                System.setProperty(kvp[0], kvp[1]);
                this.environmentVariables.put(kvp[0], kvp[1]);
            });
        } else {
            log.warn("skipping inactive server " + server.getName());
        }
    }

    private void startDocker(CfgServer server, Configuration configuration) {
        log.info("\u001b[1m\u001b[32mStarting docker container for " + server.getName() + ":" + server.getSource().get(0) + "\u001b[0m");
        List<String> imports = server.getEnvironment();
        for (int i = 0; i < imports.size(); ++i) {
            imports.set(i, TokenSubstituteHelper.substitute((String)imports.get(i), (String)"", this.environmentVariables));
        }
        if (server.getUrlMappings() != null) {
            server.getUrlMappings().forEach(mapping -> {
                String[] kvp = mapping.split(" --> ", 2);
                this.localDockerProxy.addRoute(TigerRoute.builder().from(kvp[0]).to(kvp[1]).build());
            });
        }
        if (server.getType().equalsIgnoreCase("docker")) {
            this.dockerManager.startContainer(server, configuration, this);
        } else {
            this.dockerManager.startComposition(server, configuration, this);
        }
        this.loadPKIForProxy(server);
        if (server.getPorts() != null && !server.getPorts().isEmpty()) {
            this.routesList.add(TigerRoute.builder().from(HTTP + server.getName()).to("http://localhost:" + server.getPorts().values().iterator().next()).build());
            this.localDockerProxy.addRoute(TigerRoute.builder().from(HTTP + server.getName()).to("http://localhost:" + server.getPorts().values().iterator().next()).build());
        }
        log.info("\u001b[1m\u001b[32mDocker container Startup OK " + server.getSource().get(0) + "\u001b[0m");
    }

    public void initializeExternal(CfgServer server) {
        log.info("\u001b[1m\u001b[32mstarting external instance " + server.getName() + "...\u001b[0m");
        URI uri = new URI(server.getSource().get(0));
        this.localDockerProxy.addRoute(TigerRoute.builder().from(HTTP + server.getName()).to(uri.getScheme() + "://" + uri.getHost()).build());
        this.loadPKIForProxy(server);
        log.info("  Waiting 50% of start up time for external instance  " + server.getName() + " to come up ...");
        long startms = System.currentTimeMillis();
        try {
            Thread.sleep((long)server.getStartupTimeoutSec().intValue() * 500L);
        }
        catch (InterruptedException ie) {
            log.warn("Interruption while waiting for external server to respond!", (Throwable)ie);
            Thread.currentThread().interrupt();
        }
        log.info("  Checking external instance  " + server.getName() + " is available ...");
        try {
            InsecureRestorableTrustAllManager.saveContext();
            InsecureRestorableTrustAllManager.allowAllSSL();
            while (System.currentTimeMillis() - startms < (long)server.getStartupTimeoutSec().intValue() * 1000L) {
                URL url = new URL(server.getHealthcheck());
                URLConnection con = url.openConnection();
                con.setConnectTimeout(1000);
                try {
                    con.connect();
                    log.info("External node " + server.getName() + " is online");
                    log.info("\u001b[1m\u001b[32mExternal server Startup OK " + server.getSource().get(0) + "\u001b[0m");
                    return;
                }
                catch (Exception e) {
                    log.info("Connection failed - " + e.getMessage());
                    Thread.sleep(1000L);
                }
            }
            throw new TigerTestEnvException("Timeout waiting for external server to respond!");
        }
        finally {
            InsecureRestorableTrustAllManager.restoreContext();
        }
    }

    public void initializeExternalJar(CfgServer server) {
        String jarUrl = server.getSource().get(0);
        String jarName = jarUrl.substring(jarUrl.lastIndexOf("/") + 1);
        File jarFile = Paths.get(server.getWorkingDir(), jarName).toFile();
        if (!jarFile.exists()) {
            this.downloadJar(server, jarUrl, jarFile);
        }
        log.info("\u001b[1m\u001b[32mstarting external jar instance " + server.getName() + " in folder " + server.getWorkingDir() + "...\u001b[0m");
        List options = server.getOptions().stream().map(o -> TokenSubstituteHelper.substitute((String)o, (String)"", Map.of("PROXYHOST", "127.0.0.1", "PROXYPORT", this.localDockerProxy.getPort()))).collect(Collectors.toList());
        String[] paths = System.getenv("PATH").split(SystemUtils.IS_OS_WINDOWS ? ";" : ":");
        String javaProg = "java" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
        String javaExe = Arrays.stream(paths).map(path -> Path.of(path, javaProg).toFile()).filter(file -> file.exists() && file.canExecute()).map(File::getAbsolutePath).findAny().orElseThrow(() -> new TigerTestEnvException("Unable to find executable java program in PATH"));
        options.add(0, javaExe);
        options.add("-jar");
        options.add(jarName);
        options.addAll(server.getArguments());
        log.info("executing '" + String.join((CharSequence)" ", options));
        AtomicReference exception = new AtomicReference();
        Thread thread = new Thread(() -> {
            try {
                this.externalProcesses.put(server.getName(), new ProcessBuilder(new String[0]).command((String[])options.toArray(String[]::new)).directory(new File(server.getWorkingDir())).inheritIO().start());
            }
            catch (Throwable t) {
                exception.set(t);
            }
        });
        thread.setName(server.getName());
        thread.start();
        if (!SHUTDOWN_HOOK_ACTIVE) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                log.info("interrupting threads...");
                this.externalProcesses.values().forEach(Process::destroy);
                log.info("stopping threads...");
                this.externalProcesses.values().forEach(Process::destroyForcibly);
            }));
            SHUTDOWN_HOOK_ACTIVE = true;
        }
        if (server.getHealthcheck() == null || server.getHealthcheck().equals("NONE")) {
            log.info("Waiting " + server.getStartupTimeoutSec() + "s to get external jar online...");
            Thread.sleep(server.getStartupTimeoutSec() * 1000);
            return;
        }
        long startms = System.currentTimeMillis();
        try {
            InsecureRestorableTrustAllManager.saveContext();
            InsecureRestorableTrustAllManager.allowAllSSL();
            while (System.currentTimeMillis() - startms < (long)(server.getStartupTimeoutSec() * 1000)) {
                if (exception.get() != null) {
                    throw new TigerTestEnvException("Unable to start external jar!", (Throwable)exception.get());
                }
                URL url = new URL(server.getHealthcheck());
                URLConnection con = url.openConnection();
                con.setConnectTimeout(1000);
                try {
                    con.connect();
                    log.info("External jar node " + server.getName() + " is online");
                    log.info("\u001b[1m\u001b[32mExternal jar server Startup OK " + server.getSource() + "\u001b[0m");
                    return;
                }
                catch (Exception e) {
                    log.info("Failed to connect - " + e.getMessage());
                    Thread.sleep(1000L);
                    if (this.externalProcesses.get(server.getName()).isAlive()) continue;
                    throw new TigerTestEnvException("Process aborted with exit code " + this.externalProcesses.get(server.getName()).exitValue());
                }
            }
            throw new TigerTestEnvException("Timeout while waiting for external jar to start!");
        }
        finally {
            InsecureRestorableTrustAllManager.restoreContext();
        }
    }

    private void downloadJar(CfgServer server, String jarUrl, File jarFile) throws InterruptedException {
        if (jarUrl.startsWith("local:")) {
            throw new TigerTestEnvException("Local jar " + jarFile.getAbsolutePath() + " not found!");
        }
        log.info("downloading jar for external server from " + jarUrl + "...");
        File workDir = new File(server.getWorkingDir());
        if (!workDir.exists() && !workDir.mkdirs()) {
            throw new TigerTestEnvException("Unable to create working directory " + workDir.getAbsolutePath());
        }
        long startms = System.currentTimeMillis();
        AtomicBoolean finished = new AtomicBoolean(false);
        AtomicReference exception = new AtomicReference();
        Thread t = new Thread(() -> {
            try {
                FileUtils.copyURLToFile((URL)new URL(jarUrl), (File)jarFile);
                finished.set(true);
            }
            catch (IOException ioe) {
                exception.set(ioe);
            }
        });
        t.start();
        int progressCtr = 0;
        while (!finished.get()) {
            if (System.currentTimeMillis() - startms > 600000L) {
                t.interrupt();
                t.stop();
                throw new TigerTestEnvException("Download of " + jarUrl + " took longer then 10 minutes!");
            }
            if (exception.get() != null) {
                throw new TigerTestEnvException("Failure while downloading jar " + jarUrl + "!", (Throwable)exception.get());
            }
            Thread.sleep(500L);
            if (++progressCtr != 6) continue;
            log.info("downloaded " + jarFile.length() / 1000L + " kb");
            progressCtr = 0;
        }
    }

    @Override
    public void shutDown(CfgServer server) {
        String type = server.getType();
        if (type.equalsIgnoreCase("externalUrl")) {
            this.shutDownExternal(server);
        } else if (type.equalsIgnoreCase("docker")) {
            this.shutDownDocker(server);
        } else if (type.equalsIgnoreCase("externalJar")) {
            this.shutDownJar(server);
        } else {
            throw new TigerTestEnvException("Unsupported server uri type " + type);
        }
    }

    private void loadPKIForProxy(CfgServer srv) {
        log.info("  loading PKI resources for instance " + srv.getName() + "...");
        srv.getPkiKeys().stream().filter(key -> key.getType().equals("cert")).forEach(key -> {
            log.info("Adding certificate " + key.getId());
            this.getLocalDockerProxy().addKey(key.getId(), (Key)KeyMgr.readCertificateFromPem((String)("-----BEGIN CERTIFICATE-----\n" + key.getPem().replace(" ", "\n") + "\n-----END CERTIFICATE-----")).getPublicKey());
        });
        srv.getPkiKeys().stream().filter(key -> key.getType().equals("key")).forEach(key -> {
            log.info("Adding key " + key.getId());
            this.getLocalDockerProxy().addKey(key.getId(), KeyMgr.readKeyFromPem((String)("-----BEGIN PRIVATE KEY-----\n" + key.getPem().replace(" ", "\n") + "\n-----END PRIVATE KEY-----")));
        });
    }

    private void shutDownDocker(CfgServer server) {
        log.info("Stopping docker container " + server.getName() + "...");
        this.dockerManager.stopContainer(server);
        this.removeRoute(server);
    }

    private void shutDownExternal(CfgServer server) {
        this.removeRoute(server);
    }

    private void shutDownJar(CfgServer server) {
        Process proc = this.externalProcesses.get(server.getName());
        log.info("interrupting thread for " + server.getName() + "...");
        proc.destroy();
        log.info("stopping thread for " + server.getName() + "...");
        proc.destroyForcibly();
        this.removeRoute(server);
    }

    private void removeRoute(CfgServer server) {
        log.info("Removing routes for " + server.getName() + "...");
        Predicate<TigerRoute> isServerRoute = route -> route.getFrom().equals(HTTP + server.getName()) || route.getFrom().equals(HTTPS + server.getName());
        this.routesList.stream().filter(isServerRoute).forEach(r -> this.localDockerProxy.removeRoute(r.getFrom()));
        this.routesList.removeIf(isServerRoute);
    }

    public List<TigerRoute> getRoutes() {
        return this.routesList;
    }

    @Override
    @Generated
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public DockerMgr getDockerManager() {
        return this.dockerManager;
    }

    @Generated
    public Map<String, Object> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Generated
    public TigerProxy getLocalDockerProxy() {
        return this.localDockerProxy;
    }

    @Generated
    public List<TigerRoute> getRoutesList() {
        return this.routesList;
    }

    @Generated
    public Map<String, Process> getExternalProcesses() {
        return this.externalProcesses;
    }
}

