/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.ContainerConfig;
import com.github.dockerjava.api.model.PullResponseItem;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvException;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgEnvSets;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.config.Configuration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.DockerComposeContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.startupcheck.OneShotStartupCheckStrategy;
import org.testcontainers.containers.startupcheck.StartupCheckStrategy;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class DockerMgr {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DockerMgr.class);
    private static final int MOD_ALL_EXEC = 511;
    private static final String CLZPATH = "classpath:";
    private final Map<String, GenericContainer<?>> containers = new HashMap();

    public void startContainer(CfgServer server, Configuration configuration, TigerTestEnvMgr envmgr) {
        Object imageName = server.getSource().get(0);
        if (server.getVersion() != null) {
            imageName = (String)imageName + ":" + server.getVersion();
        }
        DockerImageName imgName = DockerImageName.parse((String)imageName);
        this.pullImage((String)imageName);
        GenericContainer container = new GenericContainer(imgName);
        try {
            InspectImageResponse iiResponse = container.getDockerClient().inspectImageCmd((String)imageName).exec();
            ContainerConfig containerConfig = iiResponse.getConfig();
            if (containerConfig == null) {
                throw new TigerTestEnvException("Docker image '" + (String)imageName + "' has no configuration info!");
            }
            if (server.isProxied()) {
                String[] startCmd = containerConfig.getCmd();
                String[] entryPointCmd = containerConfig.getEntrypoint();
                if (server.getEntryPoint() != null && !server.getEntryPoint().isEmpty()) {
                    entryPointCmd = new String[]{server.getEntryPoint()};
                }
                if (entryPointCmd != null && entryPointCmd[0].equals("/bin/sh") && entryPointCmd[1].equals("-c")) {
                    entryPointCmd = new String[]{"su", containerConfig.getUser(), "-c", "'" + entryPointCmd[2] + "'"};
                }
                File tmpScriptFolder = Path.of("target", "tiger-testenv-mgr").toFile();
                String scriptName = this.createContainerStartupScript(server, iiResponse, startCmd, entryPointCmd);
                String containerScriptPath = containerConfig.getWorkingDir() + "/" + scriptName;
                container.withCopyFileToContainer(MountableFile.forHostPath((Path)Path.of(tmpScriptFolder.getAbsolutePath(), scriptName), (Integer)511), containerScriptPath);
                container.withCreateContainerCmdModifier(cmd -> cmd.withUser("root").withEntrypoint(new String[]{containerScriptPath}));
            }
            container.setLogConsumers(List.of(new Slf4jLogConsumer(log)));
            log.info("Passing in environment:");
            this.addEnvVarsToContainer(container, server.getEnvironment());
            server.getEnvironment().stream().filter(i -> i.startsWith("${")).map(i -> i.substring(2, i.length() - 1)).forEach(envsetName -> {
                List envVars = configuration.getEnvSets().stream().filter(envset -> envset.getName().equals(envsetName)).map(CfgEnvSets::getEnvVars).findAny().orElseThrow(() -> new TigerTestEnvException("Unknown reference to testenv set '" + envsetName));
                this.addEnvVarsToContainer(container, envVars);
            });
            if (server.isOneShot()) {
                container.withStartupCheckStrategy((StartupCheckStrategy)new OneShotStartupCheckStrategy());
            }
            container.start();
            this.waitForHealthyStartup(server, container);
            container.getDockerClient().renameContainerCmd(container.getContainerId()).withName("tiger." + server.getName()).exec();
            this.containers.put(server.getName(), container);
            HashMap<Integer, Integer> ports = new HashMap<Integer, Integer>();
            container.getContainerInfo().getNetworkSettings().getPorts().getBindings().forEach((key, value) -> ports.put(key.getPort(), Integer.valueOf(value[0].getHostPortSpec())));
            server.setPorts(ports);
        }
        catch (DockerException de) {
            throw new TigerTestEnvException("Failed to start container for server " + server.getName(), de);
        }
    }

    public void startComposition(CfgServer server, Configuration configuration, TigerTestEnvMgr envmgr) {
        File folder = Paths.get("target", "tiger-testenv-mgr", server.getName()).toFile();
        if (!folder.exists() && !folder.mkdirs()) {
            throw new TigerTestEnvException("Unable to create temp folder " + folder.getAbsolutePath());
        }
        File[] composeFiles = (File[])server.getSource().stream().map(f -> {
            if (f.startsWith(CLZPATH)) {
                File tmpFile = Paths.get(folder.getAbsolutePath(), f.substring(CLZPATH.length())).toFile();
                InputStream is = this.getClass().getResourceAsStream(f.substring(CLZPATH.length()));
                if (is == null) {
                    throw new TigerTestEnvException("Missing docker compose file in classpath " + f);
                }
                if (!tmpFile.getParentFile().exists() && !tmpFile.getParentFile().mkdirs()) {
                    throw new TigerTestEnvException("Unable to create temp folder " + tmpFile.getParentFile().getAbsolutePath());
                }
                try (FileOutputStream fos = new FileOutputStream(tmpFile);){
                    IOUtils.copy((InputStream)is, (OutputStream)fos);
                    f = tmpFile.getAbsolutePath();
                }
                catch (IOException ioe) {
                    throw new TigerTestEnvException("Unable to create temp docker compose files (" + f + ")", ioe);
                }
            }
            return new File((String)f);
        }).toArray(File[]::new);
        DockerComposeContainer composition = new DockerComposeContainer(composeFiles);
        composition.withLogConsumer("epa-gateway", (Consumer)new Slf4jLogConsumer(log)).withExposedService("epa-gateway", 8001, Wait.forHttp((String)"/").forStatusCode(200).forStatusCode(404).withStartupTimeout(Duration.of(server.getStartupTimeoutSec().intValue(), ChronoUnit.SECONDS))).start();
    }

    private void addEnvVarsToContainer(GenericContainer<?> container, List<String> envVars) {
        envVars.stream().filter(i -> i.contains("=")).map(i -> i.split("=", 2)).forEach(envvar -> {
            log.info("  * " + envvar[0] + "=" + envvar[1]);
            container.addEnv(envvar[0], envvar[1]);
        });
    }

    public void pullImage(String imageName) {
        log.info("Pulling docker image " + imageName + "...");
        final AtomicBoolean pullComplete = new AtomicBoolean();
        pullComplete.set(false);
        final AtomicReference cbException = new AtomicReference();
        DockerClientFactory.instance().client().pullImageCmd(imageName).exec((ResultCallback)new ResultCallback.Adapter<PullResponseItem>(){

            public void onNext(PullResponseItem item) {
                log.debug(item.getStatus() + " " + (item.getProgress() != null ? item.getProgress() : ""));
            }

            public void onError(Throwable throwable) {
                cbException.set(throwable);
            }

            public void onComplete() {
                pullComplete.set(true);
            }
        });
        while (!pullComplete.get()) {
            if (cbException.get() != null) {
                throw new TigerTestEnvException("Unable to pull image " + imageName + "!", (Throwable)cbException.get());
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.warn("Interruption signaled", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        log.info("Docker image " + imageName + " is available locally!");
    }

    private String createContainerStartupScript(CfgServer server, InspectImageResponse iiResponse, String[] startCmd, String[] entryPointCmd) {
        ContainerConfig containerConfig = iiResponse.getConfig();
        if (containerConfig == null) {
            throw new TigerTestEnvException("Docker image of server '" + server.getName() + "' has no configuration info!");
        }
        startCmd = startCmd == null ? new String[]{} : startCmd;
        entryPointCmd = entryPointCmd == null ? new String[]{} : entryPointCmd;
        try {
            String proxycert = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/CertificateAuthorityCertificate.pem")), (Charset)StandardCharsets.UTF_8);
            String lecert = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/letsencrypt.crt")), (Charset)StandardCharsets.UTF_8);
            String risecert = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/idp-rise-tu.crt")), (Charset)StandardCharsets.UTF_8);
            File tmpScriptFolder = Path.of("target", "tiger-testenv-mgr").toFile();
            tmpScriptFolder.mkdirs();
            String scriptName = "__tigerStart_" + server.getName() + ".sh";
            FileUtils.writeStringToFile((File)Path.of(tmpScriptFolder.getAbsolutePath(), scriptName).toFile(), (String)("#!/bin/sh -x\nenv\necho \"" + proxycert + "\" >> /etc/ssl/certs/ca-certificates.crt\necho \"" + lecert + "\" >> /etc/ssl/certs/ca-certificates.crt\necho \"" + risecert + "\" >> /etc/ssl/certs/ca-certificates.crt\n" + this.extractWorkingDirectory(containerConfig) + String.join((CharSequence)" ", entryPointCmd).replace("\t", " ") + " " + String.join((CharSequence)" ", startCmd).replace("\t", " ") + "\n"), (Charset)StandardCharsets.UTF_8);
            return scriptName;
        }
        catch (IOException e) {
            throw new TigerTestEnvException("Failed to configure start script on container for server " + server.getName());
        }
    }

    private String extractWorkingDirectory(ContainerConfig containerConfig) {
        if (containerConfig.getWorkingDir() == null || containerConfig.getWorkingDir().isBlank()) {
            return "";
        }
        return "cd " + containerConfig.getWorkingDir() + "\n";
    }

    private void waitForHealthyStartup(CfgServer server, GenericContainer<?> container) {
        long startms = System.currentTimeMillis();
        long endhalfms = server.getStartupTimeoutSec() == null ? 5000L : (long)server.getStartupTimeoutSec().intValue() * 500L;
        try {
            Thread.sleep(endhalfms);
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while waiting for startup of server " + server.getName(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
        try {
            while (!container.isHealthy()) {
                Thread.sleep(500L);
                if (startms + endhalfms * 2L >= System.currentTimeMillis()) continue;
                throw new TigerTestEnvException("Startup of server %s timed out after %d seconds!", server.getName(), (System.currentTimeMillis() - startms) / 1000L);
            }
            log.info("HealthCheck OK (" + (container.isHealthy() ? 1 : 0) + ") for " + server.getName());
        }
        catch (InterruptedException ie) {
            log.warn("Interruption signaled while waiting for server " + server.getName() + " to start up", (Throwable)ie);
            Thread.currentThread().interrupt();
        }
        catch (TigerTestEnvException ttee) {
            throw ttee;
        }
        catch (RuntimeException rte) {
            int timeout = server.getStartupTimeoutSec() != null ? server.getStartupTimeoutSec() : 20;
            log.warn("probably no health check configured - defaulting to " + timeout + "s startup time");
            try {
                Thread.sleep((long)timeout * 1000L);
            }
            catch (InterruptedException interruptedException) {
                log.warn("Interruption signaled");
                Thread.currentThread().interrupt();
            }
            log.info("HealthCheck UNCLEAR for " + server.getName() + " as no healtcheck is configured, we assume it works and continue setup!");
        }
    }

    public void stopContainer(CfgServer srv) {
        GenericContainer<?> container = this.containers.get(srv.getName());
        if (container != null && container.getDockerClient() != null) {
            container.getDockerClient().stopContainerCmd(container.getContainerId()).exec();
            container.stop();
        }
    }

    public void pauseContainer(CfgServer srv) {
        GenericContainer<?> container = this.containers.get(srv.getName());
        container.getDockerClient().pauseContainerCmd(container.getContainerId()).exec();
    }

    public void unpauseContainer(CfgServer srv) {
        GenericContainer<?> container = this.containers.get(srv.getName());
        container.getDockerClient().unpauseContainerCmd(container.getContainerId()).exec();
    }

    @Generated
    public Map<String, GenericContainer<?>> getContainers() {
        return this.containers;
    }
}

