/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.test.tiger.common.config.ServerType;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.env.TigerServerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.servers.AbstractExternalTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerStatus;
import java.net.MalformedURLException;
import java.net.URL;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class ExternalUrlServer
extends AbstractExternalTigerServer {
    ExternalUrlServer(String serverId, CfgServer configuration, TigerTestEnvMgr tigerTestEnvMgr) {
        super(ExternalUrlServer.determineHostname(configuration, serverId), serverId, configuration, tigerTestEnvMgr);
    }

    @Override
    public void performStartup() {
        this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().type(ServerType.EXTERNALURL).statusMessage("Starting external URL instance " + this.getServerId() + "...").build());
        URL url = this.buildUrl();
        this.addServerToLocalProxyRouteMap(url);
        this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().baseUrl(this.extractBaseUrl(url)).build());
        this.log.info("  Waiting 50% of start up time for external URL instance  {} to come up ...", (Object)this.getServerId());
        this.waitForService(true);
        if (this.getStatus() == TigerServerStatus.STARTING) {
            this.waitForService(false);
        }
    }

    @Override
    public void shutdown() {
        this.log.info("Stopping external url {}...", (Object)this.getServerId());
        this.removeAllRoutes();
        this.setStatus(TigerServerStatus.STOPPED, "Disconnected external url " + this.getServerId());
    }

    @Override
    String getHealthcheckUrl() {
        if (this.getConfiguration().getExternalJarOptions() == null || StringUtils.isEmpty((CharSequence)this.getConfiguration().getHealthcheckUrl())) {
            return (String)this.getConfiguration().getSource().get(0);
        }
        return this.getConfiguration().getHealthcheckUrl();
    }

    private URL buildUrl() {
        try {
            return new URL(this.getTigerTestEnvMgr().replaceSysPropsInString((String)this.getConfiguration().getSource().get(0)));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not parse source URL '" + (String)this.getConfiguration().getSource().get(0) + "'!", e);
        }
    }

    @Generated
    public static ExternalUrlServerBuilder builder() {
        return new ExternalUrlServerBuilder();
    }

    @Generated
    public static class ExternalUrlServerBuilder {
        @Generated
        private String serverId;
        @Generated
        private CfgServer configuration;
        @Generated
        private TigerTestEnvMgr tigerTestEnvMgr;

        @Generated
        ExternalUrlServerBuilder() {
        }

        @Generated
        public ExternalUrlServerBuilder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        @Generated
        public ExternalUrlServerBuilder configuration(CfgServer configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public ExternalUrlServerBuilder tigerTestEnvMgr(TigerTestEnvMgr tigerTestEnvMgr) {
            this.tigerTestEnvMgr = tigerTestEnvMgr;
            return this;
        }

        @Generated
        public ExternalUrlServer build() {
            return new ExternalUrlServer(this.serverId, this.configuration, this.tigerTestEnvMgr);
        }

        @Generated
        public String toString() {
            return "ExternalUrlServer.ExternalUrlServerBuilder(serverId=" + this.serverId + ", configuration=" + this.configuration + ", tigerTestEnvMgr=" + this.tigerTestEnvMgr + ")";
        }
    }
}

