/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.test.tiger.common.config.ServerType;
import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.data.config.CfgDockerOptions;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.env.TigerServerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.servers.TigerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerStatus;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class DockerComposeServer
extends TigerServer {
    DockerComposeServer(String serverId, CfgServer configuration, TigerTestEnvMgr tigerTestEnvMgr) {
        super("", serverId, tigerTestEnvMgr, configuration);
        if (!StringUtils.isBlank((CharSequence)configuration.getHostname())) {
            throw new TigerConfigurationException("Hostname property is not supported for docker compose nodes!");
        }
    }

    @Override
    public void performStartup() {
        this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().type(ServerType.DOCKER_COMPOSE).build());
        this.statusMessage("Starting docker compose for " + this.getServerId() + " from " + this.getDockerSource());
        this.getTigerTestEnvMgr().getDockerManager().startComposition(this);
        this.statusMessage("Docker compose " + this.getServerId() + " started");
    }

    public String getDockerSource() {
        return (String)this.getConfiguration().getSource().get(0);
    }

    public CfgDockerOptions getDockerOptions() {
        return this.getConfiguration().getDockerOptions();
    }

    public List<String> getSource() {
        if (this.getConfiguration().getSource() == null) {
            return List.of();
        }
        return Collections.unmodifiableList(this.getConfiguration().getSource());
    }

    @Override
    public void shutdown() {
        this.log.info("Stopping docker compose {}...", (Object)this.getServerId());
        this.removeAllRoutes();
        this.setStatus(TigerServerStatus.STOPPED, "Docker compose " + this.getServerId() + " stopped");
    }

    @Generated
    public static DockerComposeServerBuilder builder() {
        return new DockerComposeServerBuilder();
    }

    @Generated
    public static class DockerComposeServerBuilder {
        @Generated
        private String serverId;
        @Generated
        private CfgServer configuration;
        @Generated
        private TigerTestEnvMgr tigerTestEnvMgr;

        @Generated
        DockerComposeServerBuilder() {
        }

        @Generated
        public DockerComposeServerBuilder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        @Generated
        public DockerComposeServerBuilder configuration(CfgServer configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public DockerComposeServerBuilder tigerTestEnvMgr(TigerTestEnvMgr tigerTestEnvMgr) {
            this.tigerTestEnvMgr = tigerTestEnvMgr;
            return this;
        }

        @Generated
        public DockerComposeServer build() {
            return new DockerComposeServer(this.serverId, this.configuration, this.tigerTestEnvMgr);
        }

        @Generated
        public String toString() {
            return "DockerComposeServer.DockerComposeServerBuilder(serverId=" + this.serverId + ", configuration=" + this.configuration + ", tigerTestEnvMgr=" + this.tigerTestEnvMgr + ")";
        }
    }
}

